/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.core.Main;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.WindowUserInterfaceControl;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.io.ProblemLoader;
import de.uka.ilkd.key.ui.MediatorProofControl;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunAllProofsAction
extends MainWindowAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunAllProofsAction.class);
    public static final String ENV_VARIABLE = "KEY_RUNALLPROOFS_UI_FILE";
    @Nullable
    private static final String RUN_ALL_PROOFS_UI = System.getenv("KEY_RUNALLPROOFS_UI_FILE");
    private static final String DEFAULT_FILE = "runallproofsui.txt";
    private final File exampleDir;
    private List<File> files;

    @Nonnull
    private List<File> loadFiles() throws IOException {
        InputStream stream;
        LOGGER.info("Use 'export {}=<...>' to set the input file for {}.", (Object)ENV_VARIABLE, (Object)this.getClass().getSimpleName());
        if (RUN_ALL_PROOFS_UI == null) {
            stream = this.getClass().getResourceAsStream(DEFAULT_FILE);
            if (stream == null) {
                LOGGER.error("Could not find {} in the classpath.", (Object)DEFAULT_FILE);
                return Collections.emptyList();
            }
        } else {
            stream = new FileInputStream(RUN_ALL_PROOFS_UI);
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader(stream));){
            List<File> list = in.lines().filter(it -> !it.startsWith("#") && !it.trim().isEmpty()).map(it -> (it.startsWith("/") ? new File((String)it) : new File(this.exampleDir, (String)it)).getAbsoluteFile()).collect(Collectors.toList());
            return list;
        }
    }

    public RunAllProofsAction(MainWindow mainWindow) {
        super(mainWindow);
        Main.ensureExamplesAvailable();
        this.exampleDir = new File(Main.getExamplesDir());
        try {
            this.files = this.loadFiles();
        }
        catch (IOException e) {
            this.files = new ArrayList<File>();
            e.printStackTrace();
        }
        this.setName("Run all proofs");
        this.setTooltip("Open and run a pre-defined set of proofs for GUI testing. Enabled with KeY debug flag");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        WindowUserInterfaceControl ui = this.mainWindow.getUserInterface();
        for (int i = 0; i < this.files.size(); ++i) {
            LOGGER.info("{}: {}\n", (Object)i, (Object)this.files.get(i));
        }
        Runnable runnable = () -> {
            for (File absFile : this.files) {
                ui.reportStatus(this, "Run: " + absFile);
                LOGGER.info("Run: {}", (Object)absFile);
                ProblemLoader problemLoader = ui.getProblemLoader(absFile, null, null, null, this.getMediator());
                problemLoader.runSynchronously();
                LOGGER.info("Loaded: {}", (Object)absFile);
                KeYMediator r = this.getMediator();
                Proof proof = r.getSelectedProof();
                MediatorProofControl control = ui.getProofControl();
                if (control.isAutoModeSupported(proof)) {
                    control.startAutoMode(proof, proof.openEnabledGoals());
                    control.waitWhileAutoMode();
                }
                LOGGER.info("Finish: ({}) {}", (Object)this.getMediator().getSelectedProof().closed(), (Object)absFile);
                this.getMediator().getSelectedProof().dispose();
            }
            LOGGER.info("==== RUN ALL PROOFS FINISHED ==== ");
        };
        Thread t = new Thread(runnable);
        t.start();
    }
}

