/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.smt.SolverListener;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.settings.DefaultSMTSettings;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.smt.SMTProblem;
import de.uka.ilkd.key.smt.SMTSettings;
import de.uka.ilkd.key.smt.SolverLauncher;
import de.uka.ilkd.key.smt.SolverLauncherListener;
import de.uka.ilkd.key.smt.SolverTypeCollection;
import java.awt.event.ActionEvent;
import java.util.Collection;

public class SMTInvokeAction
extends MainWindowAction {
    private static final long serialVersionUID = -8176122007799747342L;
    protected final transient KeYMediator mediator;
    private final transient SolverTypeCollection solverUnion;

    public SMTInvokeAction(SolverTypeCollection solverUnion, MainWindow mainWindow) {
        super(mainWindow);
        this.mediator = mainWindow.getMediator();
        this.solverUnion = solverUnion;
        if (solverUnion != SolverTypeCollection.EMPTY_COLLECTION) {
            this.putValue("ShortDescription", "Invokes " + solverUnion.toString());
        }
    }

    public SolverTypeCollection getSolverUnion() {
        return this.solverUnion;
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled() && this.solverUnion != SolverTypeCollection.EMPTY_COLLECTION && this.mediator != null && this.mediator.getSelectedProof() != null && !this.mediator.getSelectedProof().closed();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.mediator.ensureProofLoaded() || this.solverUnion == SolverTypeCollection.EMPTY_COLLECTION) {
            this.mainWindow.popupWarning("No proof loaded or no solvers selected.", "Oops...");
            return;
        }
        Proof proof = this.mediator.getSelectedProof();
        Thread thread = new Thread(() -> {
            DefaultSMTSettings settings = new DefaultSMTSettings(proof.getSettings().getSMTSettings(), ProofIndependentSettings.DEFAULT_INSTANCE.getSMTSettings(), proof.getSettings().getNewSMTSettings(), proof);
            SolverLauncher launcher = new SolverLauncher((SMTSettings)settings);
            launcher.addListener((SolverLauncherListener)new SolverListener(settings, proof));
            launcher.launch((Collection)this.solverUnion.getTypes(), SMTProblem.createSMTProblems((Proof)proof), proof.getServices());
        }, "SMTRunner");
        thread.start();
    }

    public String toString() {
        return this.solverUnion.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SMTInvokeAction)) {
            return false;
        }
        return this.solverUnion.equals((Object)((SMTInvokeAction)obj).solverUnion);
    }

    public int hashCode() {
        return this.solverUnion.hashCode() * 7;
    }
}

