/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.core.KeYSelectionEvent;
import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.settings.GeneralSettings;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.SettingsListener;
import java.awt.event.ActionEvent;
import java.util.EventObject;

public final class SaveBundleAction
extends MainWindowAction {
    private static final long serialVersionUID = 5275664295885839738L;

    public SaveBundleAction(MainWindow mainWindow) {
        super(mainWindow);
        this.setName("Save Proof as Bundle...");
        this.setIcon(IconFactory.saveBundle(16));
        this.setTooltip("Save current proof as a bundle containing all files to successfully reload the proof (disabled when option \"Allow proof bundle saving\" is set).");
        GeneralSettings settings = ProofIndependentSettings.DEFAULT_INSTANCE.getGeneralSettings();
        settings.addSettingsListener(new SettingsListener(){

            public void settingsChanged(EventObject e) {
                SaveBundleAction.this.updateStatus();
            }
        });
        mainWindow.getMediator().addKeYSelectionListener(new KeYSelectionListener(){

            @Override
            public void selectedNodeChanged(KeYSelectionEvent e) {
            }

            @Override
            public void selectedProofChanged(KeYSelectionEvent e) {
                SaveBundleAction.this.updateStatus();
            }
        });
        this.updateStatus();
    }

    private void updateStatus() {
        this.setEnabled(this.mainWindow.getMediator().getSelectedProof() != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.mainWindow.getMediator().ensureProofLoaded()) {
            Proof selectedProof = this.mainWindow.getMediator().getSelectedProof();
            this.mainWindow.getUserInterface().saveProofBundle(selectedProof);
        } else {
            this.mainWindow.popupWarning("No proof.", "Oops...");
        }
    }
}

