/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.IssueDialog;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.parser.Location;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.io.OutputStreamProofSaver;
import de.uka.ilkd.key.settings.ProofSettings;
import de.uka.ilkd.key.util.ExceptionTools;
import de.uka.ilkd.key.util.KeYConstants;
import de.uka.ilkd.key.util.KeYResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.html.HTMLEditorKit;
import org.key_project.util.Streams;
import org.key_project.util.java.IOUtil;

public class SendFeedbackAction
extends AbstractAction {
    private static final long serialVersionUID = 8146108238901822515L;
    private static final String FEEDBACK_RECIPIENT = "support@key-project.org";
    private static final String REPORT_URL = "https://formal.kastel.kit.edu/key/key-report.php";
    private final SendFeedbackItem[] items = new SendFeedbackItem[]{new StacktraceItem(), new FaultyFileItem(), new LastLoadedProblemItem(), new VersionItem(), new SystemPropertiesItem(), new OpenGoalItem(), new OpenProofItem(), new SettingsItem(), new JavaSourceItem()};
    private final Throwable throwable;
    private final Window parent;

    private static String serializeStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private void saveZIP(String message) {
        try {
            JFileChooser jfc = new JFileChooser();
            jfc.addChoosableFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.getName().toLowerCase().endsWith(".zip");
                }

                @Override
                public String getDescription() {
                    return "ZIP archives";
                }
            });
            int answer = jfc.showSaveDialog(this.parent);
            if (answer == 0) {
                this.saveMetaDataToFile(jfc.getSelectedFile(), message);
                JOptionPane.showMessageDialog(this.parent, String.format("Your message has been saved to the file %s.\nIf you want to report a bug, you can enclose this file in an\ne-mail to support@key-project.org.", jfc.getSelectedFile()));
            }
        }
        catch (Exception e) {
            IssueDialog.showExceptionDialog(this.parent, e);
        }
    }

    private void sendReport(String message) {
        String[] msgs = new String[]{"The data you have collected and the description text will now be sent via", "https to the server formal.kastel.kit.edu, stored on the server and forwarded", "to the KeY mailing list.", "", "Click OK if you want to send the report now."};
        int answer = JOptionPane.showConfirmDialog(this.parent, msgs, "Ready to send?", 0);
        if (answer != 0) {
            return;
        }
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            this.saveMetaData(buffer, message);
            URLConnection connection = new URL(REPORT_URL).openConnection();
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/zip");
            connection.setRequestProperty("KeY-Version", "KeY " + KeYResourceManager.getManager().getVersion());
            try (OutputStream os = connection.getOutputStream();){
                os.write(buffer.toByteArray());
            }
            connection.connect();
            int responseCode = ((HttpURLConnection)connection).getResponseCode();
            if (responseCode != 200) {
                String msg = Streams.toString((InputStream)((HttpURLConnection)connection).getErrorStream());
                throw new IOException("The server responded with an error message (" + responseCode + "): " + msg);
            }
            JOptionPane.showMessageDialog(this.parent, "Your report has been filed successfully.");
        }
        catch (Exception e) {
            IssueDialog.showExceptionDialog(this.parent, e);
        }
    }

    private void saveMetaDataToFile(File zipFile, String message) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(zipFile);){
            this.saveMetaData(fos, message);
        }
    }

    private void saveMetaData(OutputStream os, String message) throws IOException {
        try (ZipOutputStream stream = new ZipOutputStream(new BufferedOutputStream(os));){
            for (SendFeedbackItem item : this.items) {
                if (!item.isSelected() || !item.isEnabled()) continue;
                item.appendDataToZipOutputStream(stream);
            }
            stream.putNextEntry(new ZipEntry("bugDescription.txt"));
            stream.write(message.getBytes());
            stream.closeEntry();
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(this.parent, e.getMessage());
        }
    }

    public SendFeedbackAction(Window parent) {
        this(parent, null);
    }

    public SendFeedbackAction(Window parent, Throwable exception) {
        this.parent = parent;
        this.putValue("Name", "Send feedback...");
        this.throwable = exception;
    }

    private JDialog makeDialog() {
        JDialog dialog = new JDialog(this.parent, "Report an error to KeY developers", Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setDefaultCloseOperation(2);
        JPanel right = new JPanel();
        right.setLayout(new BoxLayout(right, 1));
        for (SendFeedbackItem item : this.items) {
            JCheckBox box = new JCheckBox(item.displayName);
            if (item.isEnabled()) {
                box.setSelected(item.isSelected());
                box.addActionListener(item);
            } else {
                box.setSelected(false);
                box.setEnabled(false);
            }
            right.add(box);
        }
        JTextArea bugDescription = new JTextArea(20, 50);
        bugDescription.setLineWrap(true);
        bugDescription.setBorder(new TitledBorder("Message to Developers"));
        JScrollPane left = new JScrollPane(bugDescription);
        left.setVerticalScrollBarPolicy(20);
        left.setHorizontalScrollBarPolicy(30);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        topPanel.add(left);
        topPanel.add(right);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton saveFeedbackReportButton = new JButton("Save Feedback...");
        saveFeedbackReportButton.setToolTipText("<html>Information about current proof state are saved to a file.<br>This file can be also used when reporting a bug via e-mail.");
        saveFeedbackReportButton.addActionListener(e -> {
            this.saveZIP(bugDescription.getText());
            dialog.dispose();
        });
        JButton sendFeedbackReportButton = new JButton("Send Feedback...");
        sendFeedbackReportButton.setToolTipText("<html>Information about current proof state are sent via a secure https connection to the developers.<br>The receiving server is located at KIT (formal.kastel.kit.edu).");
        sendFeedbackReportButton.addActionListener(e -> {
            this.sendReport(bugDescription.getText());
            dialog.dispose();
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> dialog.dispose());
        buttonPanel.add(saveFeedbackReportButton);
        buttonPanel.add(sendFeedbackReportButton);
        buttonPanel.add(cancelButton);
        JTextPane labels = new JTextPane();
        labels.setEditorKit(new HTMLEditorKit());
        labels.setEditable(false);
        labels.setBackground(UIManager.getColor("Label.background"));
        labels.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        labels.setText("<html>The report feature can be used to send information about your current state of KeY to report a bug or to ask for advice from the KeY team.<br>You can either store the information in a zip locally (and then e.g. send that via e-mail to support@key-project.org) or send directly to our server.<br>Please select the information that you want to include from the list on the right.<br>If you send the information directly, <b>please make sure to indicate your e-mail address</b> in the message below such that the team can respond.");
        Container container = dialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)labels, "North");
        container.add((Component)topPanel, "Center");
        container.add((Component)buttonPanel, "South");
        dialog.pack();
        return dialog;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JDialog dialog = this.makeDialog();
        dialog.setLocationRelativeTo(this.parent);
        dialog.setVisible(true);
    }

    private static class JavaSourceItem
    extends SendFeedbackItem {
        public JavaSourceItem() {
            super("Send Java source");
        }

        @Override
        boolean isEnabled() {
            try {
                Proof proof = MainWindow.getInstance().getMediator().getSelectedProof();
                File javaSourceLocation = OutputStreamProofSaver.getJavaSourceLocation((Proof)proof);
                return javaSourceLocation != null;
            }
            catch (Exception e) {
                return false;
            }
        }

        private void getJavaFilesRecursively(File directory, List<File> list) {
            for (File f : directory.listFiles()) {
                if (f.isDirectory()) {
                    this.getJavaFilesRecursively(f, list);
                    continue;
                }
                if (!f.getName().endsWith(".java")) continue;
                list.add(f);
            }
        }

        @Override
        void appendDataToZipOutputStream(ZipOutputStream stream) throws IOException {
            Proof proof = MainWindow.getInstance().getMediator().getSelectedProof();
            File javaSourceLocation = OutputStreamProofSaver.getJavaSourceLocation((Proof)proof);
            LinkedList<File> javaFiles = new LinkedList<File>();
            this.getJavaFilesRecursively(javaSourceLocation, javaFiles);
            for (File f : javaFiles) {
                stream.putNextEntry(new ZipEntry("javaSource/" + javaSourceLocation.toURI().relativize(f.toURI())));
                stream.write(Files.readAllBytes(f.toPath()));
                stream.closeEntry();
            }
        }
    }

    private class FaultyFileItem
    extends SendFeedbackFileItem {
        FaultyFileItem() {
            super("Send file referenced by exception", "exceptionSourceFile.txt");
        }

        @Override
        boolean isEnabled() {
            if (SendFeedbackAction.this.throwable != null) {
                Location location = null;
                try {
                    location = ExceptionTools.getLocation((Throwable)SendFeedbackAction.this.throwable);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return false;
                }
                return Location.isValidLocation((Location)location);
            }
            return false;
        }

        @Override
        byte[] retrieveFileData() throws IOException {
            Location location = ExceptionTools.getLocation((Throwable)SendFeedbackAction.this.throwable);
            String source = IOUtil.readFrom((URL)location.getFileURL());
            return source.getBytes(Charset.defaultCharset());
        }
    }

    private class StacktraceItem
    extends SendFeedbackFileItem {
        StacktraceItem() {
            super("Send stacktrace", "stacktrace.txt");
        }

        @Override
        boolean isEnabled() {
            return SendFeedbackAction.this.throwable != null;
        }

        @Override
        byte[] retrieveFileData() {
            return SendFeedbackAction.serializeStackTrace(SendFeedbackAction.this.throwable).getBytes();
        }
    }

    private static class SettingsItem
    extends SendFeedbackFileItem {
        SettingsItem() {
            super("Send KeY settings", "keySettings.txt");
        }

        @Override
        byte[] retrieveFileData() {
            return ProofSettings.DEFAULT_SETTINGS.settingsToString().getBytes();
        }
    }

    private class OpenProofItem
    extends SendFeedbackFileItem {
        OpenProofItem() {
            super("Send open proof", "openProof.proof");
        }

        @Override
        byte[] retrieveFileData() throws IOException {
            KeYMediator mediator = MainWindow.getInstance().getMediator();
            Proof proof = mediator.getSelectedProof();
            OutputStreamProofSaver saver = new OutputStreamProofSaver(proof);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            saver.save((OutputStream)stream);
            return stream.toByteArray();
        }

        @Override
        boolean isEnabled() {
            try {
                Proof proof = MainWindow.getInstance().getMediator().getSelectedProof();
                return proof != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    private class OpenGoalItem
    extends SendFeedbackFileItem {
        OpenGoalItem() {
            super("Send open proof goal", "openGoal.txt");
        }

        @Override
        byte[] retrieveFileData() {
            KeYMediator mediator = MainWindow.getInstance().getMediator();
            Goal goal = mediator.getSelectedGoal();
            return goal.toString().getBytes();
        }

        @Override
        boolean isEnabled() {
            try {
                Goal g = MainWindow.getInstance().getMediator().getSelectedGoal();
                return g != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    private static class SystemPropertiesItem
    extends SendFeedbackFileItem {
        SystemPropertiesItem() {
            super("Send system properties", "systemProperties.txt");
        }

        @Override
        byte[] retrieveFileData() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            System.getProperties().list(pw);
            String propsAsString = sw.getBuffer().toString();
            pw.close();
            return propsAsString.getBytes();
        }
    }

    private static class VersionItem
    extends SendFeedbackFileItem {
        VersionItem() {
            super("Send KeY version", "keyVersion.txt");
        }

        @Override
        byte[] retrieveFileData() {
            return KeYConstants.VERSION.getBytes();
        }
    }

    private static class LastLoadedProblemItem
    extends SendFeedbackFileItem {
        LastLoadedProblemItem() {
            super("Send last loaded problem", "lastLoadedProblem.key");
        }

        @Override
        byte[] retrieveFileData() throws Exception {
            File mostRecentFile = new File(MainWindow.getInstance().getRecentFiles().getMostRecent().getAbsolutePath());
            return Files.readAllBytes(mostRecentFile.toPath());
        }

        @Override
        boolean isEnabled() {
            try {
                String file = MainWindow.getInstance().getRecentFiles().getMostRecent().getAbsolutePath();
                return file != null && file.length() != 0;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    private static abstract class SendFeedbackFileItem
    extends SendFeedbackItem {
        final String fileName;

        SendFeedbackFileItem(String displayName, String fileName) {
            super(displayName);
            this.fileName = fileName;
        }

        abstract byte[] retrieveFileData() throws Exception;

        @Override
        void appendDataToZipOutputStream(ZipOutputStream stream) throws IOException {
            byte[] data;
            Object zipEntryFileName = this.fileName;
            try {
                data = this.retrieveFileData();
            }
            catch (Exception e) {
                zipEntryFileName = (String)zipEntryFileName + ".exception";
                data = (e.getClass().getSimpleName() + " occured while trying to read data.\n" + e.getMessage() + "\n" + SendFeedbackAction.serializeStackTrace(e)).getBytes();
            }
            stream.putNextEntry(new ZipEntry((String)zipEntryFileName));
            stream.write(data);
            stream.closeEntry();
        }
    }

    private static abstract class SendFeedbackItem
    implements ActionListener {
        final String displayName;
        private boolean selected = true;

        SendFeedbackItem(String displayName) {
            this.displayName = displayName;
        }

        boolean isEnabled() {
            return true;
        }

        boolean isSelected() {
            return this.selected;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.selected = ((JCheckBox)e.getSource()).isSelected();
        }

        abstract void appendDataToZipOutputStream(ZipOutputStream var1) throws IOException;
    }
}

