/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.gui.smt.OptionContentNode;
import de.uka.ilkd.key.logic.Choice;
import de.uka.ilkd.key.settings.ChoiceSettings;
import de.uka.ilkd.key.settings.GeneralSettings;
import de.uka.ilkd.key.settings.LemmaGeneratorSettings;
import de.uka.ilkd.key.settings.ProofDependentSMTSettings;
import de.uka.ilkd.key.settings.ProofIndependentSMTSettings;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.ProofSettings;
import de.uka.ilkd.key.settings.Settings;
import de.uka.ilkd.key.settings.StrategySettings;
import de.uka.ilkd.key.settings.TermLabelSettings;
import de.uka.ilkd.key.settings.ViewSettings;
import java.util.Map;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class SettingsTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = -3282304543262262159L;
    private ProofSettings proofSettings;
    private ProofIndependentSettings independentSettings;

    public SettingsTreeModel(ProofSettings proofSettings, ProofIndependentSettings independentSettings) {
        super(new DefaultMutableTreeNode("All Settings"));
        this.proofSettings = proofSettings;
        this.independentSettings = independentSettings;
        this.generateTree();
    }

    private void generateTree() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
        OptionContentNode proofSettingsNode = this.generateOptionContentNode("Proof Settings", "These are the proof dependent settings.");
        root.add(proofSettingsNode);
        ChoiceSettings choiceSettings = ProofSettings.DEFAULT_SETTINGS.getChoiceSettings();
        proofSettingsNode.add(this.generateTableNode("Taclets", choiceSettings));
        StrategySettings strategySettings = this.proofSettings.getStrategySettings();
        proofSettingsNode.add(this.generateTableNode("Strategy", (Settings)strategySettings));
        ProofDependentSMTSettings smtSettings = this.proofSettings.getSMTSettings();
        proofSettingsNode.add(this.generateTableNode("SMT", (Settings)smtSettings));
        OptionContentNode independentSettingsNode = this.generateOptionContentNode("Proof-Independent Settings", "These are the proof independent settings.");
        root.add(independentSettingsNode);
        GeneralSettings generalSettings = this.independentSettings.getGeneralSettings();
        independentSettingsNode.add(this.generateTableNode("General", (Settings)generalSettings));
        LemmaGeneratorSettings lemmaSettings = this.independentSettings.getLemmaGeneratorSettings();
        independentSettingsNode.add(this.generateTableNode("Lemma Generator", (Settings)lemmaSettings));
        ProofIndependentSMTSettings indSMTSettings = this.independentSettings.getSMTSettings();
        independentSettingsNode.add(this.generateTableNode("SMT", (Settings)indSMTSettings));
        ViewSettings viewSettings = this.independentSettings.getViewSettings();
        independentSettingsNode.add(this.generateTableNode("View", (Settings)viewSettings));
        TermLabelSettings termLabelSettings = this.independentSettings.getTermLabelSettings();
        proofSettingsNode.add(this.generateTableNode("Term Labels", (Settings)termLabelSettings));
    }

    public JComponent getStartComponent() {
        return this.generateScrollPane("Here are all settings.");
    }

    private Properties getChoicesAsProperties(ChoiceSettings settings) {
        Properties prop = new Properties();
        for (Choice choice : settings.getDefaultChoicesAsSet()) {
            prop.put(choice.category(), choice.name());
        }
        return prop;
    }

    private OptionContentNode generateTableNode(String title, Settings settings) {
        Properties props = new Properties();
        settings.writeSettings(props);
        return new OptionContentNode(title, this.generateJTable(props));
    }

    private OptionContentNode generateTableNode(String title, ChoiceSettings settings) {
        Properties props = this.getChoicesAsProperties(settings);
        return new OptionContentNode(title, this.generateJTable(props));
    }

    private JComponent generateScrollPane(String text) {
        JTextArea ta = new JTextArea(5, 20);
        ta.append(text);
        ta.setEditable(false);
        JScrollPane scrollpane = new JScrollPane(ta);
        return scrollpane;
    }

    private JComponent generateJTable(Properties properties) {
        Object[] columnNames = new String[]{"Name", "Value"};
        Object[][] data = new Object[properties.entrySet().size()][2];
        int i = 0;
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            data[i][0] = entry.getKey();
            data[i][1] = entry.getValue();
            ++i;
        }
        JTable table = new JTable();
        DefaultTableModel tableModel = new DefaultTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        tableModel.setDataVector(data, columnNames);
        table.setModel(tableModel);
        JScrollPane scrollpane = new JScrollPane(table);
        return scrollpane;
    }

    private OptionContentNode generateOptionContentNode(String title, String text) {
        return new OptionContentNode(title, this.generateScrollPane(text));
    }
}

