/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.actions.SettingsTreeModel;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.smt.OptionContentNode;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.ProofSettings;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ShowActiveSettingsAction
extends MainWindowAction {
    private static final long serialVersionUID = -3038735283059371442L;

    public ShowActiveSettingsAction(MainWindow mainWindow) {
        super(mainWindow);
        this.setName("Show All Active Settings");
        this.setIcon(IconFactory.properties(16));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ProofSettings settings = this.getMediator().getSelectedProof() == null ? ProofSettings.DEFAULT_SETTINGS : this.getMediator().getSelectedProof().getSettings();
        SettingsTreeModel model = new SettingsTreeModel(settings, ProofIndependentSettings.DEFAULT_INSTANCE);
        ViewSettingsDialog dialog = new ViewSettingsDialog(model, model.getStartComponent());
        dialog.setTitle("All active settings");
        dialog.setLocationRelativeTo(this.mainWindow);
        dialog.setVisible(true);
    }

    private class ViewSettingsDialog
    extends JDialog {
        private static final long serialVersionUID = -3780496399924182275L;
        private JTree optionTree;
        private JSplitPane splitPane;
        private JPanel optionPanel;

        public ViewSettingsDialog(TreeModel model, JComponent startComponent) {
            super(ShowActiveSettingsAction.this.mainWindow);
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            Box box = Box.createHorizontalBox();
            box.add(this.getSplitPane());
            this.getContentPane().add(box);
            this.getContentPane().add(Box.createVerticalStrut(5));
            box = Box.createHorizontalBox();
            box.add(Box.createHorizontalStrut(5));
            JButton okButton = new JButton("OK");
            okButton.addActionListener(e -> this.dispose());
            this.setDefaultCloseOperation(2);
            box.add(okButton);
            box.add(Box.createHorizontalStrut(5));
            this.getContentPane().add(box);
            this.getOptionTree().setModel(model);
            this.getSplitPane().setRightComponent(startComponent);
            this.getOptionTree().getParent().setMinimumSize(this.getOptionTree().getPreferredSize());
            this.getContentPane().setPreferredSize(this.computePreferredSize(model));
            this.setLocationByPlatform(true);
            this.setDefaultCloseOperation(2);
            this.setIconImage(IconFactory.keyLogo());
            this.pack();
            this.getRootPane().registerKeyboardAction(e -> this.dispose(), KeyStroke.getKeyStroke(27, 0), 2);
            this.getRootPane().setDefaultButton(okButton);
        }

        private Dimension computePreferredSize(TreeModel model) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getRoot();
            Dimension dim = this.computePreferredSize(node);
            dim.width = dim.width + this.getOptionTree().getPreferredSize().width + 100;
            dim.height = Math.min(dim.height, 400);
            return dim;
        }

        private Dimension computePreferredSize(DefaultMutableTreeNode node) {
            Dimension dim = node instanceof OptionContentNode ? new Dimension(((OptionContentNode)node).getComponent().getPreferredSize()) : new Dimension(0, 0);
            for (int i = 0; i < node.getChildCount(); ++i) {
                Dimension dimChild = this.computePreferredSize((DefaultMutableTreeNode)node.getChildAt(i));
                dim.width = Math.max(dimChild.width, dim.width);
                dim.height = Math.max(dimChild.height, dim.height);
            }
            return dim;
        }

        private JTree getOptionTree() {
            if (this.optionTree == null) {
                this.optionTree = new JTree();
                this.optionTree.addTreeSelectionListener(e -> {
                    Object node;
                    TreePath path = e.getNewLeadSelectionPath();
                    if (path != null && (node = path.getLastPathComponent()) != null && node instanceof OptionContentNode) {
                        this.getSplitPane().setRightComponent(((OptionContentNode)node).getComponent());
                    }
                });
            }
            return this.optionTree;
        }

        private JSplitPane getSplitPane() {
            if (this.splitPane == null) {
                this.splitPane = new JSplitPane();
                this.splitPane.setAlignmentX(0.0f);
                this.splitPane.setLeftComponent(new JScrollPane(this.getOptionTree()));
                this.splitPane.setRightComponent(this.getOptionPanel());
            }
            return this.splitPane;
        }

        private JPanel getOptionPanel() {
            if (this.optionPanel == null) {
                this.optionPanel = new JPanel();
            }
            return this.optionPanel;
        }
    }
}

