/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.notification.events.GeneralInformationEvent;
import de.uka.ilkd.key.proof.Proof;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class ShowActiveTactletOptionsAction
extends MainWindowAction {
    private static final long serialVersionUID = -7012564698194718532L;

    public ShowActiveTactletOptionsAction(MainWindow mainWindow) {
        super(mainWindow);
        this.setName("Show Active Taclet Options");
        this.getMediator().enableWhenProofLoaded(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.showActivatedChoices();
    }

    private void showActivatedChoices() {
        Proof currentProof = this.getMediator().getSelectedProof();
        if (currentProof == null) {
            this.mainWindow.notify(new GeneralInformationEvent("No Options available.", "If you wish to see Taclet Options for a proof you have to load one first"));
        } else {
            Object message = "Active Taclet Options:\n";
            int rows = 0;
            int columns = 0;
            for (String choice : currentProof.getSettings().getChoiceSettings().getDefaultChoices().values()) {
                message = (String)message + choice + "\n";
                ++rows;
                if (columns >= choice.length()) continue;
                columns = choice.length();
            }
            JTextArea activeOptions = new JTextArea((String)message, rows, columns);
            activeOptions.setEditable(false);
            Object[] toDisplay = new Object[]{activeOptions, "These options can be changed in Options->Taclet Options"};
            JOptionPane.showMessageDialog(this.mainWindow, toDisplay, "Taclet options used in the current proof", 1);
        }
    }
}

