/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.gui.ClassTree;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.notification.events.GeneralInformationEvent;
import de.uka.ilkd.key.gui.utilities.GuiUtilities;
import de.uka.ilkd.key.proof.Proof;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class ShowKnownTypesAction
extends MainWindowAction {
    private static final long serialVersionUID = 4368162229726580799L;

    public ShowKnownTypesAction(MainWindow mainWindow) {
        super(mainWindow);
        this.setName("Show Known Types");
        this.getMediator().enableWhenProofLoaded(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.showTypeHierarchy();
    }

    private void showTypeHierarchy() {
        Proof currentProof = this.getMediator().getSelectedProof();
        if (currentProof == null) {
            this.mainWindow.notify(new GeneralInformationEvent("No Type Hierarchy available.", "If you wish to see the types for a proof you have to load one first"));
        } else {
            JDialog dialog = new JDialog(this.mainWindow, "Known types for this proof", true);
            dialog.setDefaultCloseOperation(2);
            Container pane = dialog.getContentPane();
            pane.setLayout(new BorderLayout());
            JTabbedPane tabbedPane = new JTabbedPane();
            pane.add((Component)tabbedPane, "Center");
            JScrollPane scrollpane = new JScrollPane();
            ClassTree classTree = new ClassTree(false, false, currentProof.getServices());
            classTree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            scrollpane.setViewportView(classTree);
            tabbedPane.addTab("Package view", scrollpane);
            JButton okButton = new JButton("OK");
            okButton.addActionListener(e -> {
                dialog.setVisible(false);
                dialog.dispose();
            });
            JPanel panel = new JPanel();
            panel.add(okButton);
            pane.add((Component)panel, "South");
            dialog.getRootPane().setDefaultButton(okButton);
            GuiUtilities.attachClickOnEscListener(okButton);
            dialog.setSize(300, 400);
            dialog.setLocationRelativeTo(this.mainWindow);
            dialog.setVisible(true);
        }
    }
}

