/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.gui.KeYFileChooser;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.notification.events.GeneralInformationEvent;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.Statistics;
import de.uka.ilkd.key.util.MiscTools;
import de.uka.ilkd.key.util.Pair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowProofStatistics
extends MainWindowAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShowProofStatistics.class);
    private static final long serialVersionUID = -8814798230037775905L;

    public ShowProofStatistics(MainWindow mainWindow) {
        super(mainWindow);
        this.setName("Show Proof Statistics");
        this.setIcon(IconFactory.statistics(16));
        this.getMediator().enableWhenProofLoaded(this);
        this.lookupAcceleratorKey();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Proof proof = this.getMediator().getSelectedProof();
        if (proof == null) {
            this.mainWindow.notify(new GeneralInformationEvent("No statistics available.", "If you wish to see the statistics for a proof you have to load one first"));
        } else {
            Window win = new Window(this.mainWindow, proof);
            win.setVisible(true);
        }
    }

    public static String getCSVStatisticsMessage(Proof proof) {
        int openGoals = proof.openGoals().size();
        Object stats = "";
        stats = (String)stats + "open goals," + openGoals + "\n";
        Statistics s = proof.getStatistics();
        for (Pair x : s.getSummary()) {
            if ("".equals(x.second)) {
                stats = (String)stats + (String)x.first + "\n";
                continue;
            }
            stats = (String)stats + (String)x.first + "," + (String)x.second + "\n";
        }
        if (s.interactiveSteps > 0) {
            TreeSet<Map.Entry<String, Integer>> sortedEntries = new TreeSet<Map.Entry<String, Integer>>(new Comparator<Map.Entry<String, Integer>>(){

                @Override
                public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                    int cmpRes = o2.getValue().compareTo(o1.getValue());
                    if (cmpRes == 0) {
                        cmpRes = o1.getKey().compareTo(o2.getKey());
                    }
                    return cmpRes;
                }
            });
            sortedEntries.addAll(s.getInteractiveAppsDetails().entrySet());
            for (Map.Entry entry : sortedEntries) {
                stats = (String)stats + "interactive," + (String)entry.getKey() + "," + entry.getValue() + "\n";
            }
        }
        return stats;
    }

    public static String getHTMLStatisticsMessage(Proof proof) {
        int openGoals = proof.openGoals().size();
        Object stats = "<html><head><style type=\"text/css\">body {font-weight: normal; text-align: center;}td {padding: 1px;}th {padding: 2px; font-weight: bold;}</style></head><body>";
        stats = openGoals > 0 ? (String)stats + "<strong>" + openGoals + " open goal" + (openGoals > 1 ? "s." : ".") + "</strong>" : (String)stats + "<strong>Proved.</strong>";
        stats = (String)stats + "<br/><br/><table>";
        Statistics s = proof.getStatistics();
        for (Pair x : s.getSummary()) {
            if ("".equals(x.second)) {
                stats = (String)stats + "<tr><th colspan=\"2\">" + (String)x.first + "</th></tr>";
                continue;
            }
            stats = (String)stats + "<tr><td>" + (String)x.first + "</td><td>" + (String)x.second + "</td></tr>";
        }
        if (s.interactiveSteps > 0) {
            stats = (String)stats + "<tr><th colspan=\"2\">Details on Interactive Apps</th></tr>";
            TreeSet<Map.Entry<String, Integer>> sortedEntries = new TreeSet<Map.Entry<String, Integer>>(new Comparator<Map.Entry<String, Integer>>(){

                @Override
                public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                    int cmpRes = o2.getValue().compareTo(o1.getValue());
                    if (cmpRes == 0) {
                        cmpRes = o1.getKey().compareTo(o2.getKey());
                    }
                    return cmpRes;
                }
            });
            sortedEntries.addAll(s.getInteractiveAppsDetails().entrySet());
            for (Map.Entry entry : sortedEntries) {
                stats = (String)stats + "<tr><td>" + (String)entry.getKey() + "</td><td>" + entry.getValue() + "</td></tr>";
            }
        }
        stats = (String)stats + "</table></body></html>";
        return stats;
    }

    public static final class Window
    extends JDialog {
        private static final long serialVersionUID = 1266280148508192284L;

        public Window(MainWindow mainWindow, Proof proof) {
            super((Frame)mainWindow, "Proof Statistics");
            String stats = ShowProofStatistics.getHTMLStatisticsMessage(proof);
            JEditorPane statisticsPane = new JEditorPane("text/html", stats);
            statisticsPane.setEditable(false);
            statisticsPane.setBorder(BorderFactory.createEmptyBorder());
            statisticsPane.setCaretPosition(0);
            statisticsPane.setBackground(MainWindow.getInstance().getBackground());
            statisticsPane.setSize(new Dimension(10, 360));
            statisticsPane.setPreferredSize(new Dimension(statisticsPane.getPreferredSize().width + 15, 360));
            JScrollPane scrollPane = new JScrollPane(statisticsPane);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            Font myFont = UIManager.getFont("KEY_FONT_PROOF_TREE");
            if (myFont != null) {
                statisticsPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
                statisticsPane.setFont(myFont);
            } else {
                LOGGER.debug("KEY_FONT_PROOF_TREE not available. Use standard font.");
            }
            JPanel buttonPane = new JPanel();
            JButton okButton = new JButton("Close");
            okButton.addActionListener(event -> this.dispose());
            JButton csvButton = new JButton("Export as CSV");
            csvButton.addActionListener(event -> this.export("csv", MiscTools.toValidFileName((String)proof.name().toString()), ShowProofStatistics.getCSVStatisticsMessage(proof)));
            JButton htmlButton = new JButton("Export as HTML");
            htmlButton.addActionListener(event -> this.export("html", MiscTools.toValidFileName((String)proof.name().toString()), ShowProofStatistics.getHTMLStatisticsMessage(proof)));
            buttonPane.add(okButton);
            buttonPane.add(csvButton);
            buttonPane.add(htmlButton);
            this.getRootPane().setDefaultButton(okButton);
            this.getRootPane().addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        this.getRootPane().getDefaultButton().doClick();
                    }
                }
            });
            this.setLayout(new BorderLayout());
            this.add((Component)scrollPane, "Center");
            this.add((Component)buttonPane, "Last");
            int w = 50 + Math.max(scrollPane.getPreferredSize().width, buttonPane.getPreferredSize().width);
            int h = scrollPane.getPreferredSize().height + buttonPane.getPreferredSize().height + 100;
            this.setSize(w, h);
            this.setLocationRelativeTo(mainWindow);
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                this.requestFocus();
            }
        }

        private void export(String fileExtension, String fileName, String text) {
            block8: {
                KeYFileChooser fileChooser = KeYFileChooser.getFileChooser("Choose filename to save statistics");
                fileChooser.setFileFilter(KeYFileChooser.STATISTICS_FILTER);
                fileChooser.setSelectedFile(new File(fileName + "." + fileExtension));
                int result = fileChooser.showSaveDialog(this);
                if (result == 0) {
                    File file = fileChooser.getSelectedFile();
                    try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));){
                        writer.write(text);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError();
                    }
                }
            }
        }
    }
}

