/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.util.KeYConstants;
import java.awt.event.ActionEvent;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SystemInfoAction
extends MainWindowAction {
    private static final long serialVersionUID = -4197309658998177157L;
    private static final int TEXT_ROWS = 20;
    private static final int TEXT_COLS = 60;

    public SystemInfoAction(MainWindow mainWindow) {
        super(mainWindow);
        this.setName("System Info");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        Object[] contents = new Object[6];
        contents[0] = "KeY info:\n";
        String params = System.getProperty("sun.java.command");
        if (params == null) {
            params = "(unknown)";
        }
        if ((i = params.indexOf("Main")) > 0) {
            params = params.substring(i + 4);
        }
        RuntimeMXBean rmb = ManagementFactory.getRuntimeMXBean();
        String keyInfoText = "Version: " + KeYConstants.VERSION + "\nKeY parameters: " + params + "\nVM parameters: " + this.formatList(rmb.getInputArguments());
        JTextArea keyInfo = new JTextArea(keyInfoText, 3, 60);
        keyInfo.setEditable(false);
        contents[1] = keyInfo;
        contents[2] = this.getMemoryInfo() + "\n\nEnvironment variables:\n";
        JScrollPane scroll = new JScrollPane();
        JTextArea text = new JTextArea(this.getEnv(), 6, 40);
        text.setEditable(false);
        text.setCaretPosition(0);
        scroll.setViewportView(text);
        contents[3] = scroll;
        contents[4] = "\nJava properties:\n";
        JScrollPane scroll2 = new JScrollPane();
        JTextArea text2 = new JTextArea(this.getProperties(), 20, 40);
        text2.setEditable(false);
        text2.setCaretPosition(0);
        scroll2.setViewportView(text2);
        contents[5] = scroll2;
        JOptionPane pane = new JOptionPane(contents, 1, -1);
        JDialog dialog = pane.createDialog(this.mainWindow, "System information");
        dialog.setVisible(true);
    }

    private String getProperties() {
        StringBuffer sb = new StringBuffer();
        try {
            Properties props = System.getProperties();
            this.formatMap(sb, props);
        }
        finally {
            return sb.toString();
        }
    }

    private String getEnv() {
        StringBuffer sb = new StringBuffer();
        try {
            this.formatMap(sb, System.getenv());
        }
        finally {
            return sb.toString();
        }
    }

    private void formatMap(StringBuffer sb, Map<?, ?> props) {
        for (Object o : props.keySet()) {
            sb.append(o);
            sb.append("=\"");
            sb.append(props.get(o));
            sb.append("\"\n");
        }
    }

    private String formatList(List<?> l) {
        StringBuffer sb = new StringBuffer();
        for (Object o : l) {
            sb.append(o);
            sb.append(" ");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private String getMemoryInfo() {
        Runtime rt = Runtime.getRuntime();
        rt.gc();
        StringBuilder sb = new StringBuilder();
        long maxMemory = rt.maxMemory();
        long allocatedMemory = rt.totalMemory();
        long freeMemory = rt.freeMemory();
        sb.append("\nAvailable processors: " + rt.availableProcessors());
        sb.append("\nFree VM memory: " + freeMemory / 1024L / 1024L + " MB");
        sb.append("\nAllocated VM memory: " + allocatedMemory / 1024L / 1024L + " MB");
        sb.append("\nMax VM memory: " + maxMemory / 1024L / 1024L + " MB");
        sb.append("\nTotal free VM memory: " + (freeMemory + (maxMemory - allocatedMemory)) / 1024L / 1024L + " MB");
        return sb.toString();
    }
}

