/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.control.TermLabelVisibilityManager;
import de.uka.ilkd.key.control.event.TermLabelVisibilityManagerEvent;
import de.uka.ilkd.key.control.event.TermLabelVisibilityManagerListener;
import de.uka.ilkd.key.core.KeYSelectionEvent;
import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.KeYMenuCheckBox;
import de.uka.ilkd.key.logic.Name;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;

public class TermLabelMenu
extends JMenu {
    public static final String TERM_LABEL_MENU = "Term Labels";
    private static final long serialVersionUID = 1L;
    private final TermLabelVisibilityManager visibleTermLabels = new TermLabelVisibilityManager();
    private final Map<Name, TermLabelCheckBox> checkBoxMap = new TreeMap<Name, TermLabelCheckBox>();
    private final MainWindow mainWindow;
    private final DisplayLabelsCheckBox displayLabelsCheckBox;
    private final TermLabelVisibilityManagerListener termLabelVisibilityManagerListener = new TermLabelVisibilityManagerListener(){

        public void visibleLabelsChanged(TermLabelVisibilityManagerEvent e) {
            TermLabelMenu.this.handleVisibleLabelsChanged(e);
        }
    };

    public TermLabelMenu(final MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.setText(TERM_LABEL_MENU);
        this.setToolTipText("Configure term label visibility.");
        this.visibleTermLabels.addTermLabelVisibilityManagerListener(this.termLabelVisibilityManagerListener);
        this.displayLabelsCheckBox = new DisplayLabelsCheckBox(mainWindow);
        this.rebuildMenu();
        mainWindow.getMediator().addKeYSelectionListener(new KeYSelectionListener(){

            @Override
            public void selectedNodeChanged(KeYSelectionEvent e) {
                Set labelNames = mainWindow.getMediator().getSelectedNode().sequent().getOccuringTermLabels();
                for (Map.Entry<Name, TermLabelCheckBox> entry : TermLabelMenu.this.checkBoxMap.entrySet()) {
                    TermLabelCheckBox checkBox = entry.getValue();
                    if (labelNames.contains(entry.getKey())) {
                        checkBox.setBoldFont();
                        continue;
                    }
                    checkBox.setItalicFont();
                }
            }

            @Override
            public void selectedProofChanged(KeYSelectionEvent e) {
                TermLabelMenu.this.rebuildMenu();
            }
        });
    }

    protected void handleVisibleLabelsChanged(TermLabelVisibilityManagerEvent e) {
        if (this.displayLabelsCheckBox != null) {
            this.displayLabelsCheckBox.setSelected(this.visibleTermLabels.isShowLabels());
        }
        for (TermLabelCheckBox box : this.checkBoxMap.values()) {
            box.setEnabled(this.visibleTermLabels.isShowLabels());
            box.setSelected(!this.visibleTermLabels.isHidden(box.labelName));
        }
        this.mainWindow.makePrettyView();
    }

    private void rebuildMenu() {
        this.removeAll();
        this.add(this.displayLabelsCheckBox);
        this.addSeparator();
        List<Name> labelNames = this.mainWindow.getSortedTermLabelNames();
        ArrayList<TermLabelCheckBox> checkBoxList = new ArrayList<TermLabelCheckBox>();
        for (Name labelName : labelNames) {
            TermLabelCheckBox checkBox = this.checkBoxMap.get(labelName);
            if (checkBox == null) {
                checkBox = new TermLabelCheckBox(labelName);
                this.checkBoxMap.put(labelName, checkBox);
            }
            checkBoxList.add(checkBox);
        }
        for (TermLabelCheckBox c : checkBoxList) {
            this.add(c);
        }
    }

    public TermLabelVisibilityManager getVisibleTermLabels() {
        return this.visibleTermLabels;
    }

    private class TermLabelCheckBox
    extends KeYMenuCheckBox {
        private static final long serialVersionUID = 4582177241207958225L;
        private final Name labelName;
        private String enabledToolTipText;

        TermLabelCheckBox(Name labelName) {
            super(TermLabelMenu.this.mainWindow, labelName.toString(), true);
            this.labelName = labelName;
            this.setName(labelName.toString());
            this.setSelected(!TermLabelMenu.this.visibleTermLabels.isHidden(labelName));
            this.setEnabled(TermLabelMenu.this.displayLabelsCheckBox.isSelected());
            TermLabelMenu.this.mainWindow.loadPreferences(this);
            TermLabelMenu.this.visibleTermLabels.setHidden(labelName, !this.isSelected());
            this.setItalicFont();
        }

        @Override
        public void handleClickEvent() {
            TermLabelMenu.this.visibleTermLabels.setHidden(this.labelName, !this.isSelected());
            TermLabelMenu.this.mainWindow.makePrettyView();
        }

        @Override
        public final void setEnabled(boolean b) {
            super.setEnabled(b);
            this.updateToolTipText();
        }

        private void setItalicFont() {
            this.setFont(this.getFont().deriveFont(2));
            this.setEnabledToolTipText("Term label " + this.labelName + " does not occur in the current sequent.");
        }

        private void setBoldFont() {
            this.setFont(this.getFont().deriveFont(1));
            this.setEnabledToolTipText("Click to toggle visibility for term label " + this.labelName + ".");
        }

        private void setEnabledToolTipText(String s) {
            this.enabledToolTipText = s;
            this.updateToolTipText();
        }

        private void updateToolTipText() {
            if (this.isEnabled()) {
                this.setToolTipText(this.enabledToolTipText);
            } else {
                this.setToolTipText("You turned off visibility for all term labels. This checkbox is disabled.");
            }
        }
    }

    public class DisplayLabelsCheckBox
    extends KeYMenuCheckBox {
        public static final String LABEL = "Display Term Labels in Formulas";
        public static final String TOOL_TIP = "Use this checkbox to toggle visibility for all term labels.";
        private static final long serialVersionUID = 8766949321781919880L;

        private DisplayLabelsCheckBox(MainWindow mainWindow) {
            super(mainWindow, LABEL, true);
            this.setTooltip(TOOL_TIP);
            this.setName("DisplayLabelsCheckBox");
            this.setSelected(TermLabelMenu.this.visibleTermLabels.isShowLabels());
        }

        @Override
        public void handleClickEvent() {
            boolean selected = this.isSelected();
            TermLabelMenu.this.visibleTermLabels.setShowLabels(selected);
            for (JCheckBoxMenuItem jCheckBoxMenuItem : TermLabelMenu.this.checkBoxMap.values()) {
                jCheckBoxMenuItem.setEnabled(selected);
            }
            TermLabelMenu.this.mainWindow.makePrettyView();
        }

        @Override
        public final void setSelected(boolean b) {
            super.setSelected(b);
            this.handleClickEvent();
        }
    }
}

