/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.SettingsListener;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import javax.swing.JCheckBoxMenuItem;

public class ToggleSourceViewTooltipAction
extends MainWindowAction {
    public static final String NAME = "Show Tooltips in Source View";
    public static final String TOOL_TIP = "If ticked, moving the mouse over a term in the source view will show a tooltip with additional information.";
    private final SettingsListener viewSettingsListener = new SettingsListener(){

        public void settingsChanged(EventObject e) {
            ToggleSourceViewTooltipAction.this.updateSelectedState();
        }
    };

    public ToggleSourceViewTooltipAction(MainWindow mainWindow) {
        super(mainWindow);
        this.setName(NAME);
        this.setTooltip(TOOL_TIP);
        ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().addSettingsListener(this.viewSettingsListener);
        this.updateSelectedState();
    }

    protected void updateSelectedState() {
        boolean setting = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().isShowSourceViewTooltips();
        this.setSelected(setting);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean selected = ((JCheckBoxMenuItem)e.getSource()).isSelected();
        ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().setShowSourceViewTooltips(selected);
    }
}

