/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.pp.NotationInfo;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.SettingsListener;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import javax.swing.JCheckBoxMenuItem;

public class UnicodeToggleAction
extends MainWindowAction {
    private static final long serialVersionUID = 6078839876754730405L;
    public static final String NAME = "Use Unicode Symbols";
    public static final String TOOL_TIP = "If checked formulae are displayed with special Unicode characters (such as \"\u2227\") instead of the traditional ASCII ones. \nOnly works in combination with pretty printing (see above).";
    private final SettingsListener viewSettingsListener = new SettingsListener(){

        public void settingsChanged(EventObject e) {
            UnicodeToggleAction.this.handleViewSettingsChanged(e);
        }
    };

    public UnicodeToggleAction(MainWindow window) {
        super(window);
        this.setName(NAME);
        this.setTooltip(TOOL_TIP);
        ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().addSettingsListener(this.viewSettingsListener);
        this.updateSelectedState();
    }

    protected void updateSelectedState() {
        boolean useUnicode = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().isUseUnicode();
        boolean usePretty = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().isUsePretty();
        this.setSelected(useUnicode && usePretty);
        NotationInfo.DEFAULT_UNICODE_ENABLED = useUnicode && usePretty;
        this.setEnabled(usePretty);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean useUnicode = ((JCheckBoxMenuItem)e.getSource()).isSelected();
        boolean usePretty = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().isUsePretty();
        NotationInfo.DEFAULT_UNICODE_ENABLED = useUnicode && usePretty;
        ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().setUseUnicode(useUnicode);
        this.updateMainWindow();
    }

    protected void updateMainWindow() {
        this.mainWindow.makePrettyView();
    }

    protected void handleViewSettingsChanged(EventObject e) {
        this.updateSelectedState();
        this.updateMainWindow();
    }
}

