/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.colors;

import de.uka.ilkd.key.gui.settings.SettingsManager;
import de.uka.ilkd.key.settings.AbstractPropertiesSettings;
import de.uka.ilkd.key.settings.PathConfig;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorSettings
extends AbstractPropertiesSettings {
    public static final String SETTINGS_FILENAME = "colors.properties";
    public static final File SETTINGS_FILE = new File(PathConfig.getKeyConfigDir(), "colors.properties");
    private static final Logger LOGGER = LoggerFactory.getLogger(ColorSettings.class);
    private static ColorSettings INSTANCE;

    private ColorSettings(Properties settings) {
        this.readSettings(settings);
        Runtime.getRuntime().addShutdownHook(new Thread(this::save));
    }

    public static ColorSettings getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ColorSettings(SettingsManager.loadProperties(SETTINGS_FILE));
        }
        return INSTANCE;
    }

    public static ColorProperty define(String key, String desc, Color color) {
        return ColorSettings.getInstance().createColorProperty(key, desc, color);
    }

    public static String toHex(Color c) {
        int a = c.getAlpha();
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return String.format("#%02X%02X%02X%02X", a, r, g, b);
    }

    public static Color fromHex(String s) {
        long i = Long.decode(s);
        return new Color((int)(i >> 16 & 0xFFL), (int)(i >> 8 & 0xFFL), (int)(i & 0xFFL), (int)(i >> 24 & 0xFFL));
    }

    public static Color invert(Color c) {
        return new Color(255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue());
    }

    public void save() {
        LOGGER.info("Save color settings to: " + SETTINGS_FILE.getAbsolutePath());
        try (FileWriter writer = new FileWriter(SETTINGS_FILE);){
            this.properties.store(writer, "KeY's Colors");
            ((Writer)writer).flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private ColorProperty createColorProperty(String key, String description, Color defaultValue) {
        Optional<ColorProperty> item = this.getProperties().filter(it -> it.getKey().equals(key)).findFirst();
        if (item.isPresent()) {
            return item.get();
        }
        ColorProperty pe = new ColorProperty(key, description, defaultValue);
        this.propertyEntries.add(pe);
        return pe;
    }

    public Stream<ColorProperty> getProperties() {
        return this.propertyEntries.stream().map(ColorProperty.class::cast);
    }

    public void readSettings(Properties props) {
        this.properties.putAll((Map<?, ?>)props);
    }

    public class ColorProperty
    implements AbstractPropertiesSettings.PropertyEntry<Color> {
        private final String key;
        private final String description;
        private Color currentValue;

        public ColorProperty(String key, String description, Color defaultValue) {
            this.key = key;
            this.description = description;
            if (!ColorSettings.this.properties.containsKey(key)) {
                this.set(defaultValue);
            }
        }

        public String value() {
            if (this.currentValue != null) {
                return ColorSettings.toHex(this.currentValue);
            }
            String v = ColorSettings.this.properties.getProperty(this.key);
            try {
                return v;
            }
            catch (NumberFormatException e) {
                return ColorSettings.toHex(Color.MAGENTA);
            }
        }

        public void set(String v) {
            if (!Objects.equals(this.value(), v)) {
                this.currentValue = ColorSettings.fromHex(v);
                ColorSettings.this.properties.setProperty(this.getKey(), v);
                ColorSettings.this.fireSettingsChange();
            }
        }

        public String getKey() {
            return this.key;
        }

        public void set(Color value) {
            if (this.currentValue != value) {
                this.currentValue = value;
                ColorSettings.this.properties.setProperty(this.getKey(), ColorSettings.toHex(value));
                ColorSettings.this.fireSettingsChange();
            }
        }

        public Color get() {
            if (this.currentValue != null) {
                return this.currentValue;
            }
            String v = ColorSettings.this.properties.getProperty(this.key);
            try {
                this.currentValue = ColorSettings.fromHex(v);
                return this.currentValue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return Color.MAGENTA;
            }
        }

        public String getDescription() {
            return this.description;
        }
    }
}

