/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.colors;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.colors.ColorSettings;
import de.uka.ilkd.key.gui.colors.HexColorCellEditor;
import de.uka.ilkd.key.gui.settings.SettingsProvider;
import de.uka.ilkd.key.gui.settings.SimpleSettingsPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;

public class ColorSettingsProvider
extends SimpleSettingsPanel
implements SettingsProvider {
    private static final long serialVersionUID = -6253991459166324512L;
    private final JTable tblColors = new JTable();
    private ColorSettingsTableModel modelColor;

    public ColorSettingsProvider() {
        this.setHeaderText(this.getDescription());
        this.setSubHeaderText("Color settings are stored in: " + ColorSettings.SETTINGS_FILE.getAbsolutePath());
        this.add(new JScrollPane(this.tblColors));
    }

    @Override
    public String getDescription() {
        return "Colors";
    }

    @Override
    public JComponent getPanel(MainWindow window) {
        List<ColorPropertyData> properties = ColorSettings.getInstance().getProperties().map(it -> new ColorPropertyData((ColorSettings.ColorProperty)it, it.get())).collect(Collectors.toList());
        this.modelColor = new ColorSettingsTableModel(properties);
        this.tblColors.setModel(this.modelColor);
        TableRowSorter<ColorSettingsTableModel> sorter = new TableRowSorter<ColorSettingsTableModel>(this.modelColor);
        this.tblColors.setRowSorter(sorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>(25);
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        sorter.setSortKeys(sortKeys);
        this.tblColors.getColumnModel().getColumn(2).setCellEditor(HexColorCellEditor.make());
        this.tblColors.setDefaultRenderer(Color.class, new DefaultTableCellRenderer(){
            private static final long serialVersionUID = -7602735597024671100L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Color c = (Color)value;
                String s = ColorSettings.toHex(c);
                JLabel lbl = (JLabel)super.getTableCellRendererComponent(table, s, isSelected, hasFocus, row, column);
                lbl.setIcon(this.drawRect(c, lbl.getFont().getSize()));
                return lbl;
            }

            private Icon drawRect(Color c, int size) {
                BufferedImage bi = new BufferedImage(size, size, 1);
                Graphics g = bi.getGraphics();
                g.setColor(c);
                g.fillRect(0, 0, size, size);
                return new ImageIcon(bi);
            }
        });
        return this;
    }

    @Override
    public void applySettings(MainWindow window) {
        this.modelColor.colorData.forEach(it -> it.property.set(it.color));
    }

    private static class ColorPropertyData {
        private final ColorSettings.ColorProperty property;
        Color color;

        public ColorPropertyData(ColorSettings.ColorProperty property, Color color) {
            this.property = property;
            this.color = color;
        }
    }

    private static class ColorSettingsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 4722928883386296559L;
        private static final String[] COLUMNS = new String[]{"Key", "Description", "Color"};
        private final List<ColorPropertyData> colorData;

        public ColorSettingsTableModel(List<ColorPropertyData> properties) {
            this.colorData = properties;
        }

        @Override
        public int getRowCount() {
            return this.colorData.size();
        }

        @Override
        public int getColumnCount() {
            return COLUMNS.length;
        }

        @Override
        public String getColumnName(int column) {
            return COLUMNS[column];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.colorData.get((int)rowIndex).property.getKey();
                }
                case 1: {
                    return this.colorData.get((int)rowIndex).property.getDescription();
                }
                case 2: {
                    return this.colorData.get((int)rowIndex).color;
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 2) {
                return Color.class;
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 2) {
                this.colorData.get((int)rowIndex).color = ColorSettings.fromHex(aValue.toString());
            } else {
                super.setValueAt(aValue, rowIndex, columnIndex);
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2;
        }
    }
}

