/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.colors;

import de.uka.ilkd.key.gui.colors.ColorSettings;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class HexColorCellEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = -4352607386521686931L;

    HexColorCellEditor(final JTextField textField) {
        super(textField);
        textField.addActionListener(e -> this.stopCellEditing());
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateBackground();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateBackground();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateBackground();
            }

            private void updateBackground() {
                try {
                    Color c = ColorSettings.fromHex(textField.getText());
                    textField.setBackground(c);
                    textField.setForeground(ColorSettings.invert(c));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
    }

    public static HexColorCellEditor make() {
        JTextField field = new JTextField();
        field.setBorder(null);
        return new HexColorCellEditor(field);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component txt = super.getTableCellEditorComponent(table, ColorSettings.toHex((Color)value), isSelected, row, column);
        Color c = (Color)value;
        txt.setBackground(c);
        txt.setForeground(ColorSettings.invert(c));
        return txt;
    }
}

