/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.configuration;

import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.utilities.GuiUtilities;
import de.uka.ilkd.key.settings.ChoiceSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import org.key_project.util.java.ArrayUtil;
import org.key_project.util.java.ObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChoiceSelector
extends JDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChoiceSelector.class);
    private static final long serialVersionUID = -4470713015801365801L;
    private static final String EXPLANATIONS_RESOURCE = "/de/uka/ilkd/key/gui/help/choiceExplanations.xml";
    private final ChoiceSettings settings;
    private final HashMap<String, String> category2DefaultChoice;
    private HashMap<String, Set<String>> category2Choices;
    private boolean changed = false;
    private JList<String> catList;
    private JList<ChoiceEntry> choiceList;
    private JTextArea explanationArea;
    private static Properties explanationMap;

    public ChoiceSelector(JFrame mainWindow, ChoiceSettings settings) {
        super(mainWindow, "Taclet Base Configuration", true);
        this.settings = settings;
        this.category2DefaultChoice = settings.getDefaultChoices();
        if (this.category2DefaultChoice.isEmpty()) {
            JOptionPane.showConfirmDialog(this, "There are no Taclet Options available as the rule-files have not been parsed yet!", "No Options available", -1);
            this.dispose();
        } else {
            this.category2Choices = settings.getChoices();
            this.layoutChoiceSelector();
            this.setChoiceList();
            this.pack();
            this.setLocationRelativeTo(mainWindow);
            this.setVisible(true);
        }
    }

    protected void layoutChoiceSelector() {
        this.setIconImage(IconFactory.keyLogo());
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BorderLayout());
        Object[] cats = this.category2DefaultChoice.keySet().toArray(new String[0]);
        Arrays.sort(cats);
        this.catList = new JList<Object>(cats);
        this.catList.setSelectionMode(0);
        this.catList.setSelectedIndex(0);
        this.catList.addListSelectionListener(e -> this.setChoiceList());
        JScrollPane catListScroll = new JScrollPane(20, 30);
        catListScroll.setBorder(new TitledBorder("Category"));
        catListScroll.getViewport().setView(this.catList);
        Dimension paneDim = new Dimension(200, 300);
        catListScroll.setPreferredSize(paneDim);
        catListScroll.setMinimumSize(paneDim);
        listPanel.add((Component)catListScroll, "West");
        this.choiceList = new JList();
        this.choiceList.setSelectionMode(0);
        this.choiceList.setSelectedValue(this.category2DefaultChoice.get(cats[0]), true);
        this.choiceList.addListSelectionListener(e -> {
            ChoiceEntry selectedValue = this.choiceList.getSelectedValue();
            if (selectedValue != null) {
                this.setDefaultChoice(selectedValue.getChoice());
            } else {
                this.setDefaultChoice(null);
            }
        });
        JScrollPane choiceScrollPane = new JScrollPane(20, 30);
        choiceScrollPane.getViewport().setView(this.choiceList);
        choiceScrollPane.setBorder(new TitledBorder("Choice"));
        paneDim = new Dimension(300, 300);
        choiceScrollPane.setPreferredSize(paneDim);
        choiceScrollPane.setMinimumSize(paneDim);
        listPanel.add((Component)choiceScrollPane, "East");
        this.explanationArea = new JTextArea("Explanation!");
        this.explanationArea.setEditable(false);
        this.explanationArea.setLineWrap(true);
        this.explanationArea.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(this.explanationArea);
        paneDim = new Dimension(500, 200);
        scrollPane.setPreferredSize(paneDim);
        scrollPane.setMinimumSize(paneDim);
        listPanel.add((Component)scrollPane, "South");
        JPanel buttonPanel = new JPanel();
        JButton okButton = new JButton("OK");
        okButton.addActionListener(e -> {
            int res;
            if (this.changed && (res = JOptionPane.showOptionDialog(this, "Your changes will become effective when the next problem is loaded.\n", "Taclet Options", -1, 3, null, new Object[]{"OK", "Cancel"}, "OK")) == 0) {
                this.settings.setDefaultChoices(this.category2DefaultChoice);
            }
            this.setVisible(false);
            this.dispose();
        });
        buttonPanel.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> {
            this.setVisible(false);
            this.dispose();
        });
        GuiUtilities.attachClickOnEscListener(cancelButton);
        buttonPanel.add(cancelButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)listPanel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
        this.setResizable(false);
    }

    private void setDefaultChoice(String sel) {
        String category = this.catList.getSelectedValue();
        if (sel != null) {
            this.category2DefaultChoice.put(category, sel);
            this.changed = true;
        }
    }

    private void setChoiceList() {
        String selection = this.catList.getSelectedValue();
        ChoiceEntry[] choices = ChoiceSelector.createChoiceEntries(this.category2Choices.get(selection));
        this.choiceList.setListData((ChoiceEntry[])choices);
        ChoiceEntry selectedChoice = ChoiceSelector.findChoice(choices, this.category2DefaultChoice.get(selection));
        this.choiceList.setSelectedValue(selectedChoice, false);
        this.explanationArea.setBorder(BorderFactory.createTitledBorder(selection));
        this.explanationArea.setText(ChoiceSelector.getExplanation(selection));
        this.explanationArea.setCaretPosition(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExplanation(String category) {
        Class<ChoiceSelector> clazz = ChoiceSelector.class;
        synchronized (ChoiceSelector.class) {
            if (explanationMap == null) {
                explanationMap = new Properties();
                InputStream is = ChoiceSelector.class.getResourceAsStream(EXPLANATIONS_RESOURCE);
                try {
                    if (is == null) {
                        throw new FileNotFoundException("/de/uka/ilkd/key/gui/help/choiceExplanations.xml not found");
                    }
                    explanationMap.loadFromXML(is);
                }
                catch (IOException e) {
                    LOGGER.warn("Cannot load help message in rule view.", (Throwable)e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Object result = explanationMap.getProperty(category);
            if (result == null) {
                result = "No explanation for " + category + " available.";
            }
            return result;
        }
    }

    public static boolean isUnsound(String choice) {
        return "runtimeExceptions:ignore".equals(choice) || "initialisation:disableStaticInitialisation".equals(choice) || "intRules:arithmeticSemanticsIgnoringOF".equals(choice);
    }

    public static boolean isIncomplete(String choice) {
        return "runtimeExceptions:ban".equals(choice) || "Strings:off".equals(choice) || "intRules:arithmeticSemanticsCheckingOF".equals(choice) || "integerSimplificationRules:minimal".equals(choice) || "programRules:None".equals(choice);
    }

    public static String getInformation(String choice) {
        if ("JavaCard:on".equals(choice)) {
            return "Sound if a JavaCard program is proven.";
        }
        if ("JavaCard:off".equals(choice)) {
            return "Sound if a Java program is proven.";
        }
        if ("assertions:on".equals(choice)) {
            return "Sound if JVM is started with enabled assertions for the whole system.";
        }
        if ("assertions:off".equals(choice)) {
            return "Sound if JVM is started with disabled assertions for the whole system.";
        }
        return null;
    }

    public static ChoiceEntry findChoice(ChoiceEntry[] choices, String choice) {
        return (ChoiceEntry)ArrayUtil.search((Object[])choices, element -> element.getChoice().equals(choice));
    }

    public static ChoiceEntry[] createChoiceEntries(Set<String> choices) {
        if (choices != null) {
            ChoiceEntry[] entries = new ChoiceEntry[choices.size()];
            int i = 0;
            for (String choice : choices) {
                entries[i] = ChoiceSelector.createChoiceEntry(choice);
                ++i;
            }
            return entries;
        }
        return null;
    }

    public static ChoiceEntry createChoiceEntry(String choice) {
        return new ChoiceEntry(choice, ChoiceSelector.isUnsound(choice), ChoiceSelector.isIncomplete(choice), ChoiceSelector.getInformation(choice));
    }

    public static class ChoiceEntry {
        public static final String INCOMPLETE_TEXT = "incomplete";
        public static final String UNSOUND_TEXT = "Java modeling unsound";
        private final String choice;
        private final boolean unsound;
        private final boolean incomplete;
        private final String information;

        public ChoiceEntry(String choice, boolean unsound, boolean incomplete, String information) {
            assert (choice != null);
            this.choice = choice;
            this.unsound = unsound;
            this.incomplete = incomplete;
            this.information = information;
        }

        public String getChoice() {
            return this.choice;
        }

        public boolean isUnsound() {
            return this.unsound;
        }

        public boolean isIncomplete() {
            return this.incomplete;
        }

        public String getInformation() {
            return this.information;
        }

        public int hashCode() {
            int hashcode = 5;
            hashcode = hashcode * 17 + this.choice.hashCode();
            hashcode = hashcode * 17 + (this.incomplete ? 5 : 3);
            hashcode = hashcode * 17 + (this.unsound ? 5 : 3);
            if (this.information != null) {
                hashcode = hashcode * 17 + this.information.hashCode();
            }
            return hashcode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ChoiceEntry) {
                ChoiceEntry other = (ChoiceEntry)obj;
                return this.choice.equals(other.getChoice()) && this.incomplete == other.isIncomplete() && this.unsound == other.isUnsound() && ObjectUtil.equals((Object)this.information, (Object)other.getInformation());
            }
            return false;
        }

        public String toString() {
            if (this.unsound && this.incomplete) {
                if (this.information != null) {
                    return this.choice + " (Java modeling unsound and incomplete, " + this.information + ")";
                }
                return this.choice + " (Java modeling unsound and incomplete)";
            }
            if (this.unsound) {
                if (this.information != null) {
                    return this.choice + " (Java modeling unsound, " + this.information + ")";
                }
                return this.choice + " (Java modeling unsound)";
            }
            if (this.incomplete) {
                if (this.information != null) {
                    return this.choice + " (incomplete, " + this.information + ")";
                }
                return this.choice + " (incomplete)";
            }
            if (this.information != null) {
                return this.choice + " (" + this.information + ")";
            }
            return this.choice;
        }
    }
}

