/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.configuration;

import de.uka.ilkd.key.gui.configuration.ConfigChangeEvent;
import de.uka.ilkd.key.gui.configuration.ConfigChangeListener;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.UIManager;

public class Config {
    public static final String KEY_FONT_PROOF_TREE = "KEY_FONT_PROOF_TREE";
    public static final String KEY_FONT_SEQUENT_VIEW = "KEY_FONT_CURRENT_GOAL_VIEW";
    public static final String KEY_FONT_GOAL_LIST_VIEW = "KEY_FONT_GOAL_LIST_VIEW";
    public static final String KEY_FONT_PROOF_LIST_VIEW = "KEY_FONT_PROOF_LIST_VIEW";
    public static final int[] SIZES = new int[]{10, 12, 14, 17, 20, 24};
    public static final Config DEFAULT = new Config();
    private int sizeIndex = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().sizeIndex();
    private ConfigChangeEvent configChangeEvent;
    private final List<ConfigChangeListener> listenerList;

    private Config() {
        if (this.sizeIndex < 0 || this.sizeIndex > SIZES.length) {
            this.sizeIndex = 0;
        }
        this.configChangeEvent = new ConfigChangeEvent(this);
        this.listenerList = new ArrayList<ConfigChangeListener>(5);
        this.setDefaultFonts();
    }

    public void larger() {
        if (!this.isMaximumSize()) {
            ++this.sizeIndex;
            ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().setFontIndex(this.sizeIndex);
            this.setDefaultFonts();
            this.fireConfigChange();
        }
    }

    public void smaller() {
        if (!this.isMinimumSize()) {
            --this.sizeIndex;
            ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().setFontIndex(this.sizeIndex);
            this.setDefaultFonts();
            this.fireConfigChange();
        }
    }

    public boolean isMinimumSize() {
        return this.sizeIndex == 0;
    }

    public boolean isMaximumSize() {
        return this.sizeIndex == SIZES.length - 1;
    }

    public void setDefaultFonts() {
        UIManager.put(KEY_FONT_PROOF_TREE, new Font("Default", 0, SIZES[this.sizeIndex]));
        UIManager.put(KEY_FONT_SEQUENT_VIEW, new Font("Monospaced", 0, SIZES[this.sizeIndex]));
        UIManager.put(KEY_FONT_GOAL_LIST_VIEW, new Font("Default", 0, SIZES[2]));
        UIManager.put(KEY_FONT_PROOF_LIST_VIEW, new Font("Default", 0, SIZES[2]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigChangeListener(ConfigChangeListener listener) {
        List<ConfigChangeListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfigChangeListener(ConfigChangeListener listener) {
        List<ConfigChangeListener> list = this.listenerList;
        synchronized (list) {
            this.listenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fireConfigChange() {
        List<ConfigChangeListener> list = this.listenerList;
        synchronized (list) {
            for (ConfigChangeListener aListenerList : this.listenerList) {
                aListenerList.configChanged(this.configChangeEvent);
            }
        }
    }
}

