/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.docking;

import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.action.CButton;
import bibliothek.gui.dock.common.action.CCheckBox;
import bibliothek.gui.dock.common.intern.CDockable;
import de.uka.ilkd.key.gui.GoalList;
import de.uka.ilkd.key.gui.InfoView;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.StrategySelectionView;
import de.uka.ilkd.key.gui.TaskTree;
import de.uka.ilkd.key.gui.extension.api.TabPanel;
import de.uka.ilkd.key.gui.nodeviews.MainFrame;
import de.uka.ilkd.key.gui.prooftree.ProofTreeView;
import de.uka.ilkd.key.gui.sourceview.SourceViewFrame;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;

public class DockingHelper {
    public static final List<String> LEFT_TOP_PANEL = new LinkedList<String>();
    public static final List<String> RIGHT_PANEL = new LinkedList<String>();
    public static final List<String> LEFT_PANEL = new LinkedList<String>();
    public static final List<String> MAIN_PANEL = new LinkedList<String>();

    public static void restoreFactoryDefault(MainWindow mainWindow) {
        LinkedList<CDockable> leftPanels = new LinkedList<CDockable>();
        LinkedList<CDockable> leftTopPanels = new LinkedList<CDockable>();
        LinkedList<CDockable> mainPanels = new LinkedList<CDockable>();
        LinkedList<CDockable> rightPanels = new LinkedList<CDockable>();
        int c = mainWindow.getDockControl().getCDockableCount();
        for (int i = 0; i < c; ++i) {
            CDockable cur = mainWindow.getDockControl().getCDockable(i);
            if (cur instanceof SingleCDockable) {
                String id = ((SingleCDockable)cur).getUniqueId();
                if (LEFT_PANEL.contains(id)) {
                    leftPanels.add(cur);
                    continue;
                }
                if (MAIN_PANEL.contains(id)) {
                    mainPanels.add(cur);
                    continue;
                }
                if (RIGHT_PANEL.contains(id)) {
                    rightPanels.add(cur);
                    continue;
                }
                if (LEFT_TOP_PANEL.contains(id)) {
                    leftTopPanels.add(cur);
                    continue;
                }
            }
            if (cur instanceof MultipleCDockable) {
                mainPanels.add(cur);
                continue;
            }
            leftPanels.add(cur);
        }
        CGrid grid = new CGrid(mainWindow.getDockControl());
        grid.add(0.0, 0.0, 1.0, 1.0, leftTopPanels.toArray(new CDockable[0]));
        grid.add(0.0, 1.0, 1.0, 2.0, leftPanels.toArray(new CDockable[0]));
        grid.add(1.0, 0.0, 2.0, 3.0, mainPanels.toArray(new CDockable[0]));
        grid.add(2.0, 0.0, 1.0, 3.0, rightPanels.toArray(new CDockable[0]));
        mainWindow.getDockControl().getContentArea().deploy(grid);
    }

    public static SingleCDockable createSingleDock(String title, JComponent component) {
        return DockingHelper.createSingleDock(title, component, component.getClass().getName());
    }

    public static SingleCDockable createSingleDock(String title, JComponent component, String id) {
        return new DefaultSingleCDockable(id, title, (Component)component, new CAction[0]);
    }

    public static SingleCDockable createSingleDock(TabPanel p) {
        Stream<CAction> actions = p.getTitleActions().stream().map(DockingHelper::translateAction);
        CAction[] a = (CAction[])Stream.concat(actions, p.getTitleCActions().stream()).toArray(CAction[]::new);
        return new DefaultSingleCDockable(p.getClass().getName(), p.getIcon(), p.getTitle(), (Component)p.getComponent(), p.getPermissions(), a);
    }

    @Nonnull
    public static CAction translateAction(@Nonnull Action action) {
        if (action.getValue("SwingSelectedKey") != null) {
            return DockingHelper.createCheckBox(action);
        }
        return DockingHelper.createButton(action);
    }

    @Nonnull
    private static CAction createCheckBox(final @Nonnull Action action) {
        CCheckBox button = new CCheckBox((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon")){

            protected void changed() {
                action.putValue("SwingSelectedKey", this.isSelected());
                action.actionPerformed(null);
            }
        };
        button.setTooltip((String)action.getValue("ShortDescription"));
        button.setEnabled(action.isEnabled());
        button.setSelected(Boolean.TRUE == action.getValue("SwingSelectedKey"));
        action.addPropertyChangeListener(evt -> {
            button.setText((String)action.getValue("Name"));
            button.setIcon((Icon)action.getValue("SmallIcon"));
            button.setTooltip((String)action.getValue("ShortDescription"));
            button.setEnabled(action.isEnabled());
        });
        return button;
    }

    private static CAction createButton(Action action) {
        CButton button = new CButton((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon"));
        button.addActionListener((ActionListener)action);
        button.setTooltip((String)action.getValue("ShortDescription"));
        button.setEnabled(action.isEnabled());
        action.addPropertyChangeListener(evt -> {
            button.setText((String)action.getValue("Name"));
            button.setIcon((Icon)action.getValue("SmallIcon"));
            button.setTooltip((String)action.getValue("ShortDescription"));
            button.setEnabled(action.isEnabled());
        });
        return button;
    }

    static {
        LEFT_TOP_PANEL.add(TaskTree.class.getName());
        LEFT_PANEL.add(GoalList.class.getName());
        LEFT_PANEL.add(ProofTreeView.class.getName());
        LEFT_PANEL.add(InfoView.class.getName());
        LEFT_PANEL.add(StrategySelectionView.class.getName());
        MAIN_PANEL.add(MainFrame.class.getName());
        RIGHT_PANEL.add(SourceViewFrame.class.getName());
    }
}

