/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.docking;

import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.Priority;
import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.GUIListener;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.docking.LoadLayoutAction;
import de.uka.ilkd.key.gui.docking.ResetLayoutAction;
import de.uka.ilkd.key.gui.docking.SaveLayoutAction;
import de.uka.ilkd.key.gui.extension.api.KeYGuiExtension;
import de.uka.ilkd.key.gui.fonticons.FontAwesomeRegular;
import de.uka.ilkd.key.gui.fonticons.FontAwesomeSolid;
import de.uka.ilkd.key.gui.fonticons.IconFontSwing;
import de.uka.ilkd.key.settings.PathConfig;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JToolBar;

@KeYGuiExtension.Info(name="Docking Helpers", optional=false, experimental=false, priority=1)
public final class DockingLayout
implements KeYGuiExtension,
KeYGuiExtension.Startup,
KeYGuiExtension.MainMenu,
KeYGuiExtension.Toolbar {
    public static float SIZE_ICON_DOCK = 12.0f;
    public static final File LAYOUT_FILE = new File(PathConfig.getKeyConfigDir(), "layout.xml");
    public static final String[] LAYOUT_NAMES = new String[]{"Default", "Slot 1", "Slot 2"};
    public static final int[] LAYOUT_KEYS = new int[]{122, 123};
    private List<Action> actions = new LinkedList<Action>();
    private MainWindow window;

    private void installIcons(MainWindow mw) {
        CControl globalPort = mw.getDockControl();
        IconManager icons = globalPort.getController().getIcons();
        Priority p = Priority.CLIENT;
        icons.setIcon("locationmanager.normalize", p, IconFontSwing.buildIcon(FontAwesomeRegular.WINDOW_RESTORE, SIZE_ICON_DOCK));
        icons.setIcon("locationmanager.maximize", p, IconFontSwing.buildIcon(FontAwesomeRegular.WINDOW_MAXIMIZE, SIZE_ICON_DOCK));
        icons.setIcon("locationmanager.minimize", p, IconFontSwing.buildIcon(FontAwesomeRegular.WINDOW_MINIMIZE, SIZE_ICON_DOCK));
        icons.setIcon("locationmanager.externalize", p, IconFontSwing.buildIcon(FontAwesomeSolid.EXTERNAL_LINK_SQUARE_ALT, SIZE_ICON_DOCK));
        icons.setIcon("locationmanager.unexternalize", p, (Icon)new ImageIcon(IconFontSwing.buildImage(FontAwesomeSolid.EXTERNAL_LINK_ALT, SIZE_ICON_DOCK, Color.black, Math.PI)));
        icons.setIcon("locationmanager.unmaximize_externalized", p, IconFontSwing.buildIcon(FontAwesomeSolid.EXTERNAL_LINK_ALT, SIZE_ICON_DOCK));
        icons.setIcon("screen.maximize", p, IconFontSwing.buildIcon(FontAwesomeRegular.EDIT, SIZE_ICON_DOCK));
        icons.setIcon("close", p, IconFontSwing.buildIcon(FontAwesomeRegular.WINDOW_CLOSE, SIZE_ICON_DOCK));
    }

    private static void loadLayouts(CControl globalPort) {
        try {
            if (LAYOUT_FILE.exists()) {
                globalPort.readXML(LAYOUT_FILE);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void ensureActions(MainWindow mw) {
        if (this.actions.isEmpty()) {
            int keypos = 0;
            for (String layout : LAYOUT_NAMES) {
                Integer key = keypos < LAYOUT_KEYS.length ? Integer.valueOf(LAYOUT_KEYS[keypos]) : null;
                this.actions.add(new LoadLayoutAction(mw, layout, key));
                this.actions.add(new SaveLayoutAction(mw, layout, key));
                ++keypos;
            }
        }
    }

    @Override
    public void init(final MainWindow window, KeYMediator mediator) {
        this.window = window;
        this.installIcons(window);
        DockingLayout.loadLayouts(window.getDockControl());
        this.setLayout(LAYOUT_NAMES[0]);
        window.getMediator().addGUIListener(new GUIListener(){

            @Override
            public void modalDialogOpened(EventObject e) {
            }

            @Override
            public void modalDialogClosed(EventObject e) {
            }

            @Override
            public void shutDown(EventObject e) {
                try {
                    window.getDockControl().writeXML(LAYOUT_FILE);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private void setLayout(String layout) {
        CControl globalPort = this.window.getDockControl();
        boolean defaultLayoutDefined = Arrays.asList(globalPort.layouts()).contains(layout);
        if (defaultLayoutDefined) {
            globalPort.load(layout);
        }
    }

    @Override
    public JToolBar getToolbar(MainWindow mainWindow) {
        JToolBar toolBar = new JToolBar("Docking Layout");
        final JComboBox<String> comboLayouts = new JComboBox<String>();
        toolBar.add(new JLabel("Layouts: "));
        for (String s : LAYOUT_NAMES) {
            comboLayouts.addItem(s);
        }
        toolBar.add(comboLayouts);
        class LoadAction
        extends MainWindowAction {
            private static final long serialVersionUID = 3130337190207622893L;

            protected LoadAction(MainWindow mainWindow) {
                super(mainWindow);
                this.setName("Load Layout");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                DockingLayout.this.setLayout(Objects.requireNonNull(comboLayouts.getSelectedItem()).toString());
            }
        }
        toolBar.add(new LoadAction(mainWindow));
        class SaveAction
        extends MainWindowAction {
            private static final long serialVersionUID = -2688272657370615595L;

            protected SaveAction(MainWindow mainWindow) {
                super(mainWindow);
                this.setName("Save Layout");
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = Objects.requireNonNull(comboLayouts.getSelectedItem()).toString();
                this.mainWindow.getDockControl().save(name);
            }
        }
        toolBar.add(new SaveAction(mainWindow));
        toolBar.addSeparator();
        toolBar.add(new ResetLayoutAction(mainWindow));
        return toolBar;
    }

    @Override
    public List<Action> getMainMenuActions(MainWindow mainWindow) {
        this.ensureActions(mainWindow);
        return this.actions;
    }
}

