/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.docking;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.keyshortcuts.KeyStrokeManager;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.KeyStroke;

class LoadLayoutAction
extends MainWindowAction {
    private static final long serialVersionUID = 3378477658914832831L;
    private final String layoutName;

    public LoadLayoutAction(MainWindow mainWindow, String name, Integer key) {
        super(mainWindow);
        this.layoutName = name;
        this.setName("Load " + name);
        this.setIcon(IconFactory.openKeYFile(16));
        if (key != null) {
            this.setAcceleratorKey(KeyStroke.getKeyStroke(key, 128));
        }
        KeyStrokeManager.lookupAndOverride(this, this.getClass().getName() + "$" + this.layoutName);
        this.setMenuPath("View.Layout.Load");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean defaultLayoutDefined = Arrays.asList(this.mainWindow.getDockControl().layouts()).contains(this.layoutName);
        if (defaultLayoutDefined) {
            this.mainWindow.getDockControl().load(this.layoutName);
            this.mainWindow.setStatusLine("Layout " + this.layoutName + " loaded");
        } else {
            this.mainWindow.setStatusLine("Layout " + this.layoutName + " could not be found.");
        }
    }
}

