/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.extension;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.extension.impl.Extension;
import de.uka.ilkd.key.gui.extension.impl.ExtensionSettings;
import de.uka.ilkd.key.gui.extension.impl.KeYGuiExtensionFacade;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.settings.SettingsPanel;
import de.uka.ilkd.key.gui.settings.SettingsProvider;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.Settings;
import java.awt.Color;
import java.awt.Component;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.miginfocom.layout.CC;

public class ExtensionManager
extends SettingsPanel
implements SettingsProvider {
    private static final long serialVersionUID = 6682677093231975786L;
    private static final ExtensionSettings EXTENSION_SETTINGS = new ExtensionSettings();
    private HashMap<JCheckBox, Extension> map;
    private String keywords = "";

    public ExtensionManager() {
        this.setHeaderText("Extension Settings");
        this.setSubHeaderText("Settings will be applied on next restart");
        this.lblSubhead.setIcon(IconFactory.WARNING_INCOMPLETE.get());
        this.lblSubhead.setBackground(Color.orange.darker());
        JLabel lblExplainExperimental = new JLabel("<html>The flask marks extensions that are only available, <br>if KeY was started in experimental mode. Restart KeY with `--experimental`.");
        lblExplainExperimental.setIcon(IconFactory.EXPERIMENTAL_EXTENSION.get());
        this.pNorth.add(lblExplainExperimental);
        this.refresh();
    }

    public static ExtensionSettings getExtensionSettings() {
        ProofIndependentSettings.DEFAULT_INSTANCE.addSettings((Settings)EXTENSION_SETTINGS);
        return EXTENSION_SETTINGS;
    }

    private void refresh() {
        this.pCenter.removeAll();
        this.map = new HashMap();
        this.keywords = "";
        this.keywords = this.keywords + this.lblHead.getText();
        this.keywords = this.keywords + this.lblSubhead.getText();
        KeYGuiExtensionFacade.getExtensions().stream().sorted(Comparator.comparingInt(it -> it.isDisabledByMaintainer() || !it.isOptional() ? 1 : 0)).filter(it -> !it.isDisabledByMaintainer()).forEach(it -> {
            JCheckBox box = new JCheckBox();
            box.setText(it.getName());
            box.setSelected(!it.isDisabled());
            box.setEnabled(it.isOptional());
            this.map.put(box, (Extension)it);
            this.keywords = this.keywords + box.getText();
            this.pCenter.add((Component)new JLabel(it.isExperimental() ? IconFactory.EXPERIMENTAL_EXTENSION.get() : null), new CC().newline());
            this.pCenter.add(box);
            JLabel lblProvides = new JLabel(this.getSupportLabel((Extension)it));
            this.keywords = this.keywords + lblProvides.getText();
            lblProvides.setFont(lblProvides.getFont().deriveFont(2));
            this.pCenter.add((Component)new JLabel(), new CC().newline());
            this.pCenter.add(lblProvides);
            if (!it.getDescription().isEmpty()) {
                this.pCenter.add((Component)new JLabel(), new CC().newline());
                this.pCenter.add(ExtensionManager.createInfoArea(it.getDescription()));
                this.keywords = this.keywords + it.getDescription();
            }
        });
    }

    private String getSupportLabel(Extension it) {
        return "Provides: " + (it.supportsContextMenu() ? "ContextMenu " : "") + (it.supportsLeftPanel() ? "LeftPanel " : "") + (it.supportsMainMenu() ? "MainMenu " : "") + (it.supportsSettings() ? "Settings " : "") + (it.supportsStatusLine() ? "StatusLine " : "") + (it.supportsToolbar() ? "Toolbar " : "");
    }

    @Override
    public String getDescription() {
        return "Extensions";
    }

    @Override
    public JComponent getPanel(MainWindow window) {
        this.refresh();
        return this;
    }

    @Override
    public boolean contains(String substring) {
        return this.keywords.toLowerCase().contains(substring.toLowerCase());
    }

    @Override
    public void applySettings(MainWindow window) {
        HashSet<String> seq = new HashSet<String>();
        this.map.forEach((k, v) -> {
            if (!k.isSelected()) {
                seq.add(v.getType().getName());
            }
        });
        ExtensionManager.getExtensionSettings().setForbiddenClasses(seq);
    }
}

