/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.extension.impl;

import de.uka.ilkd.key.core.Main;
import de.uka.ilkd.key.gui.extension.ExtensionManager;
import de.uka.ilkd.key.gui.extension.api.KeYGuiExtension;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

public class Extension<T>
implements Comparable<Extension> {
    private final Class<T> clazz;
    private final KeYGuiExtension.Info info;
    private T instance = null;

    public Extension(Class<T> clazz) {
        this.clazz = clazz;
        this.info = clazz.getAnnotation(KeYGuiExtension.Info.class);
    }

    public T getInstance() {
        if (this.instance == null) {
            try {
                this.instance = this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return this.instance;
    }

    public String getName() {
        return this.info == null ? this.getType().getName() : this.info.name();
    }

    public boolean isOptional() {
        return this.info != null && this.info.optional() && (!this.isExperimental() || Main.isExperimentalMode());
    }

    public int getPriority() {
        return this.info == null ? 0 : this.info.priority();
    }

    public boolean isDisabled() {
        return this.isDisabledByMaintainer() || !Main.isExperimentalMode() && this.isExperimental() || ExtensionManager.getExtensionSettings().getForbiddenClasses().contains(this.getType().getName());
    }

    public boolean isDisabledByMaintainer() {
        return this.info != null && this.info.disabled();
    }

    public boolean isExperimental() {
        return this.info == null || this.info.experimental();
    }

    public Class<T> getType() {
        return this.clazz;
    }

    @Override
    public int compareTo(Extension o) {
        return Integer.compare(this.getPriority(), o.getPriority());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Extension)) {
            return false;
        }
        Extension extension = (Extension)o;
        return this.clazz.equals(extension.clazz);
    }

    public int hashCode() {
        return Objects.hash(this.clazz);
    }

    public String getDescription() {
        return this.info == null ? "" : this.info.description();
    }

    public boolean supports(Class<?> c) {
        return c.isAssignableFrom(this.getType());
    }

    public boolean supportsSettings() {
        return this.supports(KeYGuiExtension.Settings.class);
    }

    public boolean supportsLeftPanel() {
        return this.supports(KeYGuiExtension.LeftPanel.class);
    }

    public boolean supportsContextMenu() {
        return this.supports(KeYGuiExtension.ContextMenu.class);
    }

    public boolean supportsMainMenu() {
        return this.supports(KeYGuiExtension.MainMenu.class);
    }

    public boolean supportsStatusLine() {
        return this.supports(KeYGuiExtension.StatusLine.class);
    }

    public boolean supportsToolbar() {
        return this.supports(KeYGuiExtension.Toolbar.class);
    }

    public boolean supportsKeyboardShortcuts() {
        return this.supports(KeYGuiExtension.KeyboardShortcuts.class);
    }
}

