/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.extension.impl;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.settings.SettingsPanel;
import de.uka.ilkd.key.gui.settings.SettingsProvider;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.ViewSettings;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import net.miginfocom.layout.CC;

class HeatmapSettingsProvider
extends SettingsPanel
implements SettingsProvider {
    private static final long serialVersionUID = 7783431483026950930L;
    private static final int MIN_AGE = 1;
    private static final int MAX_AGE = 1000;
    private static final String INTRO_LABEL = "Heatmaps can be used to highlight the most recent changes in the sequent.";
    private static final String TEXTFIELD_LABEL = "Maximum age of highlighted \nterms or formulae, or number of newest terms or formulae\nPlease enter a number between 1 and 1000.";
    private final JSpinner spinnerAge;
    private Map<HeatmapMode, JRadioButton> map = new HashMap<HeatmapMode, JRadioButton>();

    HeatmapSettingsProvider() {
        this.setHeaderText("Heatmap Options");
        ButtonGroup group = new ButtonGroup();
        for (HeatmapMode m : HeatmapMode.values()) {
            JRadioButton radio = new JRadioButton(m.text);
            radio.setActionCommand(m.name());
            group.add(radio);
            this.map.put(m, radio);
        }
        this.pCenter.add((Component)new JLabel(INTRO_LABEL), new CC().span(new int[0]).alignX("left"));
        this.addSeparator("Disable heatmaps");
        this.addRadio(HeatmapMode.DEFAULT);
        this.addSeparator("Highlight sequent formulae");
        this.addRadio(HeatmapMode.SF_AGE);
        this.addRadio(HeatmapMode.SF_NEWEST);
        this.addSeparator("Highlight terms");
        this.addRadio(HeatmapMode.TERMS_AGE);
        this.addRadio(HeatmapMode.TERMS_NEWEST);
        this.spinnerAge = this.addNumberField("Maximal age:", 1, Integer.valueOf(1000), 1, TEXTFIELD_LABEL, e -> {});
    }

    private void addRadio(HeatmapMode mode) {
        JRadioButton radio = this.map.get((Object)mode);
        this.addRowWithHelp(mode.desc, new JLabel(), radio);
    }

    @Override
    public String getDescription() {
        return "Heatmap";
    }

    @Override
    public JComponent getPanel(MainWindow window) {
        ViewSettings vs = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings();
        for (Map.Entry<HeatmapMode, JRadioButton> entry : this.map.entrySet()) {
            HeatmapMode mode = entry.getKey();
            if (mode.enableHeatmap != vs.isShowHeatmap() || mode.enableHeatmap && (mode.sequent != vs.isHeatmapSF() || mode.newest != vs.isHeatmapNewest())) continue;
            entry.getValue().setSelected(true);
            break;
        }
        this.spinnerAge.setValue(vs.getMaxAgeForHeatmap());
        return this;
    }

    @Override
    public void applySettings(MainWindow window) {
        ViewSettings vs = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings();
        for (Map.Entry<HeatmapMode, JRadioButton> entry : this.map.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            HeatmapMode mode = entry.getKey();
            vs.setHeatmapOptions(mode.enableHeatmap, mode.sequent, mode.newest, ((Integer)this.spinnerAge.getValue()).intValue());
            break;
        }
    }

    @Override
    public int getPriorityOfSettings() {
        return 10000;
    }

    static enum HeatmapMode {
        DEFAULT("No heatmaps", "No heatmaps are shown.", false, false, false),
        SF_AGE("Sequent formulae up to age", "All sequent formulae that have been added or changed in the last k steps are highlighted. \nMore recent formulae will have a stronger highlight. It is possible that less \nthan k formulae are highlighted, e.g. if one formula has changed multiple times.\n", true, true, false),
        SF_NEWEST("Newest sequent formulae", "All formulae in the sequent are sorted by how new they are, i.e., how recently they have\n been added or changed. The first k formulae of the sorted list are highlighted\naccording to their position in the list,\n with the most recent formula receiving the strongest highlight.\n", true, true, true),
        TERMS_AGE("Terms up to age", "All terms that have been added or changed in the last k steps are highlighted. \nMore recent terms will have a stronger highlight. It is possible that less than \nk terms are highlighted, e.g. if one term has changed multiple times.", true, false, false),
        TERMS_NEWEST("Newest terms", "All terms in the sequent are sorted by how new they are, i.e., how recently they\nhave been added or changed. The first k terms of the sorted list are highlighted\naccording to their position in the list,\n with the most recent term receiving the strongest highlight.", true, false, true);

        final String text;
        final String desc;
        boolean enableHeatmap;
        boolean sequent;
        boolean newest;

        private HeatmapMode(String shortText, String description, boolean enableHeatmap, boolean sequent, boolean newest) {
            this.desc = description;
            this.text = shortText;
            this.enableHeatmap = enableHeatmap;
            this.sequent = sequent;
            this.newest = newest;
        }

        public String description() {
            return this.desc;
        }
    }
}

