/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.extension.impl;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.extension.api.ContextMenuKind;
import de.uka.ilkd.key.gui.extension.api.KeYGuiExtension;
import de.uka.ilkd.key.gui.extension.api.TabPanel;
import de.uka.ilkd.key.gui.extension.impl.Extension;
import de.uka.ilkd.key.pp.PosInSequent;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public final class KeYGuiExtensionFacade {
    private static final Set<String> forbiddenPlugins = new HashSet<String>();
    private static List<Extension> extensions = new LinkedList<Extension>();

    public static Stream<TabPanel> getAllPanels(MainWindow window) {
        return KeYGuiExtensionFacade.getLeftPanel().stream().flatMap(it -> it.getPanels(window, window.getMediator()).stream());
    }

    public static List<KeYGuiExtension.LeftPanel> getLeftPanel() {
        return KeYGuiExtensionFacade.getExtensionInstances(KeYGuiExtension.LeftPanel.class);
    }

    public static List<KeYGuiExtension.MainMenu> getMainMenuExtensions() {
        return KeYGuiExtensionFacade.getExtensionInstances(KeYGuiExtension.MainMenu.class);
    }

    public static Stream<Action> getMainMenuActions(MainWindow mainWindow) {
        ToIntFunction<Action> func = a -> {
            Integer i = (Integer)a.getValue("PRIORITY");
            if (i == null) {
                return 0;
            }
            return i;
        };
        return KeYGuiExtensionFacade.getMainMenuExtensions().stream().flatMap(it -> it.getMainMenuActions(mainWindow).stream()).sorted(Comparator.comparingInt(func));
    }

    public static void addExtensionsToMainMenu(MainWindow mainWindow, JMenuBar menuBar) {
        JMenu menu = new JMenu("Extensions");
        KeYGuiExtensionFacade.getMainMenuActions(mainWindow).forEach(it -> KeYGuiExtensionFacade.sortActionIntoMenu(it, menuBar, menu));
        if (menu.getMenuComponents().length > 0) {
            menuBar.add(menu);
        }
    }

    private static void sortActionsIntoMenu(List<Action> actions, JMenuBar menuBar) {
        actions.forEach(act -> KeYGuiExtensionFacade.sortActionIntoMenu(act, menuBar, new JMenu()));
    }

    private static Iterator<String> getMenuPath(Action act) {
        Object path = act.getValue("PATH");
        String spath = path == null ? "" : path.toString();
        return Pattern.compile(Pattern.quote(".")).splitAsStream(spath).iterator();
    }

    private static void sortActionIntoMenu(Action act, JMenu menu) {
        Iterator<String> mpath = KeYGuiExtensionFacade.getMenuPath(act);
        JMenu a = KeYGuiExtensionFacade.findMenu(menu, mpath);
        if (Boolean.TRUE.equals(act.getValue("CHECKBOX"))) {
            a.add(new JCheckBoxMenuItem(act));
        } else {
            a.add(act);
        }
    }

    private static void sortActionIntoMenu(Action act, JPopupMenu menu) {
        Iterator<String> mpath = KeYGuiExtensionFacade.getMenuPath(act);
        JMenu a = KeYGuiExtensionFacade.findMenu(menu, mpath);
        if (Boolean.TRUE.equals(act.getValue("CHECKBOX"))) {
            if (a == null) {
                menu.add(new JCheckBoxMenuItem(act));
            } else {
                a.add(new JCheckBoxMenuItem(act));
            }
        } else if (a == null) {
            menu.add(act);
        } else {
            a.add(act);
        }
    }

    private static void sortActionIntoMenu(Action act, JMenuBar menuBar, JMenu defaultMenu) {
        Iterator<String> mpath = KeYGuiExtensionFacade.getMenuPath(act);
        JMenu a = KeYGuiExtensionFacade.findMenu(menuBar, mpath, defaultMenu);
        if (Boolean.TRUE.equals(act.getValue("CHECKBOX"))) {
            a.add(new JCheckBoxMenuItem(act));
        } else {
            a.add(act);
        }
    }

    private static JMenu findMenu(JMenuBar menuBar, Iterator<String> mpath, JMenu defaultMenu) {
        if (mpath.hasNext()) {
            String cur = mpath.next();
            for (int i = 0; i < menuBar.getMenuCount(); ++i) {
                JMenu menu = menuBar.getMenu(i);
                if (!Objects.equals(menu.getText(), cur)) continue;
                return KeYGuiExtensionFacade.findMenu(menu, mpath);
            }
            JMenu menu = new JMenu(cur);
            menu.setName(cur);
            menuBar.add(menu);
            return KeYGuiExtensionFacade.findMenu(menu, mpath);
        }
        return defaultMenu;
    }

    private static JMenu findMenu(JPopupMenu menu, Iterator<String> mpath) {
        if (mpath.hasNext()) {
            Component[] children;
            String cur = mpath.next();
            for (Component child : children = menu.getComponents()) {
                if (!Objects.equals(child.getName(), cur)) continue;
                JMenu sub = (JMenu)child;
                return KeYGuiExtensionFacade.findMenu(sub, mpath);
            }
            JMenu m = new JMenu(cur);
            m.setName(cur);
            menu.add(m);
            return KeYGuiExtensionFacade.findMenu(m, mpath);
        }
        return null;
    }

    private static JMenu findMenu(JMenu menu, Iterator<String> mpath) {
        if (mpath.hasNext()) {
            Component[] children;
            String cur = mpath.next();
            for (Component child : children = menu.getMenuComponents()) {
                if (!Objects.equals(child.getName(), cur)) continue;
                JMenu sub = (JMenu)child;
                return KeYGuiExtensionFacade.findMenu(sub, mpath);
            }
            JMenu m = new JMenu(cur);
            m.setName(cur);
            menu.add(m);
            return KeYGuiExtensionFacade.findMenu(m, mpath);
        }
        return menu;
    }

    public static List<KeYGuiExtension.Toolbar> getToolbarExtensions() {
        return KeYGuiExtensionFacade.getExtensionInstances(KeYGuiExtension.Toolbar.class);
    }

    public static List<JToolBar> createToolbars(MainWindow mainWindow) {
        return KeYGuiExtensionFacade.getToolbarExtensions().stream().map(it -> it.getToolbar(mainWindow)).collect(Collectors.toList());
    }

    public static List<KeYGuiExtension.ContextMenu> getContextMenuExtensions() {
        return KeYGuiExtensionFacade.getExtensionInstances(KeYGuiExtension.ContextMenu.class);
    }

    public static JPopupMenu createContextMenu(ContextMenuKind kind, Object underlyingObject, KeYMediator mediator) {
        JPopupMenu menu = new JPopupMenu();
        List<Action> content = KeYGuiExtensionFacade.getContextMenuItems(kind, underlyingObject, mediator);
        content.forEach(menu::add);
        return menu;
    }

    public static void addContextMenuItems(ContextMenuKind kind, JPopupMenu menu, Object underlyingObject, KeYMediator mediator) {
        KeYGuiExtensionFacade.getContextMenuItems(kind, underlyingObject, mediator).forEach(it -> KeYGuiExtensionFacade.sortActionIntoMenu(it, menu));
    }

    public static List<Action> getContextMenuItems(ContextMenuKind kind, Object underlyingObject, KeYMediator mediator) {
        if (!kind.getType().isAssignableFrom(underlyingObject.getClass())) {
            throw new IllegalArgumentException();
        }
        return KeYGuiExtensionFacade.getContextMenuExtensions().stream().flatMap(it -> it.getContextActions(mediator, kind, underlyingObject).stream()).collect(Collectors.toList());
    }

    public static JMenu createTermMenu(ContextMenuKind kind, Object underlyingObject, KeYMediator mediator) {
        JMenu menu = new JMenu("Extensions");
        KeYGuiExtensionFacade.getContextMenuItems(kind, underlyingObject, mediator).forEach(it -> KeYGuiExtensionFacade.sortActionIntoMenu(it, menu));
        return menu;
    }

    private static void loadExtensions() {
        extensions = ServiceLoader.load(KeYGuiExtension.class).stream().map(ServiceLoader.Provider::type).filter(KeYGuiExtensionFacade::isNotForbidden).distinct().map(Extension::new).sorted().collect(Collectors.toList());
    }

    private static <T> Stream<Extension<T>> getExtensionsStream(Class<T> clazz) {
        return KeYGuiExtensionFacade.getExtensions().stream().filter(it -> !it.isDisabled()).filter(it -> clazz.isAssignableFrom(it.getType())).map(it -> it);
    }

    private static <T> List<T> getExtensionInstances(Class<T> c) {
        return KeYGuiExtensionFacade.getExtensionsStream(c).map(Extension::getInstance).collect(Collectors.toList());
    }

    private static <T> boolean isNotForbidden(Class<T> a) {
        if (forbiddenPlugins.contains(a.getName())) {
            return false;
        }
        String sys = System.getProperty(a.getName());
        return sys == null || !sys.equalsIgnoreCase("false");
    }

    public static List<Extension> getExtensions() {
        if (extensions.isEmpty()) {
            KeYGuiExtensionFacade.loadExtensions();
        }
        return extensions;
    }

    public static List<JComponent> getStatusLineComponents() {
        return KeYGuiExtensionFacade.getStatusLineExtensions().stream().flatMap(it -> it.getStatusLineComponents().stream()).collect(Collectors.toList());
    }

    public static List<KeYGuiExtension.StatusLine> getStatusLineExtensions() {
        return KeYGuiExtensionFacade.getExtensionInstances(KeYGuiExtension.StatusLine.class);
    }

    public static Collection<KeYGuiExtension.Settings> getSettingsProvider() {
        return KeYGuiExtensionFacade.getExtensionInstances(KeYGuiExtension.Settings.class);
    }

    public static List<KeYGuiExtension.Startup> getStartupExtensions() {
        return KeYGuiExtensionFacade.getExtensionInstances(KeYGuiExtension.Startup.class);
    }

    public static List<KeYGuiExtension.KeyboardShortcuts> getKeyboardShortcutsExtensions() {
        return KeYGuiExtensionFacade.getExtensionInstances(KeYGuiExtension.KeyboardShortcuts.class);
    }

    public static Stream<Action> getKeyboardShortcuts(KeYMediator mediator, String componentId, JComponent component) {
        return KeYGuiExtensionFacade.getKeyboardShortcutsExtensions().stream().flatMap(it -> it.getShortcuts(mediator, componentId, component).stream()).sorted(new ActionPriorityComparator());
    }

    public static void installKeyboardShortcuts(KeYMediator mediator, JComponent component, String componentId) {
        Stream<Action> provider = KeYGuiExtensionFacade.getKeyboardShortcuts(mediator, componentId, component);
        provider.forEach(it -> {
            int condition = it.getValue("SHORTCUT_FOCUSED_CONDITION") != null ? (Integer)it.getValue("SHORTCUT_FOCUSED_CONDITION") : 1;
            KeyStroke ks = (KeyStroke)(it.getValue("LOCAL_ACCELERATOR") != null ? it.getValue("LOCAL_ACCELERATOR") : it.getValue("AcceleratorKey"));
            component.registerKeyboardAction((ActionListener)it, ks, condition);
        });
    }

    public static List<KeYGuiExtension.Tooltip> getTooltipExtensions() {
        return KeYGuiExtensionFacade.getExtensionInstances(KeYGuiExtension.Tooltip.class);
    }

    public static List<String> getTooltipStrings(MainWindow window, PosInSequent pos) {
        return KeYGuiExtensionFacade.getTooltipExtensions().stream().flatMap(it -> it.getTooltipStrings(window, pos).stream()).collect(Collectors.toList());
    }

    public static Stream<String> getTermInfoStrings(MainWindow mainWindow, PosInSequent mousePos) {
        return KeYGuiExtensionFacade.getExtensionInstances(KeYGuiExtension.TermInfo.class).stream().flatMap(it -> it.getTermInfoStrings(mainWindow, mousePos).stream());
    }

    public void forbidClass(String clazz) {
        forbiddenPlugins.add(clazz);
        extensions = extensions.stream().filter(it -> !it.getType().getName().equals(clazz)).collect(Collectors.toList());
    }

    public void allowClass(String clazz) {
        forbiddenPlugins.remove(clazz);
    }

    private static class ActionPriorityComparator
    implements Comparator<Action> {
        private ActionPriorityComparator() {
        }

        @Override
        public int compare(Action o1, Action o2) {
            int a = this.getPriority(o1);
            int b = this.getPriority(o1);
            return a - b;
        }

        private int getPriority(Action action) {
            if (action.getValue("PRIORITY") != null) {
                return (Integer)action.getValue("PRIORITY");
            }
            return 0;
        }
    }
}

