/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.extension.impl;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.KeyAction;
import de.uka.ilkd.key.gui.extension.api.ContextMenuAdapter;
import de.uka.ilkd.key.gui.extension.api.ContextMenuKind;
import de.uka.ilkd.key.gui.extension.api.KeYGuiExtension;
import de.uka.ilkd.key.gui.extension.api.TabPanel;
import de.uka.ilkd.key.gui.fonticons.FontAwesomeSolid;
import de.uka.ilkd.key.gui.fonticons.IconFontSwing;
import de.uka.ilkd.key.gui.settings.InvalidSettingsInputException;
import de.uka.ilkd.key.gui.settings.SettingsProvider;
import de.uka.ilkd.key.pp.PosInSequent;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.rule.Rule;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KeYGuiExtension.Info(name="Test Extension", description="Should only be used for testing of the extension facade", priority=100000, optional=true)
public class TestExtension
implements KeYGuiExtension,
KeYGuiExtension.MainMenu,
KeYGuiExtension.LeftPanel,
KeYGuiExtension.StatusLine,
KeYGuiExtension.ContextMenu,
KeYGuiExtension.Toolbar,
KeYGuiExtension.KeyboardShortcuts,
KeYGuiExtension.Settings {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestExtension.class);
    private final KeyAction actionTest = new TestAction();
    private final ContextMenuAdapter cmAdapter = new ContextMenuAdapter(){

        @Override
        public List<Action> getContextActions(KeYMediator mediator, ContextMenuKind kind, Proof underlyingObject) {
            return Collections.singletonList(TestExtension.this.actionTest);
        }

        @Override
        public List<Action> getContextActions(KeYMediator mediator, ContextMenuKind kind, Node underlyingObject) {
            return Collections.singletonList(TestExtension.this.actionTest);
        }

        @Override
        public List<Action> getContextActions(KeYMediator mediator, ContextMenuKind kind, PosInSequent underlyingObject) {
            return Collections.singletonList(TestExtension.this.actionTest);
        }

        @Override
        public List<Action> getContextActions(KeYMediator mediator, ContextMenuKind kind, Rule underlyingObject) {
            return Collections.singletonList(TestExtension.this.actionTest);
        }
    };

    @Override
    public List<Action> getMainMenuActions(MainWindow mainWindow) {
        return Collections.singletonList(this.actionTest);
    }

    @Override
    public List<Action> getContextActions(KeYMediator mediator, ContextMenuKind kind, Object underlyingObject) {
        return this.cmAdapter.getContextActions(mediator, kind, underlyingObject);
    }

    @Override
    public JToolBar getToolbar(MainWindow mainWindow) {
        JToolBar bar = new JToolBar();
        bar.add(this.actionTest);
        return bar;
    }

    @Override
    public List<JComponent> getStatusLineComponents() {
        return Collections.singletonList(new JButton(this.actionTest));
    }

    @Override
    public SettingsProvider getSettings() {
        return new TestSettingsProvider();
    }

    @Override
    public Collection<TabPanel> getPanels(MainWindow window, KeYMediator mediator) {
        return Collections.singleton(new TabPanel(){

            @Override
            public String getTitle() {
                return "Test";
            }

            @Override
            public JComponent getComponent() {
                return new JLabel("Test");
            }
        });
    }

    @Override
    public Collection<Action> getShortcuts(KeYMediator mediator, String componentId, JComponent component) {
        return Collections.singleton(this.actionTest);
    }

    private class TestSettingsProvider
    implements SettingsProvider {
        private TestSettingsProvider() {
        }

        @Override
        public String getDescription() {
            return "Test Settings";
        }

        @Override
        public JComponent getPanel(MainWindow window) {
            return new JLabel("Test");
        }

        @Override
        public void applySettings(MainWindow window) throws InvalidSettingsInputException {
            LOGGER.trace("TestSettingsProvider.applySettings");
        }
    }

    private class TestAction
    extends KeyAction {
        private static final long serialVersionUID = -2701623640497343330L;

        public TestAction() {
            this.setName("Test");
            this.setMenuPath("Test.Test.Test");
            this.setIcon(IconFontSwing.buildIcon(FontAwesomeSolid.TEETH, 16.0f, Color.BLUE));
            this.putValue("LOCAL_ACCELERATOR", KeyStroke.getKeyStroke(49, 128));
            this.lookupAcceleratorKey();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(null, "Test!");
        }
    }
}

