/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.fonticons;

import de.uka.ilkd.key.gui.fonticons.DuneColorScheme;
import de.uka.ilkd.key.gui.fonticons.FontAwesomeRegular;
import de.uka.ilkd.key.gui.fonticons.FontAwesomeSolid;
import de.uka.ilkd.key.gui.fonticons.IconFontProvider;
import de.uka.ilkd.key.gui.fonticons.IconProvider;
import java.awt.Color;
import java.awt.Image;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IconFactory {
    public static final IconFontProvider QUIT = new IconFontProvider(FontAwesomeSolid.WINDOW_CLOSE);
    public static final IconFontProvider RECENT_FILES = new IconFontProvider(FontAwesomeSolid.CLOCK);
    public static final IconFontProvider SEARCH = new IconFontProvider(FontAwesomeSolid.SEARCH);
    public static final IconFontProvider SEARCH2 = new IconFontProvider(FontAwesomeSolid.SEARCH_LOCATION);
    public static final IconFontProvider STATISTICS = new IconFontProvider(FontAwesomeSolid.THERMOMETER_HALF);
    public static final IconFontProvider TOOLBOX = new IconFontProvider(FontAwesomeSolid.TOOLBOX);
    public static final IconFontProvider PLUS = new IconFontProvider(FontAwesomeSolid.PLUS_CIRCLE);
    public static final IconFontProvider MINUS = new IconFontProvider(FontAwesomeSolid.MINUS_CIRCLE);
    public static final IconFontProvider NEXT = new IconFontProvider(FontAwesomeSolid.ARROW_RIGHT);
    public static final IconFontProvider PREVIOUS = new IconFontProvider(FontAwesomeSolid.ARROW_LEFT);
    public static final IconFontProvider START = new IconFontProvider(FontAwesomeSolid.PLAY, Color.GREEN);
    public static final IconFontProvider STOP = new IconFontProvider(FontAwesomeSolid.STOP, Color.RED);
    public static final IconFontProvider CLOSE = new IconFontProvider(FontAwesomeSolid.TIMES);
    public static final IconFontProvider CONFIGURE_MENU = new IconFontProvider(FontAwesomeSolid.SORT_DOWN);
    public static final IconFontProvider OPEN_MOST_RECENT = new IconFontProvider(FontAwesomeSolid.REDO_ALT);
    public static final IconFontProvider OPEN_EXAMPLES = new IconFontProvider(FontAwesomeSolid.IMAGES);
    public static final IconFontProvider OPEN_KEY_FILE = new IconFontProvider(FontAwesomeSolid.FOLDER_OPEN);
    public static final IconFontProvider SAVE_FILE = new IconFontProvider(FontAwesomeSolid.SAVE);
    public static final IconFontProvider SAVE_BUNDLE = new IconFontProvider(FontAwesomeRegular.SAVE);
    public static final IconFontProvider EDIT = new IconFontProvider(FontAwesomeSolid.EDIT);
    public static final IconFontProvider INTERACTIVE = new IconFontProvider(FontAwesomeSolid.HAND_POINT_RIGHT);
    public static final IconFontProvider SCRIPT = new IconFontProvider(FontAwesomeSolid.SCROLL);
    public static final IconFontProvider PRUNE = new IconFontProvider(FontAwesomeSolid.CUT);
    public static final IconFontProvider GOAL_BACK = new IconFontProvider(FontAwesomeSolid.BACKSPACE);
    public static final IconFontProvider EXPAND_GOALS = new IconFontProvider(FontAwesomeSolid.EXPAND_ARROWS_ALT);
    public static final IconFontProvider CONFIGURE = new IconFontProvider(FontAwesomeSolid.COG);
    public static final IconFontProvider HELP = new IconFontProvider(FontAwesomeSolid.QUESTION_CIRCLE);
    public static final IconFontProvider PROOF_MANAGEMENT = new IconFontProvider(FontAwesomeSolid.TASKS);
    public static final IconFontProvider PROPERTIES = new IconFontProvider(FontAwesomeSolid.COG);
    public static final IconProvider SEARCH_PREV = new IconFontProvider(FontAwesomeSolid.ARROW_RIGHT);
    public static final IconFontProvider EXPERIMENTAL_EXTENSION = new IconFontProvider(FontAwesomeSolid.FLASK);
    public static final IconFontProvider COUNTER_EXAMPLE = new IconFontProvider(FontAwesomeSolid.BOMB);
    public static final IconFontProvider TEST_CASE_GENERATION = new IconFontProvider(FontAwesomeSolid.VIALS);
    public static final IconFontProvider ORIGIN_HIGHLIGHT_ICON = new IconFontProvider(FontAwesomeSolid.HIGHLIGHTER);
    public static final IconFontProvider ORIGIN_ICON = new IconFontProvider(FontAwesomeSolid.ROUTE);
    public static final IconFontProvider WINDOW_ICON = new IconFontProvider(FontAwesomeSolid.WINDOW_RESTORE);
    public static final IconProvider PLUS_SQUARED = new IconFontProvider(FontAwesomeSolid.PLUS_SQUARE);
    public static final float DEFAULT_SIZE = 16.0f;
    public static final Color CLOSED_GREEN = DuneColorScheme.green;
    public static final Color BLUE = DuneColorScheme.blue;
    public static final Color ERROR_COLOR = DuneColorScheme.red;
    public static final Color WARNING_COLOR = DuneColorScheme.orange;
    public static final Color LINKED_FOLDER_COLOR = new Color(255, 0, 240);
    public static final Color CLOSABLE_FOLDER_COLOR = Color.blue.darker();
    public static final IconFontProvider AUTO_MODE_START = new IconFontProvider(FontAwesomeSolid.PLAY_CIRCLE, CLOSED_GREEN);
    public static final IconFontProvider AUTO_MODE_STOP = new IconFontProvider(FontAwesomeSolid.STOP_CIRCLE, ERROR_COLOR);
    public static final IconProvider PROOF_SEARCH_STRATEGY = new IconFontProvider(FontAwesomeSolid.COG);
    public static final IconProvider PROOF_TREE = new IconFontProvider(FontAwesomeSolid.SITEMAP);
    public static final IconProvider INFO_VIEW = new IconFontProvider(FontAwesomeSolid.INFO_CIRCLE);
    public static final IconProvider TREE_NODE_EXPANDED = new IconFontProvider(FontAwesomeSolid.CARET_DOWN);
    public static final IconProvider TREE_NODE_RETRACTED = new IconFontProvider(FontAwesomeSolid.CARET_RIGHT);
    public static final IconProvider WARNING_UNSOUND = new IconFontProvider(FontAwesomeSolid.EXCLAMATION_TRIANGLE, ERROR_COLOR);
    public static final IconProvider WARNING_INCOMPLETE = new IconFontProvider(FontAwesomeSolid.EXCLAMATION_TRIANGLE, WARNING_COLOR);
    public static final IconProvider SEARCH_REGROUP = new IconFontProvider(FontAwesomeSolid.VIDEO);
    public static final IconProvider EXPORT_MU_SCRIPT = new IconFontProvider(FontAwesomeSolid.FILE_EXPORT);
    public static final IconProvider EXPORT_MU_SCRIPT_CLIPBOARD = new IconFontProvider(FontAwesomeRegular.COPY);
    public static final IconProvider JUMP_INTO_TREE = new IconFontProvider(FontAwesomeSolid.MAP_MARKED);
    public static final IconProvider HEATMAP_DEACTIVATE = new IconFontProvider(FontAwesomeSolid.SHOE_PRINTS);
    public static final IconProvider HEATMAP_ACTIVATE = new IconFontProvider(FontAwesomeSolid.SHOE_PRINTS);
    public static final IconFontProvider PROVED_FOLDER_ICON = new IconFontProvider(FontAwesomeSolid.FOLDER, CLOSED_GREEN);
    public static final IconFontProvider LINKED_FOLDER_ICON = new IconFontProvider(FontAwesomeSolid.FOLDER, LINKED_FOLDER_COLOR);
    public static final IconFontProvider CLOSABLE_FOLDER_ICON = new IconFontProvider(FontAwesomeSolid.FOLDER, CLOSABLE_FOLDER_COLOR);
    public static final IconFontProvider GOAL_CLOSED = new IconFontProvider(FontAwesomeSolid.CHECK, CLOSED_GREEN);
    public static final IconFontProvider SELECT_GOAL_ABOVE = new IconFontProvider(FontAwesomeSolid.ANGLE_UP);
    public static final IconFontProvider SELECT_GOAL_BELOW = new IconFontProvider(FontAwesomeSolid.ANGLE_DOWN);
    public static final IconFontProvider SEARCH_HIGHLIGHT = new IconFontProvider(FontAwesomeSolid.HIGHLIGHTER);
    public static final IconFontProvider ABONDON = new IconFontProvider(FontAwesomeSolid.TRASH_ALT);
    public static final IconFontProvider SEARCH_HIDE = new IconFontProvider(FontAwesomeSolid.LOW_VISION);
    public static final IconFontProvider SEARCH_NEXT = new IconFontProvider(FontAwesomeSolid.ARROW_LEFT);
    public static final IconFontProvider ORIGIN_LABELS = new IconFontProvider(FontAwesomeSolid.ROUTE);
    private static final Logger LOGGER = LoggerFactory.getLogger(IconFactory.class);
    private static Image keyHole = IconFactory.getImage("images/ekey-mono.gif");
    private static Image keyHoleAlmostClosed = IconFactory.getImage("images/ekey-brackets.gif");
    private static Image keyHoleInteractive = IconFactory.getImage("images/keyinteractive.gif");
    private static Image keyHoleLinked = IconFactory.getImage("images/keylinked.gif");
    private static Image keyLogo = IconFactory.getImage("images/key-color.png");
    private static final Image keyLogoShadow = IconFactory.getImage("images/key-shadow.png");
    private static final Image keyVersionLogo = IconFactory.getImage("images/key-shadow-2.10.png");
    private static Image keyLogoSmall = IconFactory.getImage("images/key-color-icon-square.gif");
    private static Image oneStepSimplifier = IconFactory.getImage("images/toolbar/oneStepSimplifier.png");
    private static Image junit = IconFactory.getImage("images/toolbar/junit_logo.png");
    private static Image jml = IconFactory.getImage("images/toolbar/jml.png");
    private static Image uml = IconFactory.getImage("images/toolbar/uml.png");
    private static HashMap<String, Icon> cache = new HashMap();

    private IconFactory() {
    }

    public static Image getImage(String s) {
        ImageIcon ii = IconFactory.createImageIcon(IconFactory.class, s);
        return ii != null ? ii.getImage() : null;
    }

    private static ImageIcon createImageIcon(Class<?> cl, String filename) {
        filename = "/de/uka/ilkd/key/gui/" + (String)filename;
        URL iconURL = cl.getResource((String)filename);
        LOGGER.debug("Load Resource:" + (String)filename + " of class " + cl);
        if (iconURL == null && cl.getSuperclass() != null) {
            return IconFactory.createImageIcon(cl.getSuperclass(), (String)filename);
        }
        if (iconURL == null && cl.getSuperclass() == null) {
            LOGGER.warn("No image resource " + (String)filename + " found");
            return null;
        }
        LOGGER.trace("Done.");
        return new ImageIcon(iconURL);
    }

    private static ImageIcon scaleIcon(Image im, int x, int y) {
        Image scaledim = im.getScaledInstance(x, y, 4);
        return new ImageIcon(scaledim);
    }

    public static Icon abandon(int x) {
        return ABONDON.load(x);
    }

    public static Icon configure(int x) {
        return CONFIGURE.load(x);
    }

    public static Icon help(int x) {
        return HELP.load(x);
    }

    public static Icon proofMgt(int x) {
        return PROOF_MANAGEMENT.load(x);
    }

    public static Icon properties(int x) {
        return PROPERTIES.load(x);
    }

    public static Icon quit(int x) {
        return QUIT.load(x);
    }

    public static Icon recentFiles(int x) {
        return RECENT_FILES.load(x);
    }

    public static Icon search(int x) {
        return SEARCH.load(x);
    }

    public static Icon search2(int x) {
        return SEARCH2.load(x);
    }

    public static Icon statistics(int x) {
        return STATISTICS.load(x);
    }

    public static Icon toolbox(int x) {
        return TOOLBOX.load(x);
    }

    public static Icon plus(int x) {
        return PLUS.load(x);
    }

    public static Icon minus(int x) {
        return MINUS.load(x);
    }

    public static Icon expandGoals(int x) {
        return EXPAND_GOALS.load(x);
    }

    public static Icon next(int x) {
        return NEXT.load(x);
    }

    public static Icon previous(int x) {
        return PREVIOUS.load(x);
    }

    public static Icon stop(int x) {
        return STOP.load(x);
    }

    public static Icon close(int x) {
        return CLOSE.load(x);
    }

    public static ImageIcon keyHole(int x, int y) {
        return IconFactory.scaleIcon(keyHole, x, y);
    }

    public static Icon keyHoleClosed(int x) {
        return GOAL_CLOSED.load(x);
    }

    public static Icon selectGoalAbove(int size) {
        return SELECT_GOAL_ABOVE.load(size);
    }

    public static Icon selectGoalBelow(int size) {
        return SELECT_GOAL_BELOW.load(size);
    }

    public static ImageIcon keyHoleAlmostClosed(int x, int y) {
        return IconFactory.scaleIcon(keyHoleAlmostClosed, x, y);
    }

    public static ImageIcon keyHoleInteractive(int x, int y) {
        return IconFactory.scaleIcon(keyHoleInteractive, x, y);
    }

    public static ImageIcon keyHoleLinked(int x, int y) {
        return IconFactory.scaleIcon(keyHoleLinked, x, y);
    }

    public static ImageIcon keyLogo(int x, int y) {
        return IconFactory.scaleIcon(keyLogo, x, y);
    }

    public static Icon keyVersionLogo() {
        return new ImageIcon(keyVersionLogo);
    }

    public static Icon keyVersionLogo(int x, int y) {
        return IconFactory.scaleIcon(keyVersionLogo, x, y);
    }

    public static Icon autoModeStartLogo(int size) {
        return AUTO_MODE_START.load(size);
    }

    public static Icon strategyStartLogo(int size) {
        return START.load(size);
    }

    public static Icon autoModeStopLogo(int size) {
        return AUTO_MODE_STOP.load(size);
    }

    public static Icon selectDecProcArrow(int size) {
        return CONFIGURE_MENU.load(size);
    }

    public static Icon oneStepSimplifier(int size) {
        return IconFactory.scaleIcon(oneStepSimplifier, size, size);
    }

    public static Icon testGeneration(int size) {
        return TEST_CASE_GENERATION.get(size);
    }

    public static Icon counterExample(int size) {
        return COUNTER_EXAMPLE.get(size);
    }

    public static Icon junitLogo(int size) {
        return IconFactory.scaleIcon(junit, size, size);
    }

    public static Icon jmlLogo(int size) {
        return IconFactory.scaleIcon(jml, size, size);
    }

    public static Icon pruneLogo(int size) {
        return PRUNE.load(size);
    }

    public static Icon goalBackLogo(int size) {
        return GOAL_BACK.load(size);
    }

    public static Icon provedFolderIcon(int height) {
        return PROVED_FOLDER_ICON.load(height);
    }

    public static Icon linkedFolderIcon(int height) {
        return LINKED_FOLDER_ICON.load(height);
    }

    public static Icon closableFolderIcon(int height) {
        return CLOSABLE_FOLDER_ICON.load(height);
    }

    public static Icon expandedIcon(int height) {
        return TREE_NODE_EXPANDED.load(height);
    }

    public static Icon collapsedIcon(int height) {
        return TREE_NODE_RETRACTED.load(height);
    }

    public static Image keyLogo() {
        return keyLogoSmall;
    }

    public static Icon openMostRecent(int size) {
        return OPEN_MOST_RECENT.load(size);
    }

    public static Icon openExamples(int size) {
        return OPEN_EXAMPLES.load(size);
    }

    public static Icon openKeYFile(int size) {
        return OPEN_KEY_FILE.load(size);
    }

    public static Icon saveFile(int size) {
        return SAVE_FILE.load(size);
    }

    public static Icon saveBundle(int size) {
        return SAVE_BUNDLE.load(size);
    }

    public static Icon editFile(int size) {
        return EDIT.load(size);
    }

    public static Icon interactiveAppLogo(int size) {
        return INTERACTIVE.load(size);
    }

    public static Icon scriptAppLogo(int size) {
        return SCRIPT.load(size);
    }

    public static Icon get(IconProvider provider, float size) {
        return cache.computeIfAbsent(provider.getKey(size), d -> provider.load(size));
    }

    public static List<? extends Image> applicationLogos() {
        Image original = IconFactory.keyLogo();
        int[] sizes = new int[]{16, 20, 32, 40, 64, 128};
        ArrayList<Image> images = new ArrayList<Image>(sizes.length);
        for (int sz : sizes) {
            images.add(original.getScaledInstance(sz, sz, 4));
        }
        return images;
    }
}

