/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.fonticons;

import de.uka.ilkd.key.gui.fonticons.IconFont;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public final class IconFontSwing {
    public static Image buildImage(IconFont iconCode, float size) {
        return IconFontSwing.buildImage(iconCode, size, Color.BLACK);
    }

    public static Image buildImage(IconFont iconCode, float size, Color color) {
        Font font = IconFontSwing.buildFont(iconCode, size);
        String text = Character.toString(iconCode.getUnicode());
        return IconFontSwing.buildImage(text, font, color);
    }

    public static Image buildImage(IconFont iconCode, float size, Color color, double rotation) {
        Image img = IconFontSwing.buildImage(iconCode, size, color);
        BufferedImage newImage = new BufferedImage((int)size, (int)size, 1);
        Graphics2D graphics = (Graphics2D)newImage.getGraphics();
        AffineTransform transform = new AffineTransform();
        transform.rotate(rotation, size / 2.0f, size / 2.0f);
        graphics.drawImage(img, transform, null);
        return img;
    }

    public static Icon buildIcon(IconFont iconCode, float size) {
        return IconFontSwing.buildIcon(iconCode, size, Color.BLACK);
    }

    public static Icon buildIcon(IconFont iconCode, float size, Color color) {
        return new ImageIcon(IconFontSwing.buildImage(iconCode, size, color));
    }

    private static BufferedImage buildImage(String text, Font font, Color color) {
        JLabel label = new JLabel(text);
        label.setForeground(color);
        label.setFont(font);
        Dimension dim = label.getPreferredSize();
        int width = dim.width + 1;
        int height = dim.height + 1;
        label.setSize(width, height);
        BufferedImage bufImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = bufImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        label.print(g2d);
        g2d.dispose();
        return bufImage;
    }

    private static Font buildFont(IconFont iconCode, float size) {
        try {
            Font f = iconCode.getFont();
            return f.deriveFont(size);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Font("Monospaced", 0, (int)size);
        }
    }
}

