/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.help;

import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.action.CButton;
import de.uka.ilkd.key.gui.actions.KeyAction;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.help.HelpInfo;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class HelpFacade {
    public static final String KEY_HELP_URL = "key.help.url";
    public static final KeyAction ACTION_OPEN_HELP = new OpenHelpAction();
    public static String HELP_BASE_URL = "https://key-project.org/docs/";

    private static void openHelpInBrowser(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public static void openHelp() {
        HelpFacade.openHelpInBrowser(HELP_BASE_URL);
    }

    public static void openHelp(String path) {
        HelpFacade.openHelpInBrowser(HELP_BASE_URL + path);
    }

    public static void openHelp(Component path) {
        while (path != null && !HelpFacade.openHelpOfClass(path.getClass())) {
            path = path.getParent();
        }
    }

    public static boolean openHelpOfClass(Class<?> clazz) {
        HelpInfo help = clazz.getAnnotation(HelpInfo.class);
        if (help != null) {
            HelpFacade.openHelpInBrowser(HELP_BASE_URL + help.path());
            return true;
        }
        return false;
    }

    public static CAction createHelpButton(String s) {
        CButton btn = new CButton("", IconFactory.HELP.get());
        btn.addActionListener(e -> HelpFacade.openHelp(s));
        return btn;
    }

    public static KeyAction createHelpAction(String path) {
        class HelpAction
        extends KeyAction {
            final /* synthetic */ String val$path;

            private HelpAction(String string) {
                this.val$path = string;
                this.setName("");
                this.setIcon(IconFactory.HELP.get());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpFacade.openHelp(this.val$path);
            }
        }
        return new HelpAction(path);
    }

    static {
        if (System.getProperty("KEY_HELP_URL") != null) {
            HELP_BASE_URL = System.getProperty(KEY_HELP_URL);
        }
    }

    private static class OpenHelpAction
    extends KeyAction {
        private static final long serialVersionUID = 85722762932429493L;

        public OpenHelpAction() {
            this.setName("Open help");
            this.setAcceleratorKey(KeyStroke.getKeyStroke(112, 128));
            this.lookupAcceleratorKey();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e != null && e.getSource() != null) {
                HelpFacade.openHelp((JComponent)e.getSource());
            }
        }
    }
}

