/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.join;

import de.uka.ilkd.key.gui.InspectorForDecisionPredicates;
import de.uka.ilkd.key.gui.join.SequentViewer;
import de.uka.ilkd.key.gui.utilities.CheckedUserInput;
import de.uka.ilkd.key.gui.utilities.ClickableMessageBox;
import de.uka.ilkd.key.gui.utilities.InspectorForFormulas;
import de.uka.ilkd.key.gui.utilities.StdDialog;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.pp.LogicPrinter;
import de.uka.ilkd.key.pp.NotationInfo;
import de.uka.ilkd.key.pp.ProgramPrinter;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.delayedcut.ApplicationCheck;
import de.uka.ilkd.key.proof.delayedcut.DelayedCutProcessor;
import de.uka.ilkd.key.proof.join.LateApplicationCheck;
import de.uka.ilkd.key.proof.join.PredicateEstimator;
import de.uka.ilkd.key.proof.join.ProspectivePartner;
import java.awt.Color;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JoinDialog
extends StdDialog {
    private static final Color GREEN = new Color(0, 128, 0);
    private static final long serialVersionUID = 1L;
    private final ContentPanel content;
    private static final String INFO = "It is not possible to join both goals, because new symbols have been introduced\n on the branches which belong to the goals: Up to now the treatment of new symbols\nis not supported by the joining mechanism.\n\n";

    public JoinDialog(List<ProspectivePartner> partnerList, Proof proof, PredicateEstimator estimator, Services services) {
        super("Joining", 5, false);
        this.content = new ContentPanel(partnerList, proof, estimator, new CheckedUserInput.CheckedUserInputListener(){

            @Override
            public void userInputChanged(String input, boolean valid, String reason) {
                JoinDialog.this.getOkButton().setEnabled(valid);
            }
        }, services);
        this.setContent(this.content);
    }

    public ProspectivePartner getSelectedPartner() {
        return this.content.getSelectedPartner();
    }

    private static class ContentPanel
    extends Box {
        private static final long serialVersionUID = 1L;
        private SequentViewer sequentViewer1;
        private SequentViewer sequentViewer2;
        private JList<ContentItem> choiceList;
        private CheckedUserInput predicateInput;
        private JLabel joinHeadline;
        private JLabel infoPredicate;
        private ClickableMessageBox infoBox;
        private JScrollPane infoBoxPane = null;
        private final Proof proof;
        private final PredicateEstimator estimator;

        public ContentPanel(List<ProspectivePartner> partnerList, final Proof proof, PredicateEstimator estimator, final CheckedUserInput.CheckedUserInputListener listener, Services services) {
            super(1);
            this.proof = proof;
            this.estimator = estimator;
            this.create();
            this.getPredicateInput().addListener(new CheckedUserInput.CheckedUserInputListener(){

                @Override
                public void userInputChanged(String input, boolean valid, String reason) {
                    if (valid) {
                        this.getSelectedPartner().setCommonPredicate(InspectorForFormulas.translate(proof.getServices(), input));
                        if (this.getSelectedItem().isApplicable()) {
                            listener.userInputChanged(input, true, reason);
                        } else {
                            listener.userInputChanged(input, false, reason);
                        }
                    } else {
                        listener.userInputChanged(input, false, reason);
                    }
                    this.refreshInfoBox(reason);
                }
            });
            if (!partnerList.isEmpty()) {
                this.fill(partnerList, services);
            }
        }

        private void fill(List<ProspectivePartner> partnerList, Services services) {
            Node node = partnerList.get(0).getNode(0);
            this.getHeadline().setText("<html><b>Join Goal " + node.serialNr() + "</b></html>");
            this.getSequentViewer1().setSequent(node.sequent(), this.proof.getServices());
            DefaultListModel<ContentItem> model = new DefaultListModel<ContentItem>();
            for (ProspectivePartner partner : partnerList) {
                PredicateEstimator.Result result = this.estimator.estimate(partner, this.proof);
                partner.setCommonPredicate(result.getPredicate());
                partner.setCommonParent(result.getCommonParent());
                ApplicationCheck.NoNewSymbolsCheck check = new ApplicationCheck.NoNewSymbolsCheck();
                boolean applicable = true;
                applicable = LateApplicationCheck.INSTANCE.check(partner.getNode(0), result.getCommonParent(), (ApplicationCheck)check).isEmpty() && applicable;
                applicable = LateApplicationCheck.INSTANCE.check(partner.getNode(1), result.getCommonParent(), (ApplicationCheck)check).isEmpty() && applicable;
                model.addElement(new ContentItem(partner, services, applicable));
            }
            this.getChoiceList().setModel(model);
            this.getChoiceList().setSelectedIndex(0);
        }

        private void selectionChanged(int index) {
            if (index < 0 || index > this.getChoiceList().getModel().getSize()) {
                return;
            }
            ContentItem item = this.choiceList.getModel().getElementAt(index);
            this.getSequentViewer2().setSequent(item.getSequent(), this.proof.getServices());
            this.getPredicateInput().setInput(item.getPredicate(this.proof));
            this.getPredicateInput().setInspector(item.getInspector());
            this.getInfoPredicate().setText(item.getPredicateInfo());
        }

        private Box createLeftAlignedComponent(JComponent comp) {
            Box box = Box.createHorizontalBox();
            box.add(comp);
            box.add(Box.createHorizontalGlue());
            return box;
        }

        private void create() {
            Box box = Box.createHorizontalBox();
            box.add(this.getHeadline());
            box.add(Box.createHorizontalGlue());
            this.add(Box.createVerticalStrut(5));
            this.add(box);
            this.add(Box.createVerticalStrut(5));
            box = Box.createHorizontalBox();
            Box vertBox = Box.createVerticalBox();
            vertBox.add(this.createLeftAlignedComponent(this.getHeadline()));
            vertBox.add(new JScrollPane(this.getSequentViewer1()));
            box.add(vertBox);
            vertBox = Box.createVerticalBox();
            JLabel label = new JLabel("<html><b>with</b></html>");
            label.setFont(this.getFont());
            vertBox.add(this.createLeftAlignedComponent(label));
            Box horzBox = Box.createHorizontalBox();
            horzBox.add(new JScrollPane(this.getChoiceList()));
            horzBox.add(Box.createHorizontalStrut(5));
            horzBox.add(new JScrollPane(this.getSequentViewer2()));
            vertBox.add(horzBox);
            box.add(vertBox);
            this.add(box);
            this.add(Box.createVerticalStrut(5));
            this.add(this.createLeftAlignedComponent(this.getInfoPredicate()));
            this.add(this.getPredicateInput());
            this.add(Box.createVerticalStrut(5));
            this.add(this.getInfoBoxPane());
            this.add(Box.createVerticalStrut(5));
        }

        private void refreshInfoBox(String reason) {
            ContentItem item = this.getSelectedItem();
            this.getInfoBox().clear();
            if (!item.isApplicable()) {
                this.getInfoBox().add(JoinDialog.INFO, "Goal " + item.partner.getNode(0).serialNr() + " and Goal " + item.partner.getNode(1).serialNr() + " cannot be joined.", Color.RED);
            } else if (reason != null) {
                String[] segments = reason.split("#");
                this.getInfoBox().add(segments.length > 1 ? segments[1] : null, segments[0], Color.RED);
            } else {
                this.getInfoBox().add(null, "Join is applicable.", GREEN);
            }
        }

        private JComponent getInfoBoxPane() {
            if (this.infoBoxPane == null) {
                this.infoBoxPane = new JScrollPane(this.getInfoBox());
                this.infoBoxPane.setBorder(BorderFactory.createTitledBorder("Details"));
                int height = this.getInfoBox().getFontMetrics(this.getInfoBox().getFont()).getHeight() * 4;
                this.infoBoxPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
                this.infoBoxPane.setPreferredSize(new Dimension(0, height));
            }
            return this.infoBoxPane;
        }

        private ClickableMessageBox getInfoBox() {
            if (this.infoBox == null) {
                this.infoBox = new ClickableMessageBox();
                this.infoBox.setBackground(this.getBackground());
                this.infoBox.add(new ClickableMessageBox.ClickableMessageBoxListener(){

                    @Override
                    public void eventMessageClicked(Object object) {
                        JOptionPane.showMessageDialog(infoBox, object.toString(), "Problem Description", 1);
                    }
                });
            }
            return this.infoBox;
        }

        private JLabel getInfoPredicate() {
            if (this.infoPredicate == null) {
                this.infoPredicate = new JLabel(" ");
                this.infoPredicate.setFont(this.getFont());
            }
            return this.infoPredicate;
        }

        private CheckedUserInput getPredicateInput() {
            if (this.predicateInput == null) {
                this.predicateInput = new CheckedUserInput(false);
            }
            return this.predicateInput;
        }

        private JList<ContentItem> getChoiceList() {
            if (this.choiceList == null) {
                this.choiceList = new JList();
                this.choiceList.setSelectionMode(0);
                this.choiceList.setPreferredSize(new Dimension(100, 300));
                this.choiceList.addListSelectionListener(new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent e) {
                        this.selectionChanged(choiceList.getSelectedIndex());
                    }
                });
            }
            return this.choiceList;
        }

        private JLabel getHeadline() {
            if (this.joinHeadline == null) {
                this.joinHeadline = new JLabel("Join");
                this.joinHeadline.setFont(this.getFont());
                this.joinHeadline.setAlignmentX(0.0f);
            }
            return this.joinHeadline;
        }

        private SequentViewer getSequentViewer1() {
            if (this.sequentViewer1 == null) {
                this.sequentViewer1 = new SequentViewer();
                this.sequentViewer1.setPreferredSize(new Dimension(400, 200));
            }
            return this.sequentViewer1;
        }

        private SequentViewer getSequentViewer2() {
            if (this.sequentViewer2 == null) {
                this.sequentViewer2 = new SequentViewer();
                this.sequentViewer2.setPreferredSize(new Dimension(300, 300));
            }
            return this.sequentViewer2;
        }

        public ProspectivePartner getSelectedPartner() {
            return this.getSelectedItem().partner;
        }

        public ContentItem getSelectedItem() {
            int index = this.getChoiceList().getSelectedIndex();
            return this.getChoiceList().getModel().getElementAt(index);
        }

        private static class ContentItem {
            final ProspectivePartner partner;
            final CheckedUserInput.CheckedUserInputInspector inspector;
            final boolean applicable;

            public ContentItem(ProspectivePartner partner, Services services, boolean applicable) {
                this.partner = partner;
                this.inspector = new InspectorForDecisionPredicates(services, partner.getCommonParent(), 0, DelayedCutProcessor.getApplicationChecks());
                this.applicable = applicable;
            }

            public CheckedUserInput.CheckedUserInputInspector getInspector() {
                return this.inspector;
            }

            public boolean isApplicable() {
                return this.applicable;
            }

            Sequent getSequent() {
                return this.partner.getNode(1).sequent();
            }

            public String toString() {
                return "Goal " + this.partner.getNode(1).serialNr();
            }

            public String getPredicateInfo() {
                return "Decision Formula (true for Goal " + this.partner.getNode(0).serialNr() + ", false for Goal " + this.partner.getNode(1).serialNr() + ")";
            }

            public String getPredicate(Proof proof) {
                if (this.partner.getCommonPredicate() == null) {
                    return "";
                }
                LogicPrinter printer = new LogicPrinter(new ProgramPrinter(), new NotationInfo(), proof.getServices());
                try {
                    printer.printTerm(this.partner.getCommonPredicate());
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                String result = printer.toString();
                if (result.endsWith("\n")) {
                    result = result.substring(0, result.length() - 1);
                }
                return result;
            }
        }
    }
}

