/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.join;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.join.JoinDialog;
import de.uka.ilkd.key.gui.notification.events.ExceptionFailureEvent;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.join.JoinProcessor;
import de.uka.ilkd.key.proof.join.PredicateEstimator;
import de.uka.ilkd.key.proof.join.ProspectivePartner;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.key_project.util.collection.ImmutableList;

public class JoinMenuItem
extends JMenuItem {
    private static final long serialVersionUID = -2602116358650063634L;

    public JoinMenuItem(final List<ProspectivePartner> partner, final Proof proof, final KeYMediator mediator) {
        this.setText(this.toString());
        this.setAction(new AbstractAction(this.toString()){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                mediator.stopInterface(true);
                JoinDialog dialog = new JoinDialog(partner, proof, PredicateEstimator.STD_ESTIMATOR, proof.getServices());
                dialog.setVisible(true);
                if (dialog.okButtonHasBeenPressed()) {
                    JoinMenuItem.this.start(dialog.getSelectedPartner(), proof, mediator);
                } else {
                    mediator.startInterface(true);
                }
            }
        });
    }

    private void start(ProspectivePartner partner, Proof proof, final KeYMediator mediator) {
        JoinProcessor processor = new JoinProcessor(partner, proof);
        processor.addListener(new JoinProcessor.Listener(){

            public void exceptionWhileJoining(Throwable e) {
                mediator.notify(new ExceptionFailureEvent(e.getMessage(), e));
                mediator.startInterface(true);
            }

            public void endOfJoining(final ImmutableList<Goal> goals) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        mediator.startInterface(true);
                        mediator.getUI().getProofControl().startAutoMode(mediator.getSelectedProof(), goals);
                    }
                });
            }
        });
        Thread thread = new Thread((Runnable)processor, "ProofJoinProcessor");
        thread.start();
    }

    @Override
    public String toString() {
        return "Delayed Cut Join Rule";
    }
}

