/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.keyshortcuts;

import de.uka.ilkd.key.gui.keyshortcuts.KeyStrokeSettings;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.KeyStroke;

public final class KeyStrokeManager {
    public static final int SHORTCUT_KEY_MASK = KeyStrokeManager.getShortcutMask();
    public static final boolean FKEY_MACRO_SCHEME = Boolean.getBoolean("key.gui.fkeyscheme");
    public static final int MULTI_KEY_MASK = SHORTCUT_KEY_MASK | 0x40;
    static final Map<String, WeakReference<Action>> actions = new HashMap<String, WeakReference<Action>>(100);

    public static KeyStroke get(String key, KeyStroke defaultValue) {
        KeyStroke ks = KeyStrokeSettings.getInstance().getKeyStroke(key, defaultValue);
        KeyStrokeSettings.getInstance().setKeyStroke(key, ks, false);
        return ks;
    }

    public static KeyStroke get(Object action, String defaultValue) {
        return KeyStrokeManager.get(action, KeyStroke.getKeyStroke(defaultValue));
    }

    public static KeyStroke get(Object action, KeyStroke defaultValue) {
        return KeyStrokeManager.get(action.getClass().getName(), defaultValue);
    }

    public static KeyStroke get(Object action) {
        return KeyStrokeManager.get(action, (KeyStroke)null);
    }

    public static KeyStroke lookupAndOverride(Action action) {
        return KeyStrokeManager.lookupAndOverride(action, action.getClass().getName());
    }

    public static KeyStroke lookupAndOverride(Action action, String key) {
        KeyStroke def = (KeyStroke)action.getValue("AcceleratorKey");
        KeyStroke found = KeyStrokeManager.get(key, def);
        action.putValue("AcceleratorKey", found);
        KeyStrokeManager.registerAction(action);
        return found;
    }

    public static void registerAction(Action action) {
        actions.put(action.getClass().getName(), new WeakReference<Action>(action));
    }

    public static KeyStrokeSettings getSettings() {
        return KeyStrokeSettings.getInstance();
    }

    static Action findAction(String clazz) {
        return (Action)actions.getOrDefault(clazz, new WeakReference<Object>(null)).get();
    }

    private static int getShortcutMask() {
        try {
            return Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        }
        catch (HeadlessException e) {
            return 0;
        }
    }
}

