/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.keyshortcuts;

import de.uka.ilkd.key.gui.actions.DecreaseFontSizeAction;
import de.uka.ilkd.key.gui.actions.EditMostRecentFileAction;
import de.uka.ilkd.key.gui.actions.GoalBackAction;
import de.uka.ilkd.key.gui.actions.IncreaseFontSizeAction;
import de.uka.ilkd.key.gui.actions.KeYProjectHomepageAction;
import de.uka.ilkd.key.gui.actions.OpenExampleAction;
import de.uka.ilkd.key.gui.actions.PrettyPrintToggleAction;
import de.uka.ilkd.key.gui.actions.PruneProofAction;
import de.uka.ilkd.key.gui.actions.QuickLoadAction;
import de.uka.ilkd.key.gui.actions.QuickSaveAction;
import de.uka.ilkd.key.gui.actions.UnicodeToggleAction;
import de.uka.ilkd.key.gui.help.HelpFacade;
import de.uka.ilkd.key.gui.keyshortcuts.KeyStrokeManager;
import de.uka.ilkd.key.gui.settings.SettingsManager;
import de.uka.ilkd.key.macros.AutoPilotPrepareProofMacro;
import de.uka.ilkd.key.macros.FinishSymbolicExecutionMacro;
import de.uka.ilkd.key.macros.FullAutoPilotProofMacro;
import de.uka.ilkd.key.macros.FullPropositionalExpansionMacro;
import de.uka.ilkd.key.macros.HeapSimplificationMacro;
import de.uka.ilkd.key.macros.IntegerSimplificationMacro;
import de.uka.ilkd.key.macros.OneStepProofMacro;
import de.uka.ilkd.key.macros.PropositionalExpansionMacro;
import de.uka.ilkd.key.macros.SMTPreparationMacro;
import de.uka.ilkd.key.macros.TryCloseMacro;
import de.uka.ilkd.key.macros.UpdateSimplificationMacro;
import de.uka.ilkd.key.settings.AbstractPropertiesSettings;
import de.uka.ilkd.key.settings.PathConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStrokeSettings
extends AbstractPropertiesSettings {
    public static final String SETTINGS_FILENAME = "keystrokes.properties";
    public static final File SETTINGS_FILE = new File(PathConfig.getKeyConfigDir(), "keystrokes.properties");
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyStrokeSettings.class);
    private static KeyStrokeSettings INSTANCE = null;
    private static Properties DEFAULT_KEYSTROKES = new Properties();

    private KeyStrokeSettings(Properties init) {
        this.properties.putAll((Map<?, ?>)DEFAULT_KEYSTROKES);
        init.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (value != null && !value.toString().isEmpty()) {
                this.properties.put(key, value);
            }
        }));
        this.save();
        Runtime.getRuntime().addShutdownHook(new Thread(this::save));
    }

    public static <T> void defineDefault(T any, KeyStroke ks) {
        KeyStrokeSettings.defineDefault(any.getClass(), ks);
    }

    public static <T> void defineDefault(Class<T> clazz, KeyStroke ks) {
        DEFAULT_KEYSTROKES.setProperty(clazz.getName(), ks.toString());
    }

    static KeyStrokeSettings loadFromConfig() {
        return new KeyStrokeSettings(SettingsManager.loadProperties(SETTINGS_FILE));
    }

    public static KeyStrokeSettings getInstance() {
        if (INSTANCE == null) {
            INSTANCE = KeyStrokeSettings.loadFromConfig();
        }
        return INSTANCE;
    }

    public void readSettings(Properties props) {
        this.properties.putAll((Map<?, ?>)props);
    }

    void setKeyStroke(String key, KeyStroke stroke, boolean override) {
        boolean exists = this.properties.contains(key);
        if (override || !exists) {
            this.properties.setProperty(key, stroke != null ? stroke.toString() : "");
            this.fireSettingsChange();
        }
    }

    KeyStroke getKeyStroke(String key, KeyStroke defaultValue) {
        try {
            KeyStroke ks = KeyStroke.getKeyStroke(this.properties.getProperty(key));
            if (ks != null) {
                return ks;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public void save() {
        LOGGER.info("Save keyboard shortcuts to: " + SETTINGS_FILE.getAbsolutePath());
        SETTINGS_FILE.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(SETTINGS_FILE);){
            this.properties.store(writer, "KeY's KeyStrokes");
            ((Writer)writer).flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    static {
        if (KeyStrokeManager.FKEY_MACRO_SCHEME) {
            KeyStrokeSettings.defineDefault(FullAutoPilotProofMacro.class, KeyStroke.getKeyStroke(112, 0));
            KeyStrokeSettings.defineDefault(AutoPilotPrepareProofMacro.class, KeyStroke.getKeyStroke(113, 0));
            KeyStrokeSettings.defineDefault(PropositionalExpansionMacro.class, KeyStroke.getKeyStroke(114, 0));
            KeyStrokeSettings.defineDefault(FullPropositionalExpansionMacro.class, KeyStroke.getKeyStroke(115, 0));
            KeyStrokeSettings.defineDefault(TryCloseMacro.class, KeyStroke.getKeyStroke(116, 0));
            KeyStrokeSettings.defineDefault(FinishSymbolicExecutionMacro.class, KeyStroke.getKeyStroke(117, 0));
            KeyStrokeSettings.defineDefault(OneStepProofMacro.class, KeyStroke.getKeyStroke(118, 0));
            KeyStrokeSettings.defineDefault(HeapSimplificationMacro.class, KeyStroke.getKeyStroke(120, 0));
            KeyStrokeSettings.defineDefault(UpdateSimplificationMacro.class, KeyStroke.getKeyStroke(121, 0));
            KeyStrokeSettings.defineDefault(IntegerSimplificationMacro.class, KeyStroke.getKeyStroke(122, 0));
            KeyStrokeSettings.defineDefault(QuickSaveAction.class, KeyStroke.getKeyStroke(83, KeyStrokeManager.MULTI_KEY_MASK));
            KeyStrokeSettings.defineDefault(QuickLoadAction.class, KeyStroke.getKeyStroke(79, KeyStrokeManager.MULTI_KEY_MASK));
        } else {
            KeyStrokeSettings.defineDefault(FullAutoPilotProofMacro.class, KeyStroke.getKeyStroke(86, KeyStrokeManager.MULTI_KEY_MASK));
            KeyStrokeSettings.defineDefault(AutoPilotPrepareProofMacro.class, KeyStroke.getKeyStroke(68, KeyStrokeManager.MULTI_KEY_MASK));
            KeyStrokeSettings.defineDefault(PropositionalExpansionMacro.class, KeyStroke.getKeyStroke(65, KeyStrokeManager.MULTI_KEY_MASK));
            KeyStrokeSettings.defineDefault(FullPropositionalExpansionMacro.class, KeyStroke.getKeyStroke(83, KeyStrokeManager.MULTI_KEY_MASK));
            KeyStrokeSettings.defineDefault(TryCloseMacro.class, KeyStroke.getKeyStroke(67, KeyStrokeManager.MULTI_KEY_MASK));
            KeyStrokeSettings.defineDefault(FinishSymbolicExecutionMacro.class, KeyStroke.getKeyStroke(88, KeyStrokeManager.MULTI_KEY_MASK));
            KeyStrokeSettings.defineDefault(OneStepProofMacro.class, KeyStroke.getKeyStroke(32, KeyStrokeManager.MULTI_KEY_MASK));
            KeyStrokeSettings.defineDefault(HeapSimplificationMacro.class, KeyStroke.getKeyStroke(72, KeyStrokeManager.MULTI_KEY_MASK));
            KeyStrokeSettings.defineDefault(UpdateSimplificationMacro.class, KeyStroke.getKeyStroke(76, KeyStrokeManager.MULTI_KEY_MASK));
            KeyStrokeSettings.defineDefault(IntegerSimplificationMacro.class, KeyStroke.getKeyStroke(73, KeyStrokeManager.MULTI_KEY_MASK));
            KeyStrokeSettings.defineDefault(SMTPreparationMacro.class, KeyStroke.getKeyStroke(89, KeyStrokeManager.MULTI_KEY_MASK));
            KeyStrokeSettings.defineDefault(KeYProjectHomepageAction.class, KeyStroke.getKeyStroke(112, 0));
            KeyStrokeSettings.defineDefault(QuickSaveAction.class, KeyStroke.getKeyStroke(116, 0));
            KeyStrokeSettings.defineDefault(QuickLoadAction.class, KeyStroke.getKeyStroke(117, 0));
        }
        KeyStrokeSettings.defineDefault(HelpFacade.ACTION_OPEN_HELP.getClass(), KeyStroke.getKeyStroke("F1"));
        KeyStrokeSettings.defineDefault(OpenExampleAction.class, KeyStroke.getKeyStroke(69, KeyStrokeManager.MULTI_KEY_MASK));
        KeyStrokeSettings.defineDefault(EditMostRecentFileAction.class, KeyStroke.getKeyStroke(69, KeyStrokeManager.MULTI_KEY_MASK));
        KeyStrokeSettings.defineDefault(PrettyPrintToggleAction.class, KeyStroke.getKeyStroke(80, KeyStrokeManager.MULTI_KEY_MASK));
        KeyStrokeSettings.defineDefault(UnicodeToggleAction.class, KeyStroke.getKeyStroke(85, KeyStrokeManager.MULTI_KEY_MASK));
        KeyStrokeSettings.defineDefault(IncreaseFontSizeAction.class, KeyStroke.getKeyStroke(521, KeyStrokeManager.MULTI_KEY_MASK));
        KeyStrokeSettings.defineDefault(DecreaseFontSizeAction.class, KeyStroke.getKeyStroke(45, KeyStrokeManager.MULTI_KEY_MASK));
        KeyStrokeSettings.defineDefault(PruneProofAction.class, KeyStroke.getKeyStroke(127, 0));
        KeyStrokeSettings.defineDefault(GoalBackAction.class, KeyStroke.getKeyStroke(90, KeyStrokeManager.SHORTCUT_KEY_MASK));
    }
}

