/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.keyshortcuts;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.keyshortcuts.KeyStrokeManager;
import de.uka.ilkd.key.gui.keyshortcuts.KeyStrokeSettings;
import de.uka.ilkd.key.gui.settings.SettingsProvider;
import de.uka.ilkd.key.gui.settings.SimpleSettingsPanel;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;

public class ShortcutSettings
extends SimpleSettingsPanel
implements SettingsProvider {
    private static final long serialVersionUID = -7609149706562761596L;
    private final JTable tblShortcuts = new JTable();
    private ShortcutsTableModel modelShortcuts;

    public ShortcutSettings() {
        this.setHeaderText("Keyboard Shortcuts");
        this.setSubHeaderText("These settings are stored in " + KeyStrokeSettings.SETTINGS_FILE.getAbsolutePath());
        this.add(new JScrollPane(this.tblShortcuts));
    }

    @Override
    public String getDescription() {
        return "Keyboard Shortcuts";
    }

    @Override
    public JComponent getPanel(MainWindow window) {
        KeyStrokeSettings settings = KeyStrokeManager.getSettings();
        Properties p = new Properties();
        settings.writeSettings(p);
        List<String> actionNames = p.keySet().stream().sorted().map(Object::toString).collect(Collectors.toList());
        List<String> shortcuts = actionNames.stream().map(p::getProperty).collect(Collectors.toList());
        List<Action> actions = actionNames.stream().map(KeyStrokeManager::findAction).collect(Collectors.toList());
        this.modelShortcuts = new ShortcutsTableModel(actionNames, shortcuts, actions);
        this.tblShortcuts.setModel(this.modelShortcuts);
        TableRowSorter<ShortcutsTableModel> sorter = new TableRowSorter<ShortcutsTableModel>(this.modelShortcuts);
        this.tblShortcuts.setRowSorter(sorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>(25);
        sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
        sorter.setSortKeys(sortKeys);
        final JTextField txtCaptureShortcut = new JTextField();
        final DefaultCellEditor cellEditor = new DefaultCellEditor(txtCaptureShortcut);
        txtCaptureShortcut.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                boolean shortcutComplete;
                if (e.getKeyCode() == 0) {
                    e.consume();
                    return;
                }
                KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
                txtCaptureShortcut.setText(ks.toString());
                boolean bl = shortcutComplete = ks.getModifiers() > 0 && ks.getKeyCode() != 0 && ks.getKeyCode() != 17 && ks.getKeyCode() != 16 && ks.getKeyCode() != 18;
                if (shortcutComplete) {
                    cellEditor.stopCellEditing();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.tblShortcuts.getColumnModel().getColumn(2).setCellEditor(cellEditor);
        return this;
    }

    @Override
    public void applySettings(MainWindow window) {
        List<String> s = this.modelShortcuts.shortcut;
        List keystrokes = s.stream().map(KeyStroke::getKeyStroke).collect(Collectors.toList());
        for (int i = 0; i < this.modelShortcuts.shortcut.size(); ++i) {
            String key = this.modelShortcuts.actionName.get(i);
            KeyStroke ks = (KeyStroke)keystrokes.get(i);
            KeyStrokeManager.getSettings().setKeyStroke(key, ks, true);
            Action action = this.modelShortcuts.actions.get(i);
            if (action == null) continue;
            action.putValue("AcceleratorKey", ks);
        }
    }

    private static class ShortcutsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -2854179933936417703L;
        private static final String[] COLUMNS = new String[]{"Name", "Description", "Shortcut"};
        private final List<String> actionName;
        private final List<String> shortcut;
        private final List<Action> actions;

        private ShortcutsTableModel(List<String> actionName, List<String> shortcut, List<Action> actions) {
            this.actionName = actionName;
            this.shortcut = shortcut;
            this.actions = actions;
        }

        @Override
        public int getRowCount() {
            return this.actionName.size();
        }

        @Override
        public int getColumnCount() {
            return COLUMNS.length;
        }

        @Override
        public String getColumnName(int column) {
            return COLUMNS[column];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.actionName.get(rowIndex).replaceAll("([a-z]\\w*\\.)*", "");
                }
                case 1: {
                    Action a = this.actions.get(rowIndex);
                    if (a == null) {
                        return "";
                    }
                    Object val = a.getValue("ShortDescription");
                    return val != null ? val.toString() : "";
                }
                case 2: {
                    return this.shortcut.get(rowIndex);
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 2) {
                this.shortcut.set(rowIndex, aValue.toString());
            } else {
                super.setValueAt(aValue, rowIndex, columnIndex);
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2;
        }
    }
}

