/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.lemmatagenerator;

import de.uka.ilkd.key.gui.lemmatagenerator.ItemModel;
import de.uka.ilkd.key.gui.lemmatagenerator.SelectionPanel;
import de.uka.ilkd.key.gui.lemmatagenerator.TableItem;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

class ItemChooser<T>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private SelectionPanel<T> suppliedList;
    private SelectionPanel<T> selectedList;
    private JPanel middlePanel;
    private JPanel contentPanel;
    private JButton leftButton;
    private JButton rightButton;
    private List<TableItem<T>> items = new LinkedList<TableItem<T>>();
    private final List<ItemFilter<T>> filtersForMovingItems = new LinkedList<ItemFilter<T>>();
    private final String searchTitle;
    private final List<ItemFilter<T>> userFilter = new LinkedList<ItemFilter<T>>();
    private static final Dimension MAX = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);

    ItemChooser(String searchTitle) {
        this.searchTitle = searchTitle;
        this.setMaximumSize(MAX);
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalStrut(10));
        this.add(this.getContentPanel());
        this.add(Box.createVerticalStrut(10));
    }

    public ItemChooser() {
        this("Search for items containing...");
    }

    private JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 0));
            this.contentPanel.add(this.getSuppliedList());
            this.contentPanel.add(Box.createHorizontalStrut(5));
            this.contentPanel.add(this.getMiddlePanel());
            this.contentPanel.add(Box.createHorizontalStrut(5));
            this.contentPanel.add(this.getSelectedList());
            this.contentPanel.add(Box.createHorizontalGlue());
        }
        return this.contentPanel;
    }

    private JPanel getMiddlePanel() {
        if (this.middlePanel == null) {
            this.middlePanel = new JPanel();
            this.middlePanel.setLayout(new BoxLayout(this.middlePanel, 1));
            this.middlePanel.add(this.getLeftButton());
            this.middlePanel.add(Box.createVerticalStrut(10));
            this.middlePanel.add(this.getRightButton());
            Dimension dim = this.getLeftButton().getPreferredSize();
            dim.height = dim.height + 10 + this.getRightButton().getPreferredSize().height;
            this.middlePanel.setMaximumSize(dim);
        }
        return this.middlePanel;
    }

    private JButton getLeftButton() {
        if (this.leftButton == null) {
            this.leftButton = new JButton("<");
            this.leftButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ItemChooser.this.cut(ItemChooser.this.getSelectedList(), ItemChooser.this.getSuppliedList());
                }
            });
        }
        return this.leftButton;
    }

    private JButton getRightButton() {
        if (this.rightButton == null) {
            this.rightButton = new JButton(">");
            this.rightButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ItemChooser.this.cut(ItemChooser.this.getSuppliedList(), ItemChooser.this.getSelectedList());
                }
            });
        }
        return this.rightButton;
    }

    private void cut(SelectionPanel<T> srcList, SelectionPanel<T> destList) {
        List<TableItem<T>> tableItems = srcList.getSelectedItems();
        for (TableItem<T> item : tableItems) {
            boolean move = true;
            for (ItemFilter<T> filter : this.filtersForMovingItems) {
                if (filter.include(item.getData())) continue;
                move = false;
            }
            if (!move) continue;
            item.setSide(destList.getSide());
        }
        srcList.update();
        destList.update();
    }

    private SelectionPanel<T> getSuppliedList() {
        if (this.suppliedList == null) {
            this.suppliedList = new SelectionPanel<T>("Choice", this.searchTitle, SelectionPanel.Side.LEFT, this.userFilter);
        }
        return this.suppliedList;
    }

    private SelectionPanel<T> getSelectedList() {
        if (this.selectedList == null) {
            this.selectedList = new SelectionPanel<T>("Selection", this.searchTitle, SelectionPanel.Side.RIGHT, this.userFilter);
        }
        return this.selectedList;
    }

    public void setItems(List<T> dataForItems, String columnName) {
        this.items = new LinkedList<TableItem<T>>();
        for (T info : dataForItems) {
            this.items.add(new TableItem<T>(info, SelectionPanel.Side.LEFT));
        }
        ItemModel model = new ItemModel(columnName);
        for (TableItem<T> item : this.items) {
            model.addRow(new Object[]{item});
        }
        this.getSuppliedList().setModel(model);
        this.getSelectedList().setModel(model);
        this.getSuppliedList().selectAll();
    }

    public List<T> getDataOfSelectedItems() {
        LinkedList<T> list = new LinkedList<T>();
        for (TableItem<T> item : this.items) {
            if (item.getSide() != SelectionPanel.Side.RIGHT) continue;
            list.add(item.getData());
        }
        return list;
    }

    public void moveAllToLeft() {
        for (TableItem<T> item : this.items) {
            item.setSide(SelectionPanel.Side.LEFT);
        }
        this.update();
    }

    public void moveAllToRight() {
        for (TableItem<T> item : this.items) {
            item.setSide(SelectionPanel.Side.RIGHT);
        }
        this.update();
    }

    public void removeSelection() {
        this.getSelectedList().removeSelection();
        this.getSuppliedList().removeSelection();
    }

    public void addFilter(ItemFilter<T> filter) {
        this.userFilter.add(filter);
        this.update();
    }

    public void removeFilter(ItemFilter<T> filter) {
        this.userFilter.remove(filter);
        this.update();
    }

    public void addFilterForMovingItems(ItemFilter<T> filter) {
        this.filtersForMovingItems.add(filter);
    }

    public void removeFilterForMovingItems(ItemFilter<T> filter) {
        this.filtersForMovingItems.remove(filter);
    }

    public void update() {
        this.getSelectedList().update();
        this.getSuppliedList().update();
    }

    public static interface ItemFilter<T> {
        public boolean include(T var1);
    }
}

