/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.lemmatagenerator;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.lemmatagenerator.ItemChooser;
import de.uka.ilkd.key.gui.utilities.GuiUtilities;
import de.uka.ilkd.key.rule.Taclet;
import de.uka.ilkd.key.taclettranslation.lemma.TacletSoundnessPOLoader;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.key_project.util.collection.DefaultImmutableSet;
import org.key_project.util.collection.ImmutableSet;

public class LemmaSelectionDialog
extends JDialog
implements TacletSoundnessPOLoader.TacletFilter {
    private static final long serialVersionUID = 1L;
    private JButton okButton;
    private JCheckBox showSupported;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JPanel contentPanel;
    private ItemChooser<TacletSoundnessPOLoader.TacletInfo> tacletChooser;
    private ItemChooser.ItemFilter<TacletSoundnessPOLoader.TacletInfo> showOnlySupportedTaclets = new ItemChooser.ItemFilter<TacletSoundnessPOLoader.TacletInfo>(){

        @Override
        public boolean include(TacletSoundnessPOLoader.TacletInfo itemData) {
            return !itemData.isNotSupported();
        }
    };
    private ItemChooser.ItemFilter<TacletSoundnessPOLoader.TacletInfo> filterForMovingTaclets = new ItemChooser.ItemFilter<TacletSoundnessPOLoader.TacletInfo>(){

        @Override
        public boolean include(TacletSoundnessPOLoader.TacletInfo itemData) {
            return !itemData.isNotSupported() && !itemData.isAlreadyInUse();
        }
    };

    public LemmaSelectionDialog() {
        super(MainWindow.getInstance());
        this.setTitle("Taclet Selection");
        this.setLayout(new BoxLayout(this.getContentPane(), 0));
        this.getContentPane().add(Box.createHorizontalStrut(10));
        this.getContentPane().add(this.getContentPanel());
        this.getContentPane().add(Box.createHorizontalStrut(10));
        this.setMinimumSize(new Dimension(300, 300));
        this.setLocationByPlatform(true);
        this.pack();
    }

    public ImmutableSet<Taclet> showModal(List<TacletSoundnessPOLoader.TacletInfo> taclets) {
        this.setModal(true);
        this.getTacletChooser().setItems(taclets, "Taclets");
        this.setVisible(true);
        DefaultImmutableSet set = DefaultImmutableSet.nil();
        for (TacletSoundnessPOLoader.TacletInfo info : this.getTacletChooser().getDataOfSelectedItems()) {
            set = set.add((Object)info.getTaclet());
        }
        return set;
    }

    private JCheckBox getShowSupported() {
        if (this.showSupported == null) {
            this.showSupported = new JCheckBox("Show only supported taclets.");
            this.showSupported.setSelected(true);
            this.showSupported.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (LemmaSelectionDialog.this.showSupported.isSelected()) {
                        LemmaSelectionDialog.this.getTacletChooser().addFilter(LemmaSelectionDialog.this.showOnlySupportedTaclets);
                    } else {
                        LemmaSelectionDialog.this.getTacletChooser().removeFilter(LemmaSelectionDialog.this.showOnlySupportedTaclets);
                    }
                }
            });
        }
        return this.showSupported;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
            this.buttonPanel.add(this.getShowSupported());
            this.buttonPanel.add(Box.createHorizontalGlue());
            this.buttonPanel.add(this.getOkButton());
            this.buttonPanel.add(Box.createHorizontalStrut(8));
            this.buttonPanel.add(this.getCancelButton());
        }
        return this.buttonPanel;
    }

    private JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel();
            this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
            this.contentPanel.add(Box.createVerticalStrut(10));
            this.contentPanel.add(this.getTacletChooser());
            this.contentPanel.add(this.getButtonPanel());
            this.contentPanel.add(Box.createVerticalStrut(10));
        }
        return this.contentPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(e -> this.tacletsSelected());
            this.okButton.setPreferredSize(this.getCancelButton().getPreferredSize());
        }
        return this.okButton;
    }

    private void tacletsSelected() {
        this.dispose();
    }

    private void cancel() {
        this.getTacletChooser().removeSelection();
        this.getTacletChooser().moveAllToLeft();
        this.dispose();
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LemmaSelectionDialog.this.cancel();
                }
            });
            GuiUtilities.attachClickOnEscListener(this.cancelButton);
        }
        return this.cancelButton;
    }

    private ItemChooser<TacletSoundnessPOLoader.TacletInfo> getTacletChooser() {
        if (this.tacletChooser == null) {
            this.tacletChooser = new ItemChooser("Search for taclets with names containing");
            this.tacletChooser.addFilterForMovingItems(this.filterForMovingTaclets);
            this.tacletChooser.addFilter(this.showOnlySupportedTaclets);
        }
        return this.tacletChooser;
    }

    public ImmutableSet<Taclet> filter(List<TacletSoundnessPOLoader.TacletInfo> taclets) {
        return this.showModal(taclets);
    }
}

