/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.lemmatagenerator;

import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.util.CommandLine;
import de.uka.ilkd.key.util.CommandLineException;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LemmataAutoModeOptions {
    public static final int DEFAULT_TIMEOUT = -1;
    public static final int DEFAULT_MAXRULES = 10000;
    private static final String PROOF_POSTFIX = ".key.proof";
    private static final Logger LOGGER = LoggerFactory.getLogger(LemmataAutoModeOptions.class);
    private String pathOfRuleFile;
    private final Collection<String> filesForAxioms = new LinkedList<String>();
    private long timeout = -1L;
    private int maxRules = 10000;
    private String pathOfResult = "";
    private String pathOfDefinitionFile = "";
    private final String internalVersion;
    private boolean saveResultsToFile = false;
    private String homePath;

    public LemmataAutoModeOptions(CommandLine cl, String internalVersion) {
        try {
            if (cl.isSet("--justify-rules")) {
                this.pathOfRuleFile = cl.getString("--justify-rules", null);
            }
            if (cl.isSet("--jr-timeout")) {
                this.timeout = cl.getLong("--jr-timeout", -1L);
                LOGGER.info("We are in cons 1 and timeout is " + this.timeout);
            }
            if (cl.isSet("--jr-maxRules")) {
                this.maxRules = cl.getInteger("--jr-maxRules", 10000);
            }
            if (cl.isSet("--jr-pathOfResult") && cl.isSet("--justify-rules")) {
                this.pathOfResult = this.generatePath(cl.getString("--jr-pathOfResult", null), this.pathOfRuleFile);
            }
        }
        catch (CommandLineException cle) {
            LOGGER.info("There was a problem reading the command line options. An argument is missing either for option --jr-timeout or --jr-maxRules.");
        }
        this.internalVersion = internalVersion;
        this.checkForValidity();
    }

    public LemmataAutoModeOptions(CommandLine cl, String internalVersion, String homePath) {
        this.internalVersion = internalVersion;
        if (cl.isSet("--justify-rules")) {
            this.pathOfRuleFile = cl.getString("--justify-rules", null);
        }
        LOGGER.info("We are in cons 2");
        this.read(cl);
        this.pathOfResult = this.generatePath(this.pathOfResult, this.pathOfRuleFile);
        this.homePath = homePath;
        this.checkForValidity();
    }

    private void read(CommandLine cl) {
        if (cl.isSet("--jr-maxRules")) {
            try {
                cl.getInteger("--jr-maxRules", 10000);
            }
            catch (CommandLineException e) {
                LOGGER.info("Commandline argument for option --jr-maxRulesis missing.");
            }
        }
        if (cl.isSet("--jr-pathOfResult")) {
            this.pathOfResult = cl.getString("--jr-pathOfResult", null);
        }
        if (cl.isSet("--justify-rules")) {
            this.pathOfRuleFile = cl.getString("--justify-rules", null);
        }
        if (cl.isSet("--jr-timeout")) {
            try {
                this.timeout = cl.getLong("--jr-timeout", -1L);
                LOGGER.trace("Timeout2 is :" + this.timeout);
            }
            catch (CommandLineException e) {
                LOGGER.warn("Commandline argument for --jr-timeout is missing.");
            }
        }
        if (cl.isSet("--jr-saveProofToFile")) {
            this.saveResultsToFile = this.readBoolean(cl.getString("--jr-saveProofToFile", "false"), this.saveResultsToFile);
        }
        if (cl.isSet("--jr-axioms")) {
            this.filesForAxioms.add(cl.getString("--jr-axioms", null));
        }
        if (cl.isSet("--jr-signature")) {
            this.pathOfDefinitionFile = cl.getString("--jr-signature", null);
        }
    }

    private boolean readBoolean(String value, boolean def) {
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        return def;
    }

    public String getPathOfDefinitionFile() {
        return this.pathOfDefinitionFile;
    }

    public String getHomePath() {
        return this.homePath;
    }

    public boolean isSavingResultsToFile() {
        return this.saveResultsToFile;
    }

    public String getPathOfRuleFile() {
        return this.pathOfRuleFile;
    }

    public int getMaxNumberOfRules() {
        return this.maxRules;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public String getInternalVersion() {
        return this.internalVersion;
    }

    public String createProofPath(Proof p) {
        return this.pathOfResult + File.separator + p.name() + PROOF_POSTFIX;
    }

    private void checkForValidity() {
        File test = new File(this.pathOfRuleFile);
        if (!test.isFile()) {
            this.throwError(String.format("Error while setting the file containing the rules:\n'%s' is not a valid file in your system.", this.pathOfRuleFile));
        }
        if (!(test = new File(this.pathOfResult)).isDirectory()) {
            this.throwError(String.format("Error while setting the folder of the results:\n'%s' is not a folder.", this.pathOfResult));
        }
    }

    private void throwError(String error) {
        throw new IllegalArgumentException(error);
    }

    private String generatePath(String path, String reference) {
        if (path.equals("")) {
            File temp = new File(reference);
            int index = temp.getAbsolutePath().lastIndexOf(File.separator);
            path = temp.getAbsolutePath().substring(0, index + 1);
        }
        return path;
    }

    public String toString() {
        return String.format("path of rule file: %s\npath of result: %s\nmaximum number of rules: %s\ntimeout: %s\nsave proof to file: %s", this.pathOfRuleFile, this.pathOfResult, this.maxRules, this.timeout, this.saveResultsToFile);
    }

    public Collection<String> getFilesForAxioms() {
        return this.filesForAxioms;
    }
}

