/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.lemmatagenerator;

import de.uka.ilkd.key.gui.lemmatagenerator.LemmataAutoModeOptions;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofAggregate;
import de.uka.ilkd.key.proof.init.ProblemInitializer;
import de.uka.ilkd.key.proof.init.Profile;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.proof.init.ProofOblInput;
import de.uka.ilkd.key.proof.io.ProofSaver;
import de.uka.ilkd.key.rule.Taclet;
import de.uka.ilkd.key.taclettranslation.lemma.AutomaticProver;
import de.uka.ilkd.key.taclettranslation.lemma.TacletLoader;
import de.uka.ilkd.key.taclettranslation.lemma.TacletSoundnessPOLoader;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.key_project.util.collection.DefaultImmutableSet;
import org.key_project.util.collection.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LemmataHandler
implements TacletSoundnessPOLoader.TacletFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LemmataHandler.class);
    private final LemmataAutoModeOptions options;
    private final Profile profile;

    public LemmataHandler(LemmataAutoModeOptions options, Profile profile) {
        this.options = options;
        this.profile = profile;
    }

    public void println(String s) {
        LOGGER.info(s);
    }

    public void print(String s) {
        LOGGER.info(s);
    }

    public void printException(Throwable t) {
        LOGGER.error("", t);
    }

    public void start() throws IOException, ProofInputException {
        this.println("Start problem creation:");
        this.println(this.options.toString());
        File file = new File(this.options.getPathOfRuleFile());
        Collection<File> filesForAxioms = this.createFilesForAxioms(this.options.getFilesForAxioms());
        ProblemInitializer problemInitializer = new ProblemInitializer(null, new Services(this.profile), (ProblemInitializer.ProblemInitializerListener)new Listener());
        TacletLoader.TacletFromFileLoader tacletLoader = new TacletLoader.TacletFromFileLoader(null, (ProblemInitializer.ProblemInitializerListener)new Listener(), problemInitializer, this.profile, file, filesForAxioms);
        TacletSoundnessPOLoader.LoaderListener loaderListener = new TacletSoundnessPOLoader.LoaderListener(){

            public void stopped(Throwable exception) {
                LemmataHandler.this.handleException(exception);
            }

            public void stopped(ProofAggregate pa, ImmutableSet<Taclet> taclets, boolean addAsAxioms) {
                if (pa == null) {
                    LemmataHandler.this.println("There is no taclet to be proven.");
                    return;
                }
                LemmataHandler.this.println("Proofs have been created for");
                for (Proof p : pa.getProofs()) {
                    LOGGER.info(p.name().toString());
                }
                LemmataHandler.this.startProofs(pa);
            }

            public void started() {
                LemmataHandler.this.println("Start loading the problem");
            }

            public void progressStarted(Object sender) {
            }

            public void reportStatus(Object sender, String string) {
            }

            public void resetStatus(Object sender) {
            }
        };
        TacletSoundnessPOLoader loader = new TacletSoundnessPOLoader(loaderListener, (TacletSoundnessPOLoader.TacletFilter)this, true, (TacletLoader)tacletLoader, tacletLoader.getProofEnvForTaclets().getInitConfigForEnvironment(), true);
        loader.start();
    }

    private Collection<File> createFilesForAxioms(Collection<String> filenames) {
        LinkedList<File> list = new LinkedList<File>();
        for (String filename : filenames) {
            list.add(new File(filename));
        }
        return list;
    }

    private void handleException(Throwable exception) {
        this.printException(exception);
    }

    private void startProofs(ProofAggregate pa) {
        this.println("Start the proving:");
        for (Proof p : pa.getProofs()) {
            try {
                this.startProof(p);
                if (!this.options.isSavingResultsToFile()) continue;
                this.saveProof(p);
            }
            catch (Throwable e) {
                this.handleException(e);
            }
        }
    }

    private void saveProof(Proof p) throws IOException {
        ProofSaver saver = new ProofSaver(p, this.options.createProofPath(p), this.options.getInternalVersion());
        saver.save();
    }

    private void startProof(Proof proof) {
        this.print(proof.name() + "...");
        AutomaticProver prover = new AutomaticProver();
        try {
            prover.start(proof, this.options.getMaxNumberOfRules(), this.options.getTimeout());
            this.println((String)(proof.closed() ? "closed" : "not closed (open goals: " + proof.openGoals().size() + " nodes: " + proof.countNodes() + ")"));
        }
        catch (InterruptedException exception) {
            this.println("time out");
        }
    }

    public ImmutableSet<Taclet> filter(List<TacletSoundnessPOLoader.TacletInfo> taclets) {
        DefaultImmutableSet set = DefaultImmutableSet.nil();
        for (TacletSoundnessPOLoader.TacletInfo tacletInfo : taclets) {
            if (tacletInfo.isAlreadyInUse() || tacletInfo.isNotSupported()) continue;
            set = set.add((Object)tacletInfo.getTaclet());
        }
        return set;
    }

    private class Listener
    implements ProblemInitializer.ProblemInitializerListener {
        private Listener() {
        }

        public void proofCreated(ProblemInitializer sender, ProofAggregate proofAggregate) {
            LemmataHandler.this.println("The proofs have been initialized.");
        }

        public void progressStarted(Object sender) {
        }

        public void progressStopped(Object sender) {
        }

        public void reportStatus(Object sender, String status, int progress) {
            LemmataHandler.this.println("Status: " + status);
        }

        public void reportStatus(Object sender, String status) {
            LemmataHandler.this.println("Status: " + status);
        }

        public void resetStatus(Object sender) {
        }

        public void reportException(Object sender, ProofOblInput input, Exception e) {
            LemmataHandler.this.printException(e);
        }
    }
}

