/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.lemmatagenerator;

import de.uka.ilkd.key.gui.KeYFileChooser;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.lemmatagenerator.InfoDialog;
import de.uka.ilkd.key.gui.utilities.GuiUtilities;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class LoadUserTacletsDialog
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String HELP_TEXT = "In this dialog you can choose the files that are used for loading user-defined taclets:\n\nUser-Defined Taclets:\nThis file contains the taclets that should be loaded, so that they can be used for the current proof. For each taclet an extra proof obligation is built that must be provable, in order to sustain the correctness of the calculus.\n\nDefinitions:\nThis file contains the signature (function symbols, predicate symbols, sorts) that are used for creating the proof obligations mentioned above. In most cases it should be the same file as indicated in 'User-Defined Taclets'.\n\nAxioms:\nIn order to prove the correctness of the created lemmata, for some user-defined taclets the introduction of additional axioms is necessary. At this point you can add them.\nBeware of the fact that it is crucial for the correctness of the calculus that the used axioms are consistent.It is the responsibility of the user to guarantee this consistency.\n\nTechnical Remarks:\nThe axioms must be stored in another file than the user-defined taclets. Furthermore the axioms are only loaded for the lemmata, but not for the current proof.";
    private static final String INFO_TEXT = "Be aware of the fact that you are going to load taclets\nwithout creating corresponding proof obligations!\nIn case that the taclets that you want to load are unsound,\nthe calculus will become unsound!";
    private static final Dimension MAX_DIM = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    private JList<File> axiomsList;
    private JButton addAxiomFileButton;
    private JButton removeAxiomFileButton;
    private JButton helpButton;
    private UserTacletFileBox userTacletFileBox;
    private JPanel axiomFilePanel;
    private JPanel buttonPanel;
    private JScrollPane scrollPane;
    private JDialog helpWindow;
    private JButton okButton;
    private JButton cancelButton;
    private JCheckBox lemmaCheckbox;
    private boolean closedByOkButton = false;
    private final DefaultListModel<File> listModel = new DefaultListModel();
    private boolean firstTimeAddingAxioms = true;
    private final Mode mode;
    private JDialog dialog;
    private JPanel justificationPanel;
    private JPanel cardPanel;

    public LoadUserTacletsDialog(Mode mode) {
        this.mode = mode;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(Box.createVerticalStrut(15));
        this.add(this.getUserTacletFileBox());
        this.add(Box.createVerticalStrut(10));
        if (mode == Mode.LOAD) {
            this.add(this.getJustificationBox());
        } else if (mode == Mode.PROVE) {
            this.add(this.getAxiomFilePanel());
        }
        this.add(Box.createVerticalGlue());
        this.add(Box.createVerticalStrut(5));
    }

    public List<File> getFilesForAxioms() {
        LinkedList<File> files = new LinkedList<File>();
        Object[] objects = this.listModel.toArray();
        if (objects != null) {
            for (Object file : objects) {
                files.add((File)file);
            }
        }
        return files;
    }

    public File getFileForTaclets() {
        return this.userTacletFileBox.getChosenFile();
    }

    private JCheckBox getLemmaCheckBox() {
        if (this.lemmaCheckbox == null) {
            this.lemmaCheckbox = new JCheckBox("Generate proof obligations for taclets");
            this.lemmaCheckbox.setSelected(true);
            this.lemmaCheckbox.addActionListener(e -> {
                InfoDialog infoDialog = new InfoDialog();
                if (!this.lemmaCheckbox.isSelected()) {
                    this.lemmaCheckbox.setSelected(true);
                    boolean showDialogUsingAxioms = ProofIndependentSettings.DEFAULT_INSTANCE.getLemmaGeneratorSettings().isShowingDialogUsingAxioms();
                    if (!showDialogUsingAxioms || infoDialog.showDialog(INFO_TEXT, this)) {
                        this.changedToNotSelected();
                        this.lemmaCheckbox.setSelected(false);
                        ProofIndependentSettings.DEFAULT_INSTANCE.getLemmaGeneratorSettings().showDialogUsingAxioms(showDialogUsingAxioms && infoDialog.showThisDialogNextTime());
                    }
                } else {
                    this.changedToSelected();
                }
            });
        }
        return this.lemmaCheckbox;
    }

    private void enableAxiomFilePanel(boolean val) {
        this.getAddAxiomFileButton().setEnabled(val);
        this.getRemoveAxiomFileButton().setEnabled(val);
        this.getAxiomsList().setEnabled(val);
        CardLayout cl = (CardLayout)this.getCardPanel().getLayout();
        cl.show(this.getCardPanel(), Boolean.toString(val));
    }

    private void changedToSelected() {
        this.enableAxiomFilePanel(true);
    }

    private void changedToNotSelected() {
        this.enableAxiomFilePanel(false);
    }

    private JList<File> getAxiomsList() {
        if (this.axiomsList == null) {
            this.axiomsList = new JList();
            this.axiomsList.setModel(this.listModel);
            this.axiomsList.setBorder(BorderFactory.createEtchedBorder());
        }
        return this.axiomsList;
    }

    private JButton getHelpButton() {
        if (this.helpButton == null) {
            this.helpButton = new JButton("Help");
            this.helpButton.setPreferredSize(this.getCancelButton().getPreferredSize());
            this.helpButton.addActionListener(e -> this.getHelpWindow().setVisible(true));
        }
        return this.helpButton;
    }

    private JDialog getHelpWindow() {
        if (this.helpWindow == null) {
            this.helpWindow = this.dialog != null ? new JDialog(this.dialog) : new JDialog();
            JTextArea textArea = new JTextArea(HELP_TEXT);
            textArea.setWrapStyleWord(true);
            textArea.setLineWrap(true);
            textArea.setEditable(false);
            this.helpWindow.getContentPane().add(new JScrollPane(textArea));
            this.helpWindow.setMinimumSize(new Dimension(400, 200));
            this.helpWindow.setLocationByPlatform(true);
            this.helpWindow.setTitle("Help");
            this.helpWindow.pack();
        }
        return this.helpWindow;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.getAxiomsList(), 22, 30);
            this.scrollPane.setMaximumSize(MAX_DIM);
        }
        return this.scrollPane;
    }

    private File chooseFiles(String title) {
        KeYFileChooser fileChooser = KeYFileChooser.getFileChooser(title);
        fileChooser.setFileFilter(KeYFileChooser.KEY_FILTER);
        if (fileChooser.showOpenDialog(this) == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    private UserTacletFileBox getUserTacletFileBox() {
        if (this.userTacletFileBox == null) {
            this.userTacletFileBox = new UserTacletFileBox("File with user-defined taclets");
        }
        return this.userTacletFileBox;
    }

    private JButton getAddAxiomFileButton() {
        if (this.addAxiomFileButton == null) {
            this.addAxiomFileButton = new JButton("Add...");
            this.setMaximumWidth(this.addAxiomFileButton, this.getRemoveAxiomFileButton().getPreferredSize().width);
            this.addAxiomFileButton.addActionListener(e -> {
                File file;
                if (this.firstTimeAddingAxioms && ProofIndependentSettings.DEFAULT_INSTANCE.getLemmaGeneratorSettings().isShowingDialogAddingAxioms()) {
                    InfoDialog infoDialog = new InfoDialog();
                    this.firstTimeAddingAxioms = !infoDialog.showDialog(INFO_TEXT, this);
                    ProofIndependentSettings.DEFAULT_INSTANCE.getLemmaGeneratorSettings().showDialogAddingAxioms(infoDialog.showThisDialogNextTime());
                    if (this.firstTimeAddingAxioms) {
                        return;
                    }
                }
                if ((file = this.chooseFiles("File containing the axioms.")) != null) {
                    this.listModel.addElement(file);
                }
            });
        }
        return this.addAxiomFileButton;
    }

    private JButton getRemoveAxiomFileButton() {
        if (this.removeAxiomFileButton == null) {
            this.removeAxiomFileButton = new JButton("Remove");
            this.removeAxiomFileButton.addActionListener(e -> {
                List<File> values = this.getAxiomsList().getSelectedValuesList();
                for (File o : values) {
                    this.listModel.removeElement(o);
                }
            });
        }
        return this.removeAxiomFileButton;
    }

    private JPanel getAxiomFilePanel() {
        if (this.axiomFilePanel == null) {
            this.axiomFilePanel = new JPanel();
            this.axiomFilePanel.setLayout(new BoxLayout(this.axiomFilePanel, 0));
            this.axiomFilePanel.add(this.getScrollPane());
            this.axiomFilePanel.add(Box.createHorizontalStrut(5));
            this.axiomFilePanel.add(this.getButtonPanel());
            this.axiomFilePanel.setBorder(BorderFactory.createTitledBorder("Files with declarations and axioms"));
        }
        return this.axiomFilePanel;
    }

    private JPanel getJustificationBox() {
        if (this.justificationPanel == null) {
            this.justificationPanel = new JPanel();
            this.justificationPanel.setLayout(new BoxLayout(this.justificationPanel, 1));
            this.justificationPanel.setBorder(BorderFactory.createTitledBorder("Prove taclets"));
            Box box = Box.createHorizontalBox();
            box.add(this.getLemmaCheckBox());
            box.add(Box.createHorizontalGlue());
            this.justificationPanel.add(box);
            this.justificationPanel.add(Box.createVerticalStrut(10));
            this.justificationPanel.add(this.getCardPanel());
        }
        return this.justificationPanel;
    }

    private JPanel getCardPanel() {
        if (this.cardPanel == null) {
            this.cardPanel = new JPanel(new CardLayout());
            this.cardPanel.add((Component)this.getAxiomFilePanel(), "true");
            JPanel warning = new JPanel();
            warning.setLayout(new BoxLayout(warning, 1));
            warning.add(Box.createVerticalStrut(10));
            warning.add(this.redLabel("Warning!"));
            warning.add(Box.createVerticalStrut(10));
            warning.add(this.redLabel("Loading of unproved taclets may jeopardise"));
            warning.add(this.redLabel("the correctness of your own proofs."));
            this.cardPanel.add((Component)warning, "false");
        }
        return this.cardPanel;
    }

    private JLabel redLabel(String label) {
        JLabel w = new JLabel(label);
        w.setForeground(Color.red);
        return w;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
            this.buttonPanel.add(Box.createVerticalGlue());
            this.buttonPanel.add(this.getAddAxiomFileButton());
            this.buttonPanel.add(Box.createVerticalStrut(5));
            this.buttonPanel.add(this.getRemoveAxiomFileButton());
            this.buttonPanel.add(Box.createVerticalGlue());
        }
        return this.buttonPanel;
    }

    private void setMaximumHeight(JComponent comp, int value) {
        Dimension dim = comp.getMaximumSize();
        dim.height = value;
        comp.setMaximumSize(dim);
    }

    private void setMaximumWidth(JComponent comp, int value) {
        Dimension dim = comp.getMaximumSize();
        dim.width = value;
        comp.setMaximumSize(dim);
    }

    private JDialog getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(MainWindow.getInstance());
            if (this.mode == Mode.LOAD) {
                this.dialog.setTitle("Load user-defined taclets into proof");
            } else if (this.mode == Mode.PROVE) {
                this.dialog.setTitle("Prove user-defined taclets");
            }
            this.dialog.setDefaultCloseOperation(2);
            Container pane = this.dialog.getContentPane();
            pane.setLayout(new BoxLayout(pane, 1));
            pane.add(this);
            pane.add(Box.createVerticalStrut(5));
            JPanel buttonPane = new JPanel();
            buttonPane.setLayout(new BoxLayout(buttonPane, 0));
            buttonPane.add(this.getHelpButton());
            buttonPane.add(Box.createHorizontalGlue());
            buttonPane.add(this.getOkButton());
            buttonPane.add(Box.createHorizontalStrut(10));
            buttonPane.add(this.getCancelButton());
            buttonPane.add(Box.createHorizontalStrut(5));
            buttonPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            pane.add(buttonPane);
            this.dialog.setLocationByPlatform(true);
            this.dialog.pack();
        }
        return this.dialog;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton("OK");
            Dimension dim = this.getCancelButton().getPreferredSize();
            this.okButton.setEnabled(false);
            this.okButton.setPreferredSize(dim);
            this.okButton.addActionListener(e -> {
                this.getDialog().dispose();
                this.closedByOkButton = true;
            });
        }
        return this.okButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(e -> {
                this.getDialog().dispose();
                this.closedByOkButton = false;
            });
            GuiUtilities.attachClickOnEscListener(this.cancelButton);
        }
        return this.cancelButton;
    }

    public boolean showAsDialog() {
        this.getDialog().setModal(true);
        this.getDialog().setVisible(true);
        return this.closedByOkButton;
    }

    public boolean isGenerateProofObligations() {
        return this.getLemmaCheckBox().isSelected();
    }

    private class UserTacletFileBox
    extends Box {
        private static final long serialVersionUID = 1L;
        private File chosenFile;
        private JButton chooseFileButton;
        private JTextField fileField;
        private final String title;

        public UserTacletFileBox(String title) {
            super(1);
            this.title = title;
            Box box = Box.createHorizontalBox();
            if (title != null) {
                this.setBorder(BorderFactory.createTitledBorder(title));
            }
            box.add(this.getFileField());
            box.add(Box.createHorizontalStrut(5));
            box.add(this.getChooseFileButton());
            this.add(box);
        }

        private JTextField getFileField() {
            if (this.fileField == null) {
                this.fileField = new JTextField();
                LoadUserTacletsDialog.this.setMaximumHeight(this.fileField, this.getChooseFileButton().getPreferredSize().height);
                LoadUserTacletsDialog.this.setMaximumWidth(this.fileField, Integer.MAX_VALUE);
                this.fileField.setEditable(false);
            }
            return this.fileField;
        }

        private JButton getChooseFileButton() {
            if (this.chooseFileButton == null) {
                this.chooseFileButton = new JButton("Choose...");
                LoadUserTacletsDialog.this.setMaximumWidth(this.chooseFileButton, LoadUserTacletsDialog.this.getRemoveAxiomFileButton().getPreferredSize().width);
                this.chooseFileButton.addActionListener(e -> {
                    File file = LoadUserTacletsDialog.this.chooseFiles(this.title);
                    if (file != null) {
                        this.fileHasBeenChosen();
                        this.setChosenFile(file);
                    }
                });
            }
            return this.chooseFileButton;
        }

        protected void fileHasBeenChosen() {
            if (LoadUserTacletsDialog.this.okButton != null) {
                LoadUserTacletsDialog.this.okButton.setEnabled(true);
            }
        }

        public void setChosenFile(File file) {
            this.chosenFile = file;
            this.getFileField().setText(this.chosenFile.toString());
        }

        public File getChosenFile() {
            return this.chosenFile;
        }
    }

    public static enum Mode {
        PROVE,
        LOAD;

    }
}

