/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.lemmatagenerator;

import de.uka.ilkd.key.gui.lemmatagenerator.ItemChooser;
import de.uka.ilkd.key.gui.lemmatagenerator.ItemModel;
import de.uka.ilkd.key.gui.lemmatagenerator.TableItem;
import de.uka.ilkd.key.taclettranslation.lemma.TacletSoundnessPOLoader;
import java.awt.Dimension;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;

class SelectionPanel<T>
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField textField;
    private JTable list;
    private JScrollPane scrollPane;
    private final Side side;
    private RowFilter<ItemModel, Integer> filter;
    private String findPattern = "";
    private final List<ItemChooser.ItemFilter<T>> userFilters;
    private static final Dimension MAX = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.getList(), 22, 30);
            this.scrollPane.setMaximumSize(MAX);
        }
        return this.scrollPane;
    }

    public SelectionPanel(String title, String searchTitle, Side side, List<ItemChooser.ItemFilter<T>> filters) {
        this.side = side;
        this.userFilters = filters;
        this.createFilter();
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.getScrollPane());
        this.add(Box.createVerticalStrut(5));
        Box box = Box.createHorizontalBox();
        TitledBorder border = BorderFactory.createTitledBorder(searchTitle);
        border.setTitleFont(this.getTextField().getFont());
        box.setBorder(border);
        box.add(this.getTextField());
        this.add(box);
        this.setBorder(BorderFactory.createTitledBorder(title));
    }

    private JTextField getTextField() {
        if (this.textField == null) {
            this.textField = new JTextField();
            this.textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    SelectionPanel.this.search();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    SelectionPanel.this.search();
                }

                @Override
                public void changedUpdate(DocumentEvent arg0) {
                }
            });
        }
        return this.textField;
    }

    void addItems(List<TacletSoundnessPOLoader.TacletInfo> infoList) {
        for (TacletSoundnessPOLoader.TacletInfo info : infoList) {
            this.getModel().addRow(new Object[]{info});
        }
    }

    void selectAll() {
        this.getList().getSelectionModel().setSelectionInterval(0, this.getList().getRowCount() - 1);
    }

    private void search() {
        this.findPattern = this.textField.getText().toLowerCase();
        this.update();
    }

    private JTable getList() {
        if (this.list == null) {
            this.list = new JTable();
            ItemModel model = new ItemModel("");
            this.setModel(model);
        }
        return this.list;
    }

    DefaultTableModel getModel() {
        return (DefaultTableModel)this.getList().getModel();
    }

    List<T> getSelectedValues() {
        LinkedList infoList = new LinkedList();
        for (int i : this.getList().getSelectedRows()) {
            TableItem item = (TableItem)this.getList().getValueAt(i, 0);
            infoList.add(item.getData());
        }
        return infoList;
    }

    List<TableItem<T>> getSelectedItems() {
        LinkedList<TableItem<T>> infoList = new LinkedList<TableItem<T>>();
        for (int i : this.getList().getSelectedRows()) {
            TableItem item = (TableItem)this.getList().getValueAt(i, 0);
            infoList.add(item);
        }
        return infoList;
    }

    void setSelectionInterval(int anchor, int lead) {
        this.getList().getSelectionModel().setSelectionInterval(anchor, lead);
    }

    void createFilter() {
        this.filter = new RowFilter<ItemModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends ItemModel, ? extends Integer> entry) {
                TableItem item = (TableItem)entry.getModel().getValueAt(entry.getIdentifier(), 0);
                for (ItemChooser.ItemFilter userFilter : SelectionPanel.this.userFilters) {
                    if (userFilter.include(item.getData())) continue;
                    return false;
                }
                if (SelectionPanel.this.findPattern != "" && item.getNameLowerCase().indexOf(SelectionPanel.this.findPattern) == -1) {
                    return false;
                }
                return item.getSide() == SelectionPanel.this.side;
            }
        };
    }

    void setModel(ItemModel model) {
        this.getList().setSelectionModel(new DefaultListSelectionModel());
        TableRowSorter<ItemModel> sorter = new TableRowSorter<ItemModel>(model);
        this.getList().setModel(model);
        sorter.setMaxSortKeys(1);
        sorter.setSortsOnUpdates(true);
        sorter.setRowFilter(this.filter);
        sorter.setComparator(0, new Comparator<TableItem<T>>(){

            @Override
            public int compare(TableItem<T> o1, TableItem<T> o2) {
                return o1.getNameLowerCase().compareTo(o2.getNameLowerCase());
            }
        });
        this.getList().setRowSorter(sorter);
        sorter.toggleSortOrder(0);
    }

    public void removeSelection() {
        this.getList().clearSelection();
    }

    public Side getSide() {
        return this.side;
    }

    public void update() {
        ((TableRowSorter)this.getList().getRowSorter()).setRowFilter(this.filter);
    }

    static enum Side {
        LEFT,
        RIGHT;

    }
}

