/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.mergerule;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.mergerule.MergeProcedureCompletion;
import de.uka.ilkd.key.gui.utilities.WrapLayout;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Semisequent;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.TermBuilder;
import de.uka.ilkd.key.logic.TermServices;
import de.uka.ilkd.key.pp.LogicPrinter;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.rule.merge.MergePartner;
import de.uka.ilkd.key.rule.merge.MergeProcedure;
import de.uka.ilkd.key.rule.merge.MergeRule;
import de.uka.ilkd.key.rule.merge.MergeRuleBuiltInRuleApp;
import de.uka.ilkd.key.util.Pair;
import de.uka.ilkd.key.util.mergerule.MergeRuleUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.html.HTMLDocument;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;

public class MergePartnerSelectionDialog
extends JDialog {
    private static final long serialVersionUID = -1460097562546341922L;
    private static final String CB_SELECT_CANDIDATE_HINT = "Select to add shown state as a merge partner.";
    private static final String CHOOSE_ALL_BTN_TOOLTIP_TXT = "Select all proposed goals as merge partners. Only enabled if the merge is applicable for all goals and the chosen merge procedure.";
    private static final String OK_BTN_TOOLTIP_TXT = "Select the chosen goals as merge partners. Only enabled if at least one goal is chosen and the merge is applicable for the chosen goals and merge procedure.";
    private static final Dimension INITIAL_SIZE = new Dimension(900, 450);
    private static final Font TXT_AREA_FONT = new Font("Monospaced", 0, 14);
    private static final MainWindow MAIN_WINDOW_INSTANCE = MainWindow.getInstance();
    private static Comparator<MergePartner> GOAL_COMPARATOR = new Comparator<MergePartner>(){

        @Override
        public int compare(MergePartner o1, MergePartner o2) {
            return o1.getGoal().node().serialNr() - o2.getGoal().node().serialNr();
        }
    };
    private LinkedList<MergePartner> candidates = null;
    private Services services = null;
    private Pair<Goal, PosInOccurrence> mergeGoalPio = null;
    private SortedSet<MergePartner> chosenGoals = new TreeSet<MergePartner>(GOAL_COMPARATOR);
    private MergeProcedure chosenRule = (MergeProcedure)MergeProcedure.getMergeProcedures().head();
    private Term chosenDistForm = null;
    private JEditorPane txtPartner1 = new JEditorPane();
    private JEditorPane txtPartner2 = new JEditorPane();
    private JComboBox<String> cmbCandidates = null;
    private JCheckBox cbSelectCandidate = null;
    private ButtonGroup bgMergeMethods = null;
    private final JTextField txtDistForm;
    private JScrollPane scrpPartner1 = null;
    private JScrollPane scrpPartner2 = null;
    private JButton okButton = null;
    private JButton chooseAllButton = null;

    private MergePartnerSelectionDialog() {
        super(MAIN_WINDOW_INSTANCE, "Select partner node for merge operation", true);
        for (JEditorPane jep : new JEditorPane[]{this.txtPartner1, this.txtPartner2}) {
            jep.setEditable(false);
            jep.setContentType("text/html");
            String cssRule = "body { font-family: " + TXT_AREA_FONT.getFamily() + "; font-size: " + TXT_AREA_FONT.getSize() + "pt; }";
            ((HTMLDocument)jep.getDocument()).getStyleSheet().addRule(cssRule);
        }
        this.scrpPartner1 = new JScrollPane(this.txtPartner1);
        this.scrpPartner2 = new JScrollPane(this.txtPartner2);
        this.cmbCandidates = new JComboBox();
        this.cmbCandidates.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.cmbCandidates.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MergePartner selectedCandidate = MergePartnerSelectionDialog.this.getSelectedCandidate();
                MergePartnerSelectionDialog.this.setHighlightedSequentForArea(selectedCandidate.getGoal(), selectedCandidate.getPio(), MergePartnerSelectionDialog.this.txtPartner2);
                if (MergePartnerSelectionDialog.this.chosenGoals.contains(selectedCandidate)) {
                    MergePartnerSelectionDialog.this.cbSelectCandidate.setSelected(true);
                } else {
                    MergePartnerSelectionDialog.this.cbSelectCandidate.setSelected(false);
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                int halfWidth = MergePartnerSelectionDialog.this.getWidth() / 2;
                MergePartnerSelectionDialog.this.scrpPartner1.setPreferredSize(new Dimension(halfWidth, MergePartnerSelectionDialog.this.scrpPartner1.getHeight()));
                MergePartnerSelectionDialog.this.scrpPartner2.setPreferredSize(new Dimension(halfWidth, MergePartnerSelectionDialog.this.scrpPartner2.getHeight()));
            }
        });
        this.cbSelectCandidate = new JCheckBox();
        this.cbSelectCandidate.setToolTipText(CB_SELECT_CANDIDATE_HINT);
        this.cbSelectCandidate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MergePartnerSelectionDialog.this.cbSelectCandidate.isSelected()) {
                    MergePartnerSelectionDialog.this.chosenGoals.add(MergePartnerSelectionDialog.this.getSelectedCandidate());
                } else {
                    MergePartnerSelectionDialog.this.chosenGoals.remove(MergePartnerSelectionDialog.this.getSelectedCandidate());
                }
                MergePartnerSelectionDialog.this.checkApplicable();
            }
        });
        this.bgMergeMethods = new ButtonGroup();
        for (final MergeProcedure rule : MergeProcedure.getMergeProcedures()) {
            JRadioButton rb = new JRadioButton(rule.toString());
            rb.setSelected(true);
            rb.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MergePartnerSelectionDialog.this.chosenRule = rule;
                    MergePartnerSelectionDialog.this.checkApplicable();
                }
            });
            this.bgMergeMethods.add(rb);
        }
        JPanel mergeStateContainer = new JPanel();
        mergeStateContainer.setLayout(new BoxLayout(mergeStateContainer, 1));
        mergeStateContainer.add(this.scrpPartner1);
        TitledBorder mergeStateContainerTitle = BorderFactory.createTitledBorder("State to merge");
        mergeStateContainerTitle.setTitleJustification(1);
        mergeStateContainer.setBorder(mergeStateContainerTitle);
        JPanel partnerContainer = new JPanel();
        partnerContainer.setLayout(new BoxLayout(partnerContainer, 1));
        partnerContainer.add(this.scrpPartner2);
        JPanel selectionContainer = new JPanel();
        selectionContainer.setLayout(new BoxLayout(selectionContainer, 0));
        selectionContainer.add(this.cbSelectCandidate);
        selectionContainer.add(this.cmbCandidates);
        partnerContainer.add(selectionContainer);
        TitledBorder txtPartner2Title = BorderFactory.createTitledBorder("Potential merge partners");
        txtPartner2Title.setTitleJustification(1);
        partnerContainer.setBorder(txtPartner2Title);
        JPanel upperContainer = new JPanel();
        upperContainer.setLayout(new BoxLayout(upperContainer, 0));
        upperContainer.add(mergeStateContainer);
        upperContainer.add(partnerContainer);
        JPanel mergeRulesContainer = new JPanel();
        mergeRulesContainer.setLayout(new WrapLayout());
        Enumeration<AbstractButton> e = this.bgMergeMethods.getElements();
        while (e.hasMoreElements()) {
            JRadioButton rb = (JRadioButton)e.nextElement();
            mergeRulesContainer.add(rb);
        }
        TitledBorder mergeRulesContainerTitle = BorderFactory.createTitledBorder("Concrete merge procedure to apply");
        mergeRulesContainerTitle.setTitleJustification(1);
        mergeRulesContainerTitle.setBorder(mergeStateContainerTitle);
        mergeRulesContainer.setBorder(mergeRulesContainerTitle);
        this.txtDistForm = new JTextField();
        this.txtDistForm.setMargin(new Insets(5, 0, 5, 0));
        this.txtDistForm.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                MergePartnerSelectionDialog.this.chosenDistForm = MergeRuleUtils.translateToFormula((Services)MergePartnerSelectionDialog.this.services, (String)MergePartnerSelectionDialog.this.txtDistForm.getText());
                if (MergePartnerSelectionDialog.this.chosenDistForm == null || !MergePartnerSelectionDialog.this.isSuitableDistFormula()) {
                    MergePartnerSelectionDialog.this.txtDistForm.setForeground(Color.RED);
                } else {
                    MergePartnerSelectionDialog.this.txtDistForm.setForeground(Color.BLACK);
                }
                MergePartnerSelectionDialog.this.checkApplicable();
            }
        });
        JPanel distFormContainer = new JPanel();
        distFormContainer.setLayout(new BorderLayout());
        distFormContainer.add((Component)this.txtDistForm, "Center");
        TitledBorder distFormContainerTitle = BorderFactory.createTitledBorder("Distinguishing formula (leave empty for automatic generation!)");
        distFormContainerTitle.setTitleJustification(1);
        distFormContainer.setBorder(distFormContainerTitle);
        this.okButton = new JButton("OK");
        this.chooseAllButton = new JButton("Choose All");
        JButton cancelButton = new JButton("Cancel");
        this.okButton.setAlignmentX(0.5f);
        this.chooseAllButton.setAlignmentX(0.5f);
        cancelButton.setAlignmentX(0.5f);
        this.okButton.setToolTipText(OK_BTN_TOOLTIP_TXT);
        this.chooseAllButton.setToolTipText(CHOOSE_ALL_BTN_TOOLTIP_TXT);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergePartnerSelectionDialog.this.setVisible(false);
                MergePartnerSelectionDialog.this.dispose();
            }
        });
        this.chooseAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (MergePartner candidate : MergePartnerSelectionDialog.this.candidates) {
                    MergePartnerSelectionDialog.this.chosenGoals.add(candidate);
                }
                MergePartnerSelectionDialog.this.setVisible(false);
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergePartnerSelectionDialog.this.chosenGoals = null;
                MergePartnerSelectionDialog.this.setVisible(false);
            }
        });
        JPanel ctrlBtnsContainer = new JPanel();
        ctrlBtnsContainer.setLayout(new BoxLayout(ctrlBtnsContainer, 0));
        ctrlBtnsContainer.add(Box.createHorizontalGlue());
        ctrlBtnsContainer.add(this.okButton);
        Dimension fillerDim = new Dimension(30, 40);
        ctrlBtnsContainer.add(new Box.Filler(fillerDim, fillerDim, fillerDim));
        ctrlBtnsContainer.add(this.chooseAllButton);
        ctrlBtnsContainer.add(new Box.Filler(fillerDim, fillerDim, fillerDim));
        ctrlBtnsContainer.add(cancelButton);
        ctrlBtnsContainer.add(Box.createHorizontalGlue());
        JPanel lowerContainer = new JPanel();
        Dimension verticalFillerDim = new Dimension(0, 10);
        lowerContainer.setLayout(new BoxLayout(lowerContainer, 1));
        lowerContainer.add(mergeRulesContainer);
        lowerContainer.add(new Box.Filler(verticalFillerDim, verticalFillerDim, verticalFillerDim));
        lowerContainer.add(distFormContainer);
        lowerContainer.add(new Box.Filler(verticalFillerDim, verticalFillerDim, verticalFillerDim));
        lowerContainer.add(ctrlBtnsContainer);
        this.getContentPane().add((Component)upperContainer, "Center");
        this.getContentPane().add((Component)lowerContainer, "South");
        this.setSize(INITIAL_SIZE);
        this.setLocationRelativeTo(MAIN_WINDOW_INSTANCE);
    }

    public MergePartnerSelectionDialog(Goal mergeGoal, PosInOccurrence pio, ImmutableList<MergePartner> candidates, Services services) {
        this();
        this.services = services;
        this.candidates = new LinkedList();
        this.mergeGoalPio = new Pair((Object)mergeGoal, (Object)pio);
        for (MergePartner candidate : candidates) {
            int insPos = Collections.binarySearch(this.candidates, candidate, GOAL_COMPARATOR);
            insPos = (insPos + 1) * -1;
            this.candidates.add(insPos, candidate);
        }
        this.setHighlightedSequentForArea(mergeGoal, pio, this.txtPartner1);
        this.loadCandidates();
    }

    public ImmutableList<MergePartner> getChosenCandidates() {
        ImmutableSLList result = ImmutableSLList.nil();
        if (this.chosenGoals != null) {
            return result.append(this.chosenGoals);
        }
        return result;
    }

    public <T extends MergeProcedure> T getChosenMergeRule() {
        MergeProcedureCompletion<MergeProcedure> completion = MergeProcedureCompletion.getCompletionForClass(this.chosenRule.getClass());
        return (T)completion.complete(this.chosenRule, this.mergeGoalPio, this.chosenGoals);
    }

    public Term getChosenDistinguishingFormula() {
        return this.isSuitableDistFormula() ? this.chosenDistForm : null;
    }

    private boolean isApplicableForCandidates(ImmutableList<MergePartner> theCandidates) {
        if (this.mergeGoalPio != null && this.candidates != null && this.chosenRule != null) {
            MergeRuleBuiltInRuleApp mergeRuleApp = (MergeRuleBuiltInRuleApp)MergeRule.INSTANCE.createApp((PosInOccurrence)this.mergeGoalPio.second, (TermServices)this.services);
            mergeRuleApp.setMergeNode(((Goal)this.mergeGoalPio.first).node());
            mergeRuleApp.setConcreteRule(this.chosenRule);
            mergeRuleApp.setMergePartners(theCandidates);
            return mergeRuleApp.complete();
        }
        return false;
    }

    private void checkApplicable() {
        this.okButton.setEnabled(this.chosenGoals.size() > 0 && this.isApplicableForCandidates(this.immutableListFromIterabe(this.chosenGoals)));
        this.chooseAllButton.setEnabled(this.candidates.size() > 0 && this.isApplicableForCandidates(this.immutableListFromIterabe(this.candidates)));
        this.txtDistForm.setEnabled(this.candidates.size() == 1 || this.chosenGoals.size() == 1);
        if (!this.txtDistForm.isEnabled()) {
            this.chosenDistForm = null;
        }
    }

    private boolean isSuitableDistFormula() {
        Goal partnerGoal;
        if (this.chosenDistForm == null) {
            return false;
        }
        TermBuilder tb = this.services.getTermBuilder();
        Object object = this.candidates.size() == 1 ? this.candidates.getFirst().getGoal() : (partnerGoal = this.chosenGoals.size() == 1 ? this.chosenGoals.first().getGoal() : null);
        if (partnerGoal == null) {
            return false;
        }
        return MergePartnerSelectionDialog.checkProvability(((Goal)this.mergeGoalPio.first).sequent(), this.chosenDistForm, this.services) && MergePartnerSelectionDialog.checkProvability(partnerGoal.sequent(), tb.not(this.chosenDistForm), this.services);
    }

    private static boolean checkProvability(Sequent seq, Term formulaToProve, Services services) {
        TermBuilder tb = services.getTermBuilder();
        Semisequent antecedent = seq.antecedent();
        for (SequentFormula succedentFormula : seq.succedent()) {
            if (succedentFormula.formula().containsJavaBlockRecursive()) continue;
            antecedent = antecedent.insertFirst(new SequentFormula(tb.not(succedentFormula.formula()))).semisequent();
        }
        return MergeRuleUtils.isProvable((Sequent)Sequent.createSequent((Semisequent)antecedent, (Semisequent)new Semisequent(new SequentFormula(formulaToProve))), (Services)services, (int)1000);
    }

    private <T> ImmutableList<T> immutableListFromIterabe(Iterable<T> it) {
        ImmutableSLList result = ImmutableSLList.nil();
        for (T t : it) {
            result = result.prepend(t);
        }
        return result;
    }

    private MergePartner getSelectedCandidate() {
        return this.getNthCandidate(this.cmbCandidates.getSelectedIndex());
    }

    private MergePartner getNthCandidate(int n) {
        int i = 0;
        for (MergePartner elem : this.candidates) {
            if (i == n) {
                return elem;
            }
            ++i;
        }
        return null;
    }

    private void loadCandidates() {
        if (this.candidates.size() < 1) {
            return;
        }
        for (MergePartner candidate : this.candidates) {
            this.cmbCandidates.addItem("Node " + candidate.getGoal().node().serialNr());
        }
        this.setHighlightedSequentForArea(this.candidates.getFirst().getGoal(), this.candidates.getFirst().getPio(), this.txtPartner2);
        this.checkApplicable();
    }

    private void setHighlightedSequentForArea(Goal goal, PosInOccurrence pio, JEditorPane area) {
        Object subterm = LogicPrinter.quickPrintTerm((Term)pio.subTerm(), (Services)this.services);
        subterm = ((String)subterm).replaceAll("\\s", "\\\\s");
        subterm = ((String)subterm).replaceAll("(\\\\s)+", "\\\\E\\\\s*\\\\Q");
        if (((String)(subterm = "\\Q" + (String)subterm + "\\E")).endsWith("\\Q\\E")) {
            subterm = ((String)subterm).substring(0, ((String)subterm).length() - 4);
        }
        String sequent = LogicPrinter.quickPrintSequent((Sequent)goal.sequent(), (Services)this.services);
        Pattern p = Pattern.compile((String)subterm);
        Matcher m = p.matcher(sequent);
        Object newText = sequent;
        newText = LogicPrinter.escapeHTML((String)newText, (boolean)true);
        if (m.find()) {
            String before = LogicPrinter.escapeHTML((String)sequent.substring(0, m.start() - 1), (boolean)true);
            String main = "<b>" + LogicPrinter.escapeHTML((String)sequent.substring(m.start(), m.end()), (boolean)true) + "</b>";
            String after = LogicPrinter.escapeHTML((String)sequent.substring(m.end()), (boolean)true);
            newText = before + main + after;
        }
        newText = ((String)newText).replace("\n", "<br>");
        newText = ((String)newText).replace(" ", "&nbsp;");
        area.setText((String)newText);
    }
}

