/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.mergerule;

import de.uka.ilkd.key.gui.InteractiveRuleApplicationCompletion;
import de.uka.ilkd.key.gui.mergerule.MergePartnerSelectionDialog;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.rule.IBuiltInRuleApp;
import de.uka.ilkd.key.rule.merge.MergePartner;
import de.uka.ilkd.key.rule.merge.MergeProcedure;
import de.uka.ilkd.key.rule.merge.MergeRule;
import de.uka.ilkd.key.rule.merge.MergeRuleBuiltInRuleApp;
import de.uka.ilkd.key.rule.merge.procedures.MergeByIfThenElse;
import org.key_project.util.collection.ImmutableList;

public class MergeRuleCompletion
implements InteractiveRuleApplicationCompletion {
    public static final MergeRuleCompletion INSTANCE = new MergeRuleCompletion();
    private static final MergeProcedure STD_CONCRETE_MERGE_RULE = MergeByIfThenElse.instance();

    private MergeRuleCompletion() {
    }

    @Override
    public IBuiltInRuleApp complete(IBuiltInRuleApp app, Goal goal, boolean forced) {
        Object chosenRule;
        MergeRuleBuiltInRuleApp mergeApp = (MergeRuleBuiltInRuleApp)app;
        PosInOccurrence pio = mergeApp.posInOccurrence();
        ImmutableList<MergePartner> candidates = MergeRule.findPotentialMergePartners((Goal)goal, (PosInOccurrence)pio);
        ImmutableList<MergePartner> chosenCandidates = null;
        Term chosenDistForm = null;
        if (forced) {
            chosenCandidates = candidates;
            chosenRule = STD_CONCRETE_MERGE_RULE;
        } else {
            MergePartnerSelectionDialog dialog = new MergePartnerSelectionDialog(goal, pio, candidates, goal.proof().getServices());
            dialog.setVisible(true);
            chosenCandidates = dialog.getChosenCandidates();
            chosenRule = dialog.getChosenMergeRule();
            chosenDistForm = dialog.getChosenDistinguishingFormula();
        }
        if (chosenCandidates == null || chosenCandidates.size() < 1) {
            return null;
        }
        MergeRuleBuiltInRuleApp result = new MergeRuleBuiltInRuleApp(app.rule(), pio);
        result.setMergePartners(chosenCandidates);
        result.setConcreteRule(chosenRule);
        result.setDistinguishingFormula(chosenDistForm);
        result.setMergeNode(goal.node());
        return result;
    }

    @Override
    public boolean canComplete(IBuiltInRuleApp app) {
        return MergeRuleCompletion.checkCanComplete(app);
    }

    public static boolean checkCanComplete(IBuiltInRuleApp app) {
        return app instanceof MergeRuleBuiltInRuleApp;
    }
}

