/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.mergerule;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.mergerule.MergeRuleCompletion;
import de.uka.ilkd.key.gui.notification.events.ExceptionFailureEvent;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.TermServices;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.prover.TaskFinishedInfo;
import de.uka.ilkd.key.prover.TaskStartedInfo;
import de.uka.ilkd.key.prover.impl.DefaultTaskFinishedInfo;
import de.uka.ilkd.key.prover.impl.DefaultTaskStartedInfo;
import de.uka.ilkd.key.rule.IBuiltInRuleApp;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.rule.merge.MergeRule;
import de.uka.ilkd.key.rule.merge.MergeRuleBuiltInRuleApp;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class MergeRuleMenuItem
extends JMenuItem {
    private static final long serialVersionUID = -8509570987542243690L;

    public MergeRuleMenuItem(final Goal goal, final PosInOccurrence pio, final KeYMediator mediator) {
        final Services services = goal.proof().getServices();
        this.setText(this.toString());
        this.setAction(new AbstractAction(this.toString()){
            private static final long serialVersionUID = 7695435228507302440L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeRuleCompletion completion = MergeRuleCompletion.INSTANCE;
                MergeRule joinRule = MergeRule.INSTANCE;
                MergeRuleBuiltInRuleApp app = (MergeRuleBuiltInRuleApp)joinRule.createApp(pio, (TermServices)services);
                final MergeRuleBuiltInRuleApp completedApp = (MergeRuleBuiltInRuleApp)completion.complete((IBuiltInRuleApp)app, goal, false);
                if (completedApp != null && completedApp.complete()) {
                    try {
                        mediator.stopInterface(true);
                        mediator.getUI().taskStarted((TaskStartedInfo)new DefaultTaskStartedInfo(TaskStartedInfo.TaskKind.Other, "Merging " + (completedApp.getMergePartners().size() + 1) + " nodes", completedApp.getMergePartners().size()));
                        mediator.getUI().taskProgress(0);
                        completedApp.registerProgressListener(progress -> mediator.getUI().setProgress(progress));
                        new SwingWorker<Void, Void>(){
                            private long duration;

                            @Override
                            protected Void doInBackground() throws Exception {
                                long time = System.currentTimeMillis();
                                mediator.getUI().getProofControl().applyInteractive((RuleApp)completedApp, goal);
                                this.duration = System.currentTimeMillis() - time;
                                return null;
                            }

                            @Override
                            protected void done() {
                                completedApp.clearProgressListeners();
                                mediator.getUI().taskFinished((TaskFinishedInfo)new DefaultTaskFinishedInfo((Object)this, (Object)goal, goal.proof(), this.duration, 1, 0));
                                mediator.startInterface(true);
                                mediator.getSelectionModel().setSelectedGoal(goal);
                            }
                        }.execute();
                    }
                    catch (Exception exc) {
                        MergeRuleMenuItem.this.signalError(exc, mediator);
                    }
                    catch (AssertionError exc) {
                        MergeRuleMenuItem.this.signalError((Throwable)((Object)exc), mediator);
                    }
                }
            }
        });
    }

    private void signalError(final Throwable e, final KeYMediator mediator) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                mediator.notify(new ExceptionFailureEvent(e.getMessage(), e));
            }
        });
    }

    @Override
    public String toString() {
        return "State Merging Rule";
    }
}

