/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.mergerule.predicateabstraction;

import de.uka.ilkd.key.axiom_abstraction.AbstractDomainElement;
import de.uka.ilkd.key.axiom_abstraction.AbstractDomainLattice;
import de.uka.ilkd.key.axiom_abstraction.predicateabstraction.AbstractPredicateAbstractionDomainElement;
import de.uka.ilkd.key.axiom_abstraction.predicateabstraction.AbstractPredicateAbstractionLattice;
import de.uka.ilkd.key.axiom_abstraction.predicateabstraction.AbstractionPredicate;
import de.uka.ilkd.key.axiom_abstraction.predicateabstraction.ConjunctivePredicateAbstractionLattice;
import de.uka.ilkd.key.axiom_abstraction.predicateabstraction.DisjunctivePredicateAbstractionLattice;
import de.uka.ilkd.key.axiom_abstraction.predicateabstraction.SimplePredicateAbstractionLattice;
import de.uka.ilkd.key.control.KeYEnvironment;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.mergerule.predicateabstraction.AbstractDomainElemChoice;
import de.uka.ilkd.key.gui.mergerule.predicateabstraction.ObservableArrayList;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.logic.Named;
import de.uka.ilkd.key.logic.Namespace;
import de.uka.ilkd.key.logic.NamespaceSet;
import de.uka.ilkd.key.logic.ProgramElementName;
import de.uka.ilkd.key.logic.op.LocationVariable;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.parser.ParserException;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.init.JavaProfile;
import de.uka.ilkd.key.proof.init.Profile;
import de.uka.ilkd.key.proof.io.OutputStreamProofSaver;
import de.uka.ilkd.key.proof.io.ProblemLoaderException;
import de.uka.ilkd.key.rule.merge.procedures.MergeWithPredicateAbstraction;
import de.uka.ilkd.key.util.Pair;
import de.uka.ilkd.key.util.mergerule.MergeRuleUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractionPredicatesChoiceDialog
extends JDialog {
    private static final String AVAILABLE_PROGRAM_VARIABLES_DESCR = "Available Program Variables: ";
    private static final long serialVersionUID = 1L;
    private static final MainWindow MAIN_WINDOW_INSTANCE = MainWindow.getInstance();
    private static final Dimension INITIAL_SIZE = new Dimension(850, 600);
    private static final String DIALOG_TITLE = "Choose abstraction predicates for merge";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractionPredicatesChoiceDialog.class);
    private Goal goal = null;
    private ArrayList<Pair<Sort, Name>> registeredPlaceholders = new ArrayList();
    private ArrayList<AbstractionPredicate> registeredPredicates = new ArrayList();
    private ArrayList<AbstractDomainElemChoice> abstrPredicateChoices = new ArrayList();
    private Class<? extends AbstractPredicateAbstractionLattice> latticeType = SimplePredicateAbstractionLattice.class;
    private final ObservableArrayList<String> placeholdersProblemsListData = new ObservableArrayList();
    private final ObservableArrayList<String> abstrPredProblemsListData = new ObservableArrayList();

    private ArrayList<AbstractionPredicate> getRegisteredPredicates() {
        return this.registeredPredicates;
    }

    private Class<? extends AbstractPredicateAbstractionLattice> getLatticeType() {
        return this.latticeType;
    }

    public Result getResult() {
        return new Result(this.getRegisteredPredicates(), this.getLatticeType(), this.abstrPredicateChoices);
    }

    public AbstractionPredicatesChoiceDialog(Goal goal, List<LocationVariable> differingLocVars) {
        this();
        this.goal = goal;
        differingLocVars.forEach(v -> this.abstrPredicateChoices.add(new AbstractDomainElemChoice((ProgramVariable)v, Optional.empty())));
    }

    private AbstractionPredicatesChoiceDialog() {
        super(MAIN_WINDOW_INSTANCE, DIALOG_TITLE, true);
        this.setSize(INITIAL_SIZE);
        this.setLocationRelativeTo(MAIN_WINDOW_INSTANCE);
        this.setDefaultCloseOperation(2);
        this.createDialog();
    }

    private void createDialog() {
        JPanel infoPanel = this.createInfoPanel();
        JTabbedPane stepsTabbedPane = new JTabbedPane();
        JPanel latticeTypePanel = this.createLatticeTypePanel();
        JPanel placeholdersPanel = this.createPlaceholderVariablesPanel();
        JPanel abstrPredsPanel = this.createAbstractionPredicatesPanel();
        JPanel choiceAbstrPredsPanel = this.createChoiceAbstrPredsPanel();
        stepsTabbedPane.add("(1) Lattice Type", latticeTypePanel);
        stepsTabbedPane.add("(2) Placeholder Variables", placeholdersPanel);
        stepsTabbedPane.add("(3) Abstraction Predicates", abstrPredsPanel);
        stepsTabbedPane.add("(4) Choice of Abstraction Predicates [opt]", choiceAbstrPredsPanel);
        TitledBorder problemsPanelBorder = new TitledBorder("Problems");
        JPanel problemsLabelContainer = this.createProblemsLabelContainer();
        problemsLabelContainer.setBorder(problemsPanelBorder);
        problemsLabelContainer.setPreferredSize(new Dimension(200, 250));
        JSplitPane centerSplitPane = new JSplitPane(1, stepsTabbedPane, problemsLabelContainer);
        centerSplitPane.setResizeWeight(1.0);
        centerSplitPane.setOneTouchExpandable(true);
        centerSplitPane.setDividerLocation(550);
        Dimension centerComponentsMinSize = new Dimension(200, 50);
        stepsTabbedPane.setMinimumSize(centerComponentsMinSize);
        problemsLabelContainer.setMinimumSize(centerComponentsMinSize);
        JSplitPane rootSplitPane = new JSplitPane(0, infoPanel, centerSplitPane);
        rootSplitPane.setResizeWeight(0.0);
        rootSplitPane.setOneTouchExpandable(true);
        rootSplitPane.setDividerLocation(220);
        JPanel controlsPanel = new JPanel(new FlowLayout());
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> {
            this.registeredPlaceholders = null;
            this.registeredPredicates = null;
            this.setVisible(false);
            this.dispose();
        });
        JButton okButton = new JButton("OK");
        okButton.addActionListener(e -> {
            this.setVisible(false);
            this.dispose();
        });
        controlsPanel.add(cancelButton);
        controlsPanel.add(okButton);
        JPanel rootPane = new JPanel(new BorderLayout());
        rootPane.add((Component)rootSplitPane, "Center");
        rootPane.add((Component)controlsPanel, "South");
        this.getContentPane().add(rootPane);
    }

    private JPanel createChoiceAbstrPredsPanel() {
        JPanel result = new JPanel(new BorderLayout());
        ChoiceTableModel model = new ChoiceTableModel();
        DomElemChoiceTable choiceTable = new DomElemChoiceTable(model);
        choiceTable.setFillsViewportHeight(true);
        JScrollPane scrollPane = new JScrollPane(choiceTable);
        result.add((Component)scrollPane, "Center");
        return result;
    }

    private JPanel createProblemsLabelContainer() {
        JPanel result = new JPanel(new BorderLayout());
        String resourcePath = "/de/uka/ilkd/key/gui/";
        String stylesheet = AbstractionPredicatesChoiceDialog.readFromResourceFile("/de/uka/ilkd/key/gui/css/abstrPredsMergeDialog.css");
        JTextPane problemsTxtPane = new JTextPane();
        problemsTxtPane.setContentType("text/html");
        ObservableArrayList.ObservableArrayListChangeListener listener = () -> {
            StringBuilder sb = new StringBuilder();
            sb.append("<html><head>");
            sb.append("<style type=\"text/css\">");
            sb.append(stylesheet);
            sb.append("</style>");
            if (!this.placeholdersProblemsListData.isEmpty()) {
                sb.append("<h3>Placeholder Variables</h3>");
                sb.append("<table>");
                for (String problem : this.placeholdersProblemsListData) {
                    sb.append("<tr><td>").append(problem).append("</td></tr>");
                }
                sb.append("</table>");
            }
            if (!this.abstrPredProblemsListData.isEmpty()) {
                sb.append("<h3>Abstraction Predicates</h3>");
                sb.append("<table>");
                for (String problem : this.abstrPredProblemsListData) {
                    sb.append("<tr><td>").append(problem).append("</td></tr>");
                }
                sb.append("</table>");
            }
            sb.append("</head><body>");
            sb.append("</body></html>");
            problemsTxtPane.setText(sb.toString());
        };
        this.placeholdersProblemsListData.addListener(listener);
        this.abstrPredProblemsListData.addListener(listener);
        JScrollPane scrollPane = new JScrollPane(problemsTxtPane, 22, 31);
        scrollPane.setPreferredSize(new Dimension(AbstractionPredicatesChoiceDialog.INITIAL_SIZE.width, 200));
        result.add((Component)scrollPane, "Center");
        return result;
    }

    private JPanel createPlaceholderVariablesPanel() {
        JPanel result = new JPanel(new BorderLayout());
        final JTextField txtPlaceholderInput = new JTextField();
        txtPlaceholderInput.setToolTipText("Enter a new placeholder variable (e.g., \"int _ph1\")");
        txtPlaceholderInput.setFont(new Font("Monospaced", 0, 12));
        result.add((Component)txtPlaceholderInput, "North");
        final DefaultListModel placeholdersLstModel = new DefaultListModel();
        final JList lstPlaceholders = new JList(placeholdersLstModel);
        lstPlaceholders.setSelectionMode(0);
        lstPlaceholders.setLayoutOrientation(0);
        lstPlaceholders.setVisibleRowCount(-1);
        lstPlaceholders.setFont(new Font("Monospaced", 0, 12));
        JScrollPane sp = new JScrollPane(lstPlaceholders);
        result.add((Component)sp, "Center");
        txtPlaceholderInput.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                String currInput = txtPlaceholderInput.getText();
                if (currInput.isEmpty()) {
                    AbstractionPredicatesChoiceDialog.this.placeholdersProblemsListData.clear();
                    return;
                }
                try {
                    AbstractionPredicatesChoiceDialog.this.parsePlaceholder(currInput);
                    AbstractionPredicatesChoiceDialog.this.placeholdersProblemsListData.clear();
                }
                catch (Exception e) {
                    AbstractionPredicatesChoiceDialog.this.placeholdersProblemsListData.clear();
                    AbstractionPredicatesChoiceDialog.this.placeholdersProblemsListData.add(e.getMessage());
                    LOGGER.error("Exception!", (Throwable)e);
                }
            }
        });
        txtPlaceholderInput.addActionListener(e -> {
            String currInput = txtPlaceholderInput.getText();
            if (this.placeholdersProblemsListData.isEmpty() && !currInput.isEmpty()) {
                placeholdersLstModel.addElement(currInput);
                txtPlaceholderInput.setText("");
                Pair<Sort, Name> parsed = this.parsePlaceholder(currInput);
                this.registeredPlaceholders.add(parsed);
                Namespace pvs = this.goal.proof().getServices().getNamespaces().programVariables();
                pvs.add((Named)new LocationVariable(new ProgramElementName(((Name)parsed.second).toString()), (Sort)parsed.first));
            }
        });
        lstPlaceholders.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int selectedIndex = lstPlaceholders.getSelectedIndex();
                if (e.getKeyCode() == 127 && !placeholdersLstModel.isEmpty() && selectedIndex >= 0) {
                    placeholdersLstModel.remove(selectedIndex);
                    Pair<Sort, Name> removedPlaceholder = AbstractionPredicatesChoiceDialog.this.registeredPlaceholders.remove(selectedIndex);
                    Namespace pvs = AbstractionPredicatesChoiceDialog.this.goal.proof().getServices().getNamespaces().programVariables();
                    pvs.remove((Name)removedPlaceholder.second);
                }
            }
        });
        return result;
    }

    private JPanel createAbstractionPredicatesPanel() {
        JPanel result = new JPanel(new BorderLayout());
        final JTextField txtAbstrPredInput = new JTextField();
        txtAbstrPredInput.setToolTipText("Enter a new predicate (e.g., \"_ph1 > 0\").");
        txtAbstrPredInput.setFont(new Font("Monospaced", 0, 12));
        result.add((Component)txtAbstrPredInput, "North");
        final DefaultListModel abstrPredListModel = new DefaultListModel();
        final JList lstAbstrPreds = new JList(abstrPredListModel);
        lstAbstrPreds.setSelectionMode(0);
        lstAbstrPreds.setLayoutOrientation(0);
        lstAbstrPreds.setVisibleRowCount(-1);
        lstAbstrPreds.setFont(new Font("Monospaced", 0, 12));
        JScrollPane sp = new JScrollPane(lstAbstrPreds);
        result.add((Component)sp, "Center");
        if (this.goal != null) {
            String progVarsStr = this.goal.node().getLocalProgVars().toString().replace(",", ", ");
            progVarsStr = progVarsStr.substring(1, progVarsStr.length() - 1);
            JLabel lblAvailableProgVars = new JLabel(AVAILABLE_PROGRAM_VARIABLES_DESCR + progVarsStr);
            result.add((Component)lblAvailableProgVars, "South");
            lblAvailableProgVars.setFont(new Font("SansSerif", 0, 12));
        }
        txtAbstrPredInput.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                String currInput = txtAbstrPredInput.getText();
                if (currInput.isEmpty()) {
                    AbstractionPredicatesChoiceDialog.this.abstrPredProblemsListData.clear();
                    return;
                }
                try {
                    AbstractionPredicate pred = AbstractionPredicatesChoiceDialog.this.parsePredicate(currInput, AbstractionPredicatesChoiceDialog.this.goal.getLocalNamespaces());
                    AbstractionPredicatesChoiceDialog.this.abstrPredProblemsListData.clear();
                    if (AbstractionPredicatesChoiceDialog.this.registeredPredicates.contains(pred)) {
                        AbstractionPredicatesChoiceDialog.this.abstrPredProblemsListData.add("Predicate is already registered");
                    }
                }
                catch (Exception e) {
                    AbstractionPredicatesChoiceDialog.this.abstrPredProblemsListData.clear();
                    AbstractionPredicatesChoiceDialog.this.abstrPredProblemsListData.add(e.getMessage());
                    LOGGER.error("Exception!", (Throwable)e);
                }
            }
        });
        txtAbstrPredInput.addActionListener(e -> {
            String currInput = txtAbstrPredInput.getText();
            if (this.abstrPredProblemsListData.isEmpty() && !currInput.isEmpty()) {
                AbstractionPredicate parsed;
                abstrPredListModel.addElement(currInput);
                txtAbstrPredInput.setText("");
                try {
                    parsed = this.parsePredicate(currInput, this.goal.getLocalNamespaces());
                }
                catch (Exception exc) {
                    throw new RuntimeException(exc);
                }
                this.registeredPredicates.add(parsed);
            }
        });
        lstAbstrPreds.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int selectedIndex = lstAbstrPreds.getSelectedIndex();
                if (e.getKeyCode() == 127 && !abstrPredListModel.isEmpty() && selectedIndex >= 0) {
                    abstrPredListModel.remove(selectedIndex);
                    AbstractionPredicatesChoiceDialog.this.registeredPredicates.remove(selectedIndex);
                }
            }
        });
        return result;
    }

    private JPanel createLatticeTypePanel() {
        JRadioButton simplePredLatticeBtn = new JRadioButton("Simple Predicates Lattice");
        simplePredLatticeBtn.addActionListener(e -> {
            this.latticeType = SimplePredicateAbstractionLattice.class;
        });
        JRadioButton conjPredLatticeBtn = new JRadioButton("Conjunctive Predicates Lattice");
        conjPredLatticeBtn.addActionListener(e -> {
            this.latticeType = ConjunctivePredicateAbstractionLattice.class;
        });
        JRadioButton disjPredLatticeBtn = new JRadioButton("Disjunctive Predicates Lattice");
        disjPredLatticeBtn.addActionListener(e -> {
            this.latticeType = DisjunctivePredicateAbstractionLattice.class;
        });
        ButtonGroup latticeTypeBtnGroup = new ButtonGroup();
        latticeTypeBtnGroup.add(simplePredLatticeBtn);
        latticeTypeBtnGroup.add(conjPredLatticeBtn);
        latticeTypeBtnGroup.add(disjPredLatticeBtn);
        simplePredLatticeBtn.setSelected(true);
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 1));
        result.add(simplePredLatticeBtn);
        result.add(conjPredLatticeBtn);
        result.add(disjPredLatticeBtn);
        return result;
    }

    private JPanel createInfoPanel() {
        String resourcePath = "/de/uka/ilkd/key/gui/";
        String infoHTML = AbstractionPredicatesChoiceDialog.readFromResourceFile("/de/uka/ilkd/key/gui/help/abstrPredsMergeDialogInfo.html");
        String infoCSS = AbstractionPredicatesChoiceDialog.readFromResourceFile("/de/uka/ilkd/key/gui/css/abstrPredsMergeDialog.css");
        assert (infoHTML != null && infoCSS != null) : "Could not find css/html resources for the abstraction predicates choice dialog.";
        String sb = "<html><head><style type=\"text/css\">" + infoCSS + "</style></head><body>" + infoHTML + "</body></html>";
        JTextPane infoLabel = new JTextPane();
        infoLabel.setContentType("text/html");
        infoLabel.setText(sb);
        TitledBorder infoLabelBorder = new TitledBorder("Information on Merges with Predicate Abstraction");
        JPanel infoLabelContainer = new JPanel(new BorderLayout());
        infoLabelContainer.setBorder(infoLabelBorder);
        JScrollPane scrollPane = new JScrollPane(infoLabel, 22, 31);
        scrollPane.setPreferredSize(new Dimension(AbstractionPredicatesChoiceDialog.INITIAL_SIZE.width, 200));
        infoLabelContainer.add((Component)scrollPane, "Center");
        return infoLabelContainer;
    }

    private Pair<Sort, Name> parsePlaceholder(String input) {
        return MergeRuleUtils.parsePlaceholder((String)input, (Services)this.goal.proof().getServices());
    }

    private AbstractionPredicate parsePredicate(String input, NamespaceSet localNamespaces) throws ParserException {
        return MergeRuleUtils.parsePredicate((String)input, this.registeredPlaceholders, (NamespaceSet)localNamespaces, (Services)this.goal.proof().getServices());
    }

    private String abstrPredToStringRepr(Optional<AbstractPredicateAbstractionDomainElement> domElem) {
        if (domElem == null) {
            return "";
        }
        if (!domElem.isPresent()) {
            return "None.";
        }
        AbstractPredicateAbstractionDomainElement predElem = domElem.get();
        if (predElem.getPredicates().size() < 1) {
            return predElem.toString();
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = predElem.getPredicates().iterator();
        while (it.hasNext()) {
            sb.append(this.abstrPredToString((AbstractionPredicate)it.next()));
            if (!it.hasNext()) continue;
            sb.append(predElem.getPredicateNameCombinationString());
        }
        return sb.toString();
    }

    private String abstrPredToString(AbstractionPredicate pred) {
        Services services = MainWindow.getInstance().getMediator().getServices();
        Pair predFormWithPh = pred.getPredicateFormWithPlaceholder();
        return "(" + ((LocationVariable)predFormWithPh.first).toString() + "," + OutputStreamProofSaver.printAnything((Object)predFormWithPh.second, (Services)services) + ")";
    }

    private static URL getURLForResourceFile(Class<?> cl, String filename) {
        URL url = cl.getResource(filename);
        LOGGER.debug("Load Resource:" + filename + " of class " + cl);
        if (url == null && cl.getSuperclass() != null) {
            return AbstractionPredicatesChoiceDialog.getURLForResourceFile(cl.getSuperclass(), filename);
        }
        if (url == null && cl.getSuperclass() == null) {
            LOGGER.error("No resource {} found", (Object)filename);
            return null;
        }
        LOGGER.debug("Done.");
        return url;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String readFromURL(URL url) {
        try (InputStream is = url.openStream();){
            Scanner s = new Scanner(is, StandardCharsets.UTF_8);
            try {
                String string = s.useDelimiter("\\A").next();
                s.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    s.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String readFromResourceFile(String filename) {
        return AbstractionPredicatesChoiceDialog.readFromURL(AbstractionPredicatesChoiceDialog.getURLForResourceFile(AbstractionPredicatesChoiceDialog.class, filename));
    }

    public static void main(String[] args) {
        Proof proof = AbstractionPredicatesChoiceDialog.loadProof("firstTouch/01-Agatha/project.key");
        ArrayList<LocationVariable> differingLocVars = new ArrayList<LocationVariable>();
        differingLocVars.add(new LocationVariable(new ProgramElementName("test"), (Sort)proof.getServices().getNamespaces().sorts().lookup("int")));
        differingLocVars.add(new LocationVariable(new ProgramElementName("test1"), (Sort)proof.getServices().getNamespaces().sorts().lookup("boolean")));
        AbstractionPredicatesChoiceDialog dialog = new AbstractionPredicatesChoiceDialog((Goal)proof.openGoals().head(), differingLocVars);
        dialog.setVisible(true);
    }

    static Proof loadProof(String proofFileName) {
        File proofFile = new File("examples/" + proofFileName);
        try {
            KeYEnvironment environment = KeYEnvironment.load((Profile)JavaProfile.getDefaultInstance(), (File)proofFile, null, null, null, (boolean)true);
            return environment.getLoadedProof();
        }
        catch (ProblemLoaderException e) {
            return null;
        }
    }

    private class ChoiceTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        private ChoiceTableModel() {
        }

        @Override
        public int getRowCount() {
            return AbstractionPredicatesChoiceDialog.this.abstrPredicateChoices.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "Program Variable";
            }
            if (column == 1) {
                return "Domain Element";
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            AbstractDomainElemChoice row = AbstractionPredicatesChoiceDialog.this.abstrPredicateChoices.get(rowIndex);
            return columnIndex == 0 ? row.getProgVar().sort() + " " + row.getProgVar().name().toString() : row.getAbstrDomElem();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            assert (columnIndex == 2);
            assert (aValue instanceof Optional);
            AbstractionPredicatesChoiceDialog.this.abstrPredicateChoices.get(rowIndex).setAbstrDomElem((Optional)aValue);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }
    }

    class DomElemChoiceTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        public DomElemChoiceTable(ChoiceTableModel model) {
            super(model);
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            if (column != 1) {
                return super.getCellEditor(row, column);
            }
            Sort s = AbstractionPredicatesChoiceDialog.this.abstrPredicateChoices.get(row).getProgVar().sort();
            AbstractDomainLattice lattice = new MergeWithPredicateAbstraction(AbstractionPredicatesChoiceDialog.this.registeredPredicates, AbstractionPredicatesChoiceDialog.this.latticeType, new LinkedHashMap()).getAbstractDomainForSort(s, MainWindow.getInstance().getMediator().getServices());
            JComboBox<Object> items = new JComboBox<Object>();
            items.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    DefaultListCellRenderer result = (DefaultListCellRenderer)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    result.setText(AbstractionPredicatesChoiceDialog.this.abstrPredToStringRepr((Optional)value));
                    return result;
                }
            });
            items.addItem(Optional.empty());
            if (lattice != null) {
                Iterator it = lattice.iterator();
                while (it.hasNext()) {
                    items.addItem(Optional.of((AbstractPredicateAbstractionDomainElement)it.next()));
                }
            }
            return new DefaultCellEditor(items);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            if (column != 1) {
                return super.getCellRenderer(row, column);
            }
            return new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    DefaultTableCellRenderer result = (DefaultTableCellRenderer)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    Optional maybeDomElem = (Optional)value;
                    result.setText(AbstractionPredicatesChoiceDialog.this.abstrPredToStringRepr(maybeDomElem));
                    return result;
                }
            };
        }
    }

    class Result {
        private ArrayList<AbstractionPredicate> registeredPredicates;
        private Class<? extends AbstractPredicateAbstractionLattice> latticeType;
        private LinkedHashMap<ProgramVariable, AbstractDomainElement> abstractDomElemUserChoices = new LinkedHashMap();

        public Result(ArrayList<AbstractionPredicate> registeredPredicates, Class<? extends AbstractPredicateAbstractionLattice> latticeType, List<AbstractDomainElemChoice> userChoices) {
            this.registeredPredicates = registeredPredicates;
            this.latticeType = latticeType;
            userChoices.forEach(choice -> {
                if (choice.isChoiceMade()) {
                    this.abstractDomElemUserChoices.put(choice.getProgVar(), (AbstractDomainElement)choice.getAbstrDomElem().get());
                }
            });
        }

        public ArrayList<AbstractionPredicate> getRegisteredPredicates() {
            return this.registeredPredicates;
        }

        public Class<? extends AbstractPredicateAbstractionLattice> getLatticeType() {
            return this.latticeType;
        }

        public LinkedHashMap<ProgramVariable, AbstractDomainElement> getAbstractDomElemUserChoices() {
            return this.abstractDomElemUserChoices;
        }
    }
}

