/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.mergerule.predicateabstraction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ObservableArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 1L;
    private List<ObservableArrayListChangeListener> listeners = new ArrayList<ObservableArrayListChangeListener>();

    public void addListener(ObservableArrayListChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ObservableArrayListChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void clear() {
        super.clear();
        this.informListeners();
    }

    @Override
    public E set(int index, E element) {
        E result = super.set(index, element);
        this.informListeners();
        return result;
    }

    @Override
    public boolean add(E e) {
        boolean result = super.add(e);
        this.informListeners();
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = super.addAll(c);
        this.informListeners();
        return result;
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        this.informListeners();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean result = super.addAll(index, c);
        this.informListeners();
        return result;
    }

    @Override
    public E remove(int index) {
        Object result = super.remove(index);
        this.informListeners();
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = super.remove(o);
        this.informListeners();
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = super.removeAll(c);
        this.informListeners();
        return result;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
        this.informListeners();
    }

    private void informListeners() {
        this.listeners.stream().forEach((? super T l) -> l.changed());
    }

    @FunctionalInterface
    static interface ObservableArrayListChangeListener {
        public void changed();
    }
}

