/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.nodeviews;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.ApplyTacletDialog;
import de.uka.ilkd.key.gui.GUIListener;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.colors.ColorSettings;
import de.uka.ilkd.key.gui.nodeviews.CurrentGoalViewListener;
import de.uka.ilkd.key.gui.nodeviews.DragNDropInstantiator;
import de.uka.ilkd.key.gui.nodeviews.SequentView;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.pp.InitialPositionTable;
import de.uka.ilkd.key.pp.PosInSequent;
import de.uka.ilkd.key.pp.ProgramPrinter;
import de.uka.ilkd.key.pp.Range;
import de.uka.ilkd.key.pp.SequentPrintFilter;
import de.uka.ilkd.key.pp.SequentViewLogicPrinter;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.rule.TacletApp;
import de.uka.ilkd.key.util.Debug;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.util.EventObject;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CurrentGoalView
extends SequentView
implements Autoscroll {
    private static final long serialVersionUID = 8494000234215913553L;
    public static final ColorSettings.ColorProperty DEFAULT_HIGHLIGHT_COLOR = ColorSettings.define("[currentGoal]defaultHighlight", "", new Color(70, 100, 170, 76));
    public static final ColorSettings.ColorProperty ADDITIONAL_HIGHLIGHT_COLOR = ColorSettings.define("[currentGoal]addtionalHighlight", "", new Color(0, 0, 0, 38));
    private static final ColorSettings.ColorProperty UPDATE_HIGHLIGHT_COLOR = ColorSettings.define("[currentGoal]updateHighlight", "", new Color(0, 150, 130, 38));
    public static final ColorSettings.ColorProperty DND_HIGHLIGHT_COLOR = ColorSettings.define("[currentGoal]dndHighlight", "", new Color(0, 150, 130, 104));
    private static final Logger LOGGER = LoggerFactory.getLogger(CurrentGoalView.class);
    private final KeYMediator mediator;
    private final CurrentGoalViewListener listener;
    private DragSource dragSource;
    private static final Insets autoScrollSensitiveRegion = new Insets(20, 20, 20, 20);
    private final LinkedList<Object> updateHighlights;
    private int lastHighlightedCaretPos;

    public CurrentGoalView(MainWindow mainWindow) {
        super(mainWindow);
        this.mediator = mainWindow.getMediator();
        this.setBackground(Color.white);
        this.setSelectionColor(this.getBackground());
        this.listener = new CurrentGoalViewListener(this, this.getMediator());
        GUIListener guiListener = new GUIListener(){

            @Override
            public void modalDialogOpened(EventObject e) {
                boolean enableDnD = e.getSource() instanceof ApplyTacletDialog;
                CurrentGoalView.this.listener.setModalDragNDropEnabled(enableDnD);
                CurrentGoalView.this.refreshHighlightning = enableDnD;
                CurrentGoalView.this.getDropTarget().setActive(false);
            }

            @Override
            public void modalDialogClosed(EventObject e) {
                if (e.getSource() instanceof ApplyTacletDialog) {
                    CurrentGoalView.this.listener.setModalDragNDropEnabled(false);
                }
                CurrentGoalView.this.refreshHighlightning = true;
                CurrentGoalView.this.getDropTarget().setActive(true);
            }

            @Override
            public void shutDown(EventObject e) {
            }
        };
        this.addMouseListener(this.listener);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 1, this.listener);
        DragNDropInstantiator dragNDropInstantiator = new DragNDropInstantiator(this);
        DropTarget aDropTarget = new DropTarget(this, dragNDropInstantiator);
        this.setAutoscrolls(true);
        this.setDropTarget(aDropTarget);
        this.getMediator().addGUIListener(guiListener);
        this.updateHighlights = new LinkedList();
    }

    void updateUpdateHighlights() {
        if (this.getLogicPrinter() == null) {
            return;
        }
        for (Object e : this.updateHighlights) {
            this.removeHighlight(e);
        }
        this.updateHighlights.clear();
        InitialPositionTable ipt = this.getLogicPrinter().getInitialPositionTable();
        Range[] rangeArray = ipt.getUpdateRanges();
        if (rangeArray != null) {
            for (Range range : rangeArray) {
                range = new Range(range.start() + 1, range.end() + 1);
                Object tag = this.getColorHighlight(UPDATE_HIGHLIGHT_COLOR.get());
                this.updateHighlights.add(tag);
                this.paintHighlight(range, tag);
            }
        }
    }

    public Node jumpToIntroduction(Node node, SequentFormula form) {
        while (node.parent() != null && node.sequent().contains(form)) {
            node = node.parent();
        }
        return node;
    }

    protected DragSource getDragSource() {
        return this.dragSource;
    }

    @Override
    public synchronized void printSequent() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.printSequentImmediately();
        } else {
            Runnable sequentUpdater = this::printSequentImmediately;
            SwingUtilities.invokeLater(sequentUpdater);
        }
    }

    synchronized void printSequentImmediately() {
        if (this.getMainWindow().getMediator().getSelectedNode() == null) {
            return;
        }
        this.removeMouseListener(this.listener);
        CurrentGoalView.setLineWidth(this.computeLineWidth());
        if (this.getLogicPrinter() != null) {
            boolean errorocc;
            this.getLogicPrinter().update(this.getFilter(), CurrentGoalView.getLineWidth());
            do {
                errorocc = false;
                try {
                    this.setText(this.getSyntaxHighlighter().process(this.getLogicPrinter().toString(), this.getMainWindow().getMediator().getSelectedNode()));
                }
                catch (Error e) {
                    LOGGER.error("Error occurred while printing Sequent!", (Throwable)e);
                    errorocc = true;
                }
            } while (errorocc);
        }
        this.updateUpdateHighlights();
        this.updateHeatMapHighlights();
        this.restorePosition();
        this.addMouseListener(this.listener);
        this.updateHidingProperty();
    }

    @Override
    public void highlight(Point p) {
        super.highlight(p);
        this.lastHighlightedCaretPos = this.correctedViewToModel(p);
    }

    void restorePosition() {
        int lastHighlightedCaretPosTmp = this.lastHighlightedCaretPos;
        if (lastHighlightedCaretPosTmp >= 0 && this.getDocument() != null && lastHighlightedCaretPosTmp <= this.getDocument().getLength()) {
            this.setCaretPosition(lastHighlightedCaretPosTmp);
        }
    }

    public void setPrinter(Goal goal) {
        this.getFilter().setSequent(goal.sequent());
        this.setLogicPrinter(new SequentViewLogicPrinter(new ProgramPrinter(null), this.getMediator().getNotationInfo(), this.mediator.getServices(), this.getVisibleTermLabels()));
    }

    protected SequentPrintFilter getSequentPrintFilter() {
        return this.getFilter();
    }

    public final KeYMediator getMediator() {
        return this.mediator;
    }

    void selectedTaclet(TacletApp taclet, PosInSequent pos) {
        KeYMediator r = this.getMediator();
        Goal goal = r.getSelectedGoal();
        Debug.assertTrue((goal != null ? 1 : 0) != 0);
        r.getUI().getProofControl().selectedTaclet(taclet.taclet(), goal, pos.getPosInOccurrence());
    }

    public synchronized void setModalDragNDropEnabled(boolean allowDragNDrop) {
        this.listener.setModalDragNDropEnabled(allowDragNDrop);
    }

    public synchronized boolean modalDragNDropEnabled() {
        return this.listener.modalDragNDropEnabled();
    }

    @Override
    public String getHighlightedText() {
        return this.getHighlightedText(this.getPosInSequent(this.getMousePosition()));
    }

    public PosInSequent getMousePosInSequent() {
        return this.getPosInSequent(this.getMousePosition());
    }

    @Override
    public void autoscroll(Point loc) {
        Insets insets = this.getAutoscrollInsets();
        Rectangle outer = this.getVisibleRect();
        Rectangle inner = new Rectangle(outer.x + insets.left, outer.y + insets.top, outer.width - (insets.left + insets.right), outer.height - (insets.top + insets.bottom));
        if (!inner.contains(loc)) {
            Rectangle scrollRect = new Rectangle(loc.x - insets.left, loc.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
            this.scrollRectToVisible(scrollRect);
        }
    }

    @Override
    public Insets getAutoscrollInsets() {
        return autoScrollSensitiveRegion;
    }

    @Override
    public String getTitle() {
        return "Current Goal";
    }
}

