/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.nodeviews;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.ProofMacroMenu;
import de.uka.ilkd.key.gui.nodeviews.CurrentGoalView;
import de.uka.ilkd.key.gui.nodeviews.CurrentGoalViewMenu;
import de.uka.ilkd.key.gui.nodeviews.PosInSequentTransferable;
import de.uka.ilkd.key.gui.nodeviews.SequentViewListener;
import de.uka.ilkd.key.pp.PosInSequent;
import de.uka.ilkd.key.rule.BuiltInRule;
import de.uka.ilkd.key.rule.TacletApp;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.key_project.util.collection.ImmutableList;

final class CurrentGoalViewListener
extends SequentViewListener<CurrentGoalView>
implements DragGestureListener {
    private final KeYMediator mediator;
    private CurrentGoalViewMenu menu;
    private boolean modalDragNDropEnabled;

    CurrentGoalViewListener(CurrentGoalView currentGoalView, KeYMediator mediator) {
        super(currentGoalView);
        this.mediator = mediator;
        this.menu = new CurrentGoalViewMenu();
        this.setModalDragNDropEnabled(false);
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (!this.modalDragNDropEnabled()) {
            if (Math.abs(System.currentTimeMillis() - this.getLastPopupCloseTime()) >= 400L) {
                PosInSequent mousePos = ((CurrentGoalView)this.getSequentView()).getPosInSequent(me.getPoint());
                boolean macroActive = ProofIndependentSettings.DEFAULT_INSTANCE.getGeneralSettings().isRightClickMacro();
                if (this.mediator != null && mousePos != null) {
                    if (me.isShiftDown()) {
                        this.mediator.getUI().getProofControl().startFocussedAutoMode(mousePos.getPosInOccurrence(), this.mediator.getSelectedGoal());
                    } else if (macroActive && SwingUtilities.isRightMouseButton(me)) {
                        ProofMacroMenu macroMenu = new ProofMacroMenu(this.mediator, mousePos.getPosInOccurrence());
                        if (macroMenu.isEmpty()) {
                            macroMenu.add(new JLabel("No strategies available"));
                        }
                        JPopupMenu popupMenu = macroMenu.getPopupMenu();
                        popupMenu.setLabel("Strategy Macros");
                        popupMenu.show((Component)this.getSequentView(), me.getX() - 5, me.getY() - 5);
                    } else if (!me.isControlDown() && SwingUtilities.isLeftMouseButton(me)) {
                        ImmutableList builtInRules = this.mediator.getUI().getProofControl().getBuiltInRule(this.mediator.getSelectedGoal(), mousePos.getPosInOccurrence());
                        this.menu = new CurrentGoalViewMenu((CurrentGoalView)this.getSequentView(), (ImmutableList<TacletApp>)this.mediator.getUI().getProofControl().getFindTaclet(this.mediator.getSelectedGoal(), mousePos.getPosInOccurrence()), (ImmutableList<TacletApp>)this.mediator.getUI().getProofControl().getRewriteTaclet(this.mediator.getSelectedGoal(), mousePos.getPosInOccurrence()), (ImmutableList<TacletApp>)this.mediator.getUI().getProofControl().getNoFindTaclet(this.mediator.getSelectedGoal()), (ImmutableList<BuiltInRule>)builtInRules, mousePos);
                        this.showPopup(me, this.menu);
                    }
                } else {
                    this.hideMenu(this.menu);
                    ((CurrentGoalView)this.getSequentView()).highlight(me.getPoint());
                }
            } else {
                ((CurrentGoalView)this.getSequentView()).highlight(me.getPoint());
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (!this.modalDragNDropEnabled() && this.menu.isPopupMenuVisible() && !this.menu.getPopupMenu().contains(me.getX() - this.menu.getX(), me.getY() - this.menu.getY())) {
            this.hideMenu(this.menu);
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    public final synchronized void setModalDragNDropEnabled(boolean allowDragNDrop) {
        this.modalDragNDropEnabled = allowDragNDrop;
    }

    public synchronized boolean modalDragNDropEnabled() {
        return this.modalDragNDropEnabled;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dgEvent) {
        final Object oldHighlight = ((CurrentGoalView)this.getSequentView()).getCurrentHighlight();
        ((CurrentGoalView)this.getSequentView()).setCurrentHighlight(((CurrentGoalView)this.getSequentView()).dndHighlight);
        this.hideMenu(this.menu);
        Point dragOrigin = dgEvent.getDragOrigin();
        PosInSequent localMousePos = ((CurrentGoalView)this.getSequentView()).getPosInSequent(dragOrigin);
        if (localMousePos != null) {
            try {
                ((CurrentGoalView)this.getSequentView()).getDragSource().startDrag(dgEvent, DragSource.DefaultCopyDrop, new PosInSequentTransferable(localMousePos, this.mediator.getServices()), new DragSourceAdapter(){

                    @Override
                    public void dragDropEnd(DragSourceDropEvent event) {
                        ((CurrentGoalView)CurrentGoalViewListener.this.getSequentView()).disableHighlight(((CurrentGoalView)CurrentGoalViewListener.this.getSequentView()).dndHighlight);
                        ((CurrentGoalView)CurrentGoalViewListener.this.getSequentView()).setCurrentHighlight(oldHighlight);
                    }
                });
            }
            catch (InvalidDnDOperationException dnd) {
                ((CurrentGoalView)this.getSequentView()).disableHighlight(((CurrentGoalView)this.getSequentView()).dndHighlight);
                ((CurrentGoalView)this.getSequentView()).setCurrentHighlight(oldHighlight);
            }
        }
    }
}

