/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.nodeviews;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.core.Main;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.ProofMacroMenu;
import de.uka.ilkd.key.gui.join.JoinMenuItem;
import de.uka.ilkd.key.gui.mergerule.MergeRuleMenuItem;
import de.uka.ilkd.key.gui.nodeviews.BuiltInRuleMenuItem;
import de.uka.ilkd.key.gui.nodeviews.CurrentGoalView;
import de.uka.ilkd.key.gui.nodeviews.DefaultBuiltInRuleMenuItem;
import de.uka.ilkd.key.gui.nodeviews.DefaultTacletMenuItem;
import de.uka.ilkd.key.gui.nodeviews.InsertHiddenTacletMenuItem;
import de.uka.ilkd.key.gui.nodeviews.InsertSystemInvariantTacletMenuItem;
import de.uka.ilkd.key.gui.nodeviews.MenuItemForTwoModeRules;
import de.uka.ilkd.key.gui.nodeviews.SequentViewMenu;
import de.uka.ilkd.key.gui.nodeviews.TacletMenuItem;
import de.uka.ilkd.key.gui.smt.SMTMenuItem;
import de.uka.ilkd.key.gui.smt.SolverListener;
import de.uka.ilkd.key.java.ProgramElement;
import de.uka.ilkd.key.java.visitor.JavaASTWalker;
import de.uka.ilkd.key.logic.JavaBlock;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.Visitor;
import de.uka.ilkd.key.logic.op.FormulaSV;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.logic.op.SchemaVariable;
import de.uka.ilkd.key.pp.AbbrevException;
import de.uka.ilkd.key.pp.AbbrevMap;
import de.uka.ilkd.key.pp.PosInSequent;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.join.JoinIsApplicable;
import de.uka.ilkd.key.rule.BlockContractExternalRule;
import de.uka.ilkd.key.rule.BlockContractInternalRule;
import de.uka.ilkd.key.rule.BuiltInRule;
import de.uka.ilkd.key.rule.FindTaclet;
import de.uka.ilkd.key.rule.LoopContractExternalRule;
import de.uka.ilkd.key.rule.LoopContractInternalRule;
import de.uka.ilkd.key.rule.LoopScopeInvariantRule;
import de.uka.ilkd.key.rule.RewriteTaclet;
import de.uka.ilkd.key.rule.Rule;
import de.uka.ilkd.key.rule.RuleSet;
import de.uka.ilkd.key.rule.Taclet;
import de.uka.ilkd.key.rule.TacletApp;
import de.uka.ilkd.key.rule.TacletSchemaVariableCollector;
import de.uka.ilkd.key.rule.UseOperationContractRule;
import de.uka.ilkd.key.rule.WhileInvariantRule;
import de.uka.ilkd.key.rule.merge.MergeRule;
import de.uka.ilkd.key.rule.tacletbuilder.RewriteTacletGoalTemplate;
import de.uka.ilkd.key.rule.tacletbuilder.TacletGoalTemplate;
import de.uka.ilkd.key.settings.DefaultSMTSettings;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.ViewSettings;
import de.uka.ilkd.key.smt.SMTProblem;
import de.uka.ilkd.key.smt.SMTSettings;
import de.uka.ilkd.key.smt.SolverLauncher;
import de.uka.ilkd.key.smt.SolverLauncherListener;
import de.uka.ilkd.key.smt.SolverTypeCollection;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;

public final class CurrentGoalViewMenu
extends SequentViewMenu<CurrentGoalView> {
    private static final long serialVersionUID = 8151230546928796116L;
    private static final String INTRODUCE_AXIOM_TACLET_NAME = "introduceAxiom";
    private static final String CREATE_ABBREVIATION = "Create abbreviation...";
    private static final String ENABLE_ABBREVIATION = "Enable abbreviation";
    private static final String DISABLE_ABBREVIATION = "Disable abbreviation";
    private static final String CHANGE_ABBREVIATION = "Change abbreviation...";
    private static final String MORE_RULES = "More rules";
    private static final String APPLY_CONTRACT = "Apply Contract";
    private static final String CHOOSE_AND_APPLY_CONTRACT = "Choose and Apply Contract...";
    private static final String ENTER_LOOP_SPECIFICATION = "Enter Loop Specification...";
    private static final String APPLY_RULE = "Apply Rule";
    private static final String NO_RULES_APPLICABLE = "No rules applicable.";
    private Set<String> clutterRuleSets;
    private Set<String> clutterRules;
    public static final int TOO_MANY_TACLETS_THRESHOLD = 15;
    private KeYMediator mediator;
    private TacletAppComparator comp = new TacletAppComparator();

    CurrentGoalViewMenu() {
        this.initClutterRules();
    }

    CurrentGoalViewMenu(CurrentGoalView sequentView, ImmutableList<TacletApp> findList, ImmutableList<TacletApp> rewriteList, ImmutableList<TacletApp> noFindList, ImmutableList<BuiltInRule> builtInList, PosInSequent pos) {
        super(sequentView, pos);
        this.mediator = sequentView.getMediator();
        this.initClutterRules();
        this.createMenu((ImmutableList<TacletApp>)CurrentGoalViewMenu.removeRewrites(findList).prepend(rewriteList), CurrentGoalViewMenu.removeIntroduceAxiomTaclet(noFindList), builtInList, new MenuControl());
    }

    private static ImmutableList<TacletApp> removeIntroduceAxiomTaclet(ImmutableList<TacletApp> list) {
        return (ImmutableList)list.stream().filter(app -> !app.rule().name().toString().equals(INTRODUCE_AXIOM_TACLET_NAME)).collect(ImmutableSLList.toImmutableList());
    }

    public static ImmutableList<TacletApp> removeRewrites(ImmutableList<TacletApp> list) {
        ImmutableSLList result = ImmutableSLList.nil();
        for (TacletApp tacletApp : list) {
            Taclet taclet = tacletApp.taclet();
            result = taclet instanceof RewriteTaclet ? result : result.prepend((Object)tacletApp);
        }
        return result;
    }

    private void initClutterRules() {
        ViewSettings vs = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings();
        this.clutterRuleSets = vs.getClutterRuleSets();
        this.clutterRules = vs.getClutterRules();
        vs.addSettingsListener(e -> {
            this.clutterRuleSets = vs.getClutterRuleSets();
            this.clutterRules = vs.getClutterRules();
        });
    }

    private void createMenu(ImmutableList<TacletApp> find, ImmutableList<TacletApp> noFind, ImmutableList<BuiltInRule> builtInList, MenuControl control) {
        PosInOccurrence occ;
        boolean rulesAvailable;
        this.addActionListener(control);
        ImmutableList toAdd = CurrentGoalViewMenu.sort(find, this.comp);
        boolean bl = rulesAvailable = find.size() > 0;
        if (this.getPos() != null && this.getPos().isSequent()) {
            rulesAvailable |= noFind.size() > 0;
            toAdd = toAdd.prepend(noFind);
        }
        if (rulesAvailable) {
            this.addToMenu(toAdd, control);
        } else {
            this.add(new JLabel(NO_RULES_APPLICABLE));
        }
        this.createBuiltInRuleMenu(builtInList, control);
        this.createDelayedCutJoinMenu(control);
        this.createMergeRuleMenu();
        if (this.getPos() != null && this.getPos().isSequent()) {
            this.createSMTMenu(control);
        }
        this.createFocussedAutoModeMenu(control);
        this.addMacroMenu();
        this.addSeparator();
        this.addExtensionMenu();
        this.addSeparator();
        this.addClipboardItem(control);
        if (this.getPos() != null && (occ = this.getPos().getPosInOccurrence()) != null && occ.posInTerm() != null) {
            ProgramVariable var;
            Term t = occ.subTerm();
            this.createAbbrevSection(t, control);
            if (t.op() instanceof ProgramVariable && (var = (ProgramVariable)t.op()).getProgramElementName().getCreationInfo() != null) {
                this.createNameCreationInfoSection(control);
            }
        }
    }

    private void createBuiltInRuleMenu(ImmutableList<BuiltInRule> builtInList, MenuControl control) {
        if (!builtInList.isEmpty()) {
            this.addSeparator();
            Iterator it = builtInList.iterator();
            while (it.hasNext()) {
                this.addBuiltInRuleItem((BuiltInRule)it.next(), control);
            }
        }
    }

    private void addMacroMenu() {
        ProofMacroMenu menu = new ProofMacroMenu(this.mediator, this.getPos().getPosInOccurrence());
        if (!menu.isEmpty()) {
            this.add(menu);
        }
    }

    private void createSMTMenu(MenuControl control) {
        Collection solverUnions = ProofIndependentSettings.DEFAULT_INSTANCE.getSMTSettings().getSolverUnions(Main.isExperimentalMode());
        if (!solverUnions.isEmpty()) {
            this.addSeparator();
        }
        for (SolverTypeCollection union : solverUnions) {
            if (!union.isUsable()) continue;
            SMTMenuItem item = new SMTMenuItem(union);
            item.addActionListener(control);
            this.add(item);
        }
    }

    private void createDelayedCutJoinMenu(MenuControl control) {
        List partner;
        if (Main.isExperimentalMode() && !(partner = JoinIsApplicable.INSTANCE.isApplicable(this.mediator.getSelectedGoal(), this.getPos().getPosInOccurrence())).isEmpty()) {
            JoinMenuItem item = new JoinMenuItem(partner, this.mediator.getSelectedProof(), this.mediator);
            this.add(item);
        }
    }

    private void createMergeRuleMenu() {
        if (MergeRule.isOfAdmissibleForm((Goal)this.mediator.getSelectedGoal(), (PosInOccurrence)this.getPos().getPosInOccurrence(), (boolean)true)) {
            MergeRuleMenuItem item = new MergeRuleMenuItem(this.mediator.getSelectedGoal(), this.getPos().getPosInOccurrence(), this.mediator);
            this.add(item);
        }
    }

    private void addBuiltInRuleItem(BuiltInRule builtInRule, MenuControl control) {
        if (builtInRule != LoopScopeInvariantRule.INSTANCE) {
            if (builtInRule == WhileInvariantRule.INSTANCE) {
                MenuItemForTwoModeRules item = new MenuItemForTwoModeRules(builtInRule.displayName(), APPLY_RULE, "Applies a known and complete loop specification immediately.", ENTER_LOOP_SPECIFICATION, "Allows to modify an existing or to enter a new loop specification.", builtInRule);
                ((AbstractButton)item).addActionListener(control);
                this.add(item);
            } else if (builtInRule == BlockContractInternalRule.INSTANCE) {
                MenuItemForTwoModeRules item = new MenuItemForTwoModeRules(builtInRule.displayName(), APPLY_RULE, "Applies a known and complete block specification immediately.", CHOOSE_AND_APPLY_CONTRACT, "Asks to select the contract to be applied.", builtInRule);
                ((AbstractButton)item).addActionListener(control);
                this.add(item);
            } else if (builtInRule == BlockContractExternalRule.INSTANCE) {
                MenuItemForTwoModeRules item = new MenuItemForTwoModeRules(builtInRule.displayName(), APPLY_RULE, "All available contracts of the block are combined and applied.", CHOOSE_AND_APPLY_CONTRACT, "Asks to select the contract to be applied.", builtInRule);
                ((AbstractButton)item).addActionListener(control);
                this.add(item);
            } else if (builtInRule == LoopContractInternalRule.INSTANCE) {
                MenuItemForTwoModeRules item = new MenuItemForTwoModeRules(builtInRule.displayName(), APPLY_RULE, "Applies a known and complete loop block specification immediately.", CHOOSE_AND_APPLY_CONTRACT, "Asks to select the contract to be applied.", builtInRule);
                ((AbstractButton)item).addActionListener(control);
                this.add(item);
            } else if (builtInRule == LoopContractExternalRule.INSTANCE) {
                MenuItemForTwoModeRules item = new MenuItemForTwoModeRules(builtInRule.displayName(), APPLY_RULE, "All available contracts of the loop block are combined and applied.", CHOOSE_AND_APPLY_CONTRACT, "Asks to select the contract to be applied.", builtInRule);
                ((AbstractButton)item).addActionListener(control);
                this.add(item);
            } else if (builtInRule == UseOperationContractRule.INSTANCE) {
                MenuItemForTwoModeRules item = new MenuItemForTwoModeRules(builtInRule.displayName(), APPLY_CONTRACT, "All available contracts of the method are combined and applied.", CHOOSE_AND_APPLY_CONTRACT, "Asks to select the contract to be applied.", builtInRule);
                ((AbstractButton)item).addActionListener(control);
                this.add(item);
            } else if (builtInRule != MergeRule.INSTANCE) {
                DefaultBuiltInRuleMenuItem item = new DefaultBuiltInRuleMenuItem(builtInRule);
                item.addActionListener(control);
                this.add(item);
            }
        }
    }

    private void createFocussedAutoModeMenu(MenuControl control) {
        this.addSeparator();
        FocussedRuleApplicationMenuItem item = new FocussedRuleApplicationMenuItem();
        item.addActionListener(control);
        this.add(item);
    }

    public static ImmutableList<TacletApp> sort(ImmutableList<TacletApp> finds, TacletAppComparator comp) {
        ImmutableSLList result = ImmutableSLList.nil();
        ArrayList<TacletApp> list = new ArrayList<TacletApp>(finds.size());
        for (TacletApp app : finds) {
            list.add(app);
        }
        Collections.sort(list, comp);
        for (TacletApp app : list) {
            result = result.prepend((Object)app);
        }
        return result;
    }

    private void createAbbrevSection(Term t, MenuControl control) {
        AbbrevMap scm = this.mediator.getNotationInfo().getAbbrevMap();
        JMenuItem sc = null;
        if (scm.containsTerm(t)) {
            sc = new JMenuItem(CHANGE_ABBREVIATION);
            sc.addActionListener(control);
            this.add(sc);
            sc = scm.isEnabled(t) ? new JMenuItem(DISABLE_ABBREVIATION) : new JMenuItem(ENABLE_ABBREVIATION);
        } else {
            sc = new JMenuItem(CREATE_ABBREVIATION);
        }
        sc.addActionListener(control);
        this.add(sc);
    }

    private void addToMenu(ImmutableList<TacletApp> taclets, MenuControl control) {
        InsertHiddenTacletMenuItem insHiddenItem = new InsertHiddenTacletMenuItem(MainWindow.getInstance(), this.mediator.getNotationInfo(), this.mediator.getServices());
        InsertSystemInvariantTacletMenuItem insSystemInvItem = new InsertSystemInvariantTacletMenuItem(MainWindow.getInstance(), this.mediator.getNotationInfo(), this.mediator.getServices());
        ArrayList<Object> normalTaclets = new ArrayList<Object>();
        ArrayList<TacletApp> rareTaclets = new ArrayList<TacletApp>();
        for (TacletApp app : taclets) {
            Taclet taclet = app.taclet();
            if (insHiddenItem.isResponsible(taclet)) {
                insHiddenItem.add(app);
                continue;
            }
            if (insSystemInvItem.isResponsible(taclet)) {
                insSystemInvItem.add(app);
                continue;
            }
            if (!this.mediator.getFilterForInteractiveProving().filter((Rule)taclet)) continue;
            if (this.isRareRule(taclet)) {
                rareTaclets.add(app);
                continue;
            }
            normalTaclets.add(app);
        }
        normalTaclets.addAll(rareTaclets);
        int currentSize = 0;
        JMenu target = this;
        for (TacletApp app : normalTaclets) {
            target.add(this.createMenuItem(app, control));
            if (++currentSize < 15) continue;
            JMenu newTarget = new JMenu(MORE_RULES);
            target.add(newTarget);
            target = newTarget;
            currentSize = 0;
        }
        if (insHiddenItem.getAppSize() > 0) {
            this.add(insHiddenItem);
            insHiddenItem.addActionListener(control);
        }
        if (insSystemInvItem.getAppSize() > 0) {
            this.add(insSystemInvItem);
            insSystemInvItem.addActionListener(control);
        }
    }

    private boolean isRareRule(Taclet taclet) {
        if (this.clutterRules.contains(taclet.name().toString())) {
            return true;
        }
        return taclet.getRuleSets().stream().anyMatch(it -> this.clutterRuleSets.contains(it.name().toString()));
    }

    private Component createMenuItem(TacletApp app, MenuControl control) {
        DefaultTacletMenuItem item = new DefaultTacletMenuItem(this, app, this.mediator.getNotationInfo(), this.mediator.getServices());
        item.addActionListener(control);
        return item;
    }

    void invisible() {
        for (int i = 0; i < this.getMenuComponentCount(); ++i) {
            if (!(this.getMenuComponent(i) instanceof JMenu)) continue;
            ((JMenu)this.getMenuComponent(i)).getPopupMenu().setVisible(false);
        }
    }

    public static class TacletAppComparator
    implements Comparator<TacletApp> {
        private int countFormulaSV(TacletSchemaVariableCollector c) {
            int formulaSV = 0;
            Iterator it = c.varIterator();
            while (it.hasNext()) {
                SchemaVariable sv = (SchemaVariable)it.next();
                if (!(sv instanceof FormulaSV)) continue;
                ++formulaSV;
            }
            return formulaSV;
        }

        private int measureGoalComplexity(ImmutableList<TacletGoalTemplate> l) {
            int result = 0;
            for (TacletGoalTemplate gt : l) {
                if (gt instanceof RewriteTacletGoalTemplate && ((RewriteTacletGoalTemplate)gt).replaceWith() != null) {
                    result += ((RewriteTacletGoalTemplate)gt).replaceWith().depth();
                }
                if (gt.sequent().isEmpty()) continue;
                result += 10;
            }
            return result;
        }

        public int programComplexity(JavaBlock b) {
            if (b.isEmpty()) {
                return 0;
            }
            return new JavaASTWalker((ProgramElement)b.program()){
                private int counter;
                {
                    super(arg0);
                    this.counter = 0;
                }

                protected void doAction(ProgramElement pe) {
                    ++this.counter;
                }

                public int getCounter() {
                    this.counter = 0;
                    this.start();
                    return this.counter;
                }
            }.getCounter();
        }

        @Override
        public int compare(TacletApp o1, TacletApp o2) {
            LinkedHashMap<String, Integer> map1 = this.score(o1);
            LinkedHashMap<String, Integer> map2 = this.score(o2);
            Iterator<Map.Entry<String, Integer>> it1 = map1.entrySet().iterator();
            Iterator<Map.Entry<String, Integer>> it2 = map2.entrySet().iterator();
            while (it1.hasNext() && it2.hasNext()) {
                int v2;
                String s2;
                String s1 = it1.next().getKey();
                if (!s1.equals(s2 = it2.next().getKey())) {
                    throw new IllegalStateException("A decision should have been made on a higher level ( " + s1 + "<->" + s2 + ")");
                }
                int v1 = map1.get(s1);
                if (v1 < (v2 = map2.get(s2).intValue())) {
                    return 1;
                }
                if (v1 <= v2) continue;
                return -1;
            }
            return 0;
        }

        public LinkedHashMap<String, Integer> score(TacletApp o1) {
            LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
            Taclet taclet1 = o1.taclet();
            map.put("closing", taclet1.goalTemplates().size() == 0 ? -1 : 1);
            boolean calc = false;
            for (RuleSet rs : taclet1.getRuleSets()) {
                String s = rs.name().toString();
                if (!s.equals("simplify_literals") && !s.equals("concrete") && !s.equals("update_elim") && !s.equals("replace_known_left") && !s.equals("replace_known_right")) continue;
                calc = true;
            }
            map.put("calc", calc ? -1 : 1);
            int formulaSV1 = 0;
            int cmpVar1 = 0;
            if (taclet1 instanceof FindTaclet) {
                map.put("has_find", -1);
                Term find1 = ((FindTaclet)taclet1).find();
                int findComplexity1 = find1.depth();
                map.put("find_complexity", -(findComplexity1 += this.programComplexity(find1.javaBlock())));
                TacletSchemaVariableCollector coll1 = new TacletSchemaVariableCollector();
                find1.execPostOrder((Visitor)coll1);
                formulaSV1 = this.countFormulaSV(coll1);
                map.put("num_sv", -(cmpVar1 += -coll1.size()));
            } else {
                map.put("has_find", 1);
            }
            map.put("sans_formula_sv", -(cmpVar1 -= formulaSV1));
            map.put("if_seq", taclet1.ifSequent().isEmpty() ? 1 : -1);
            map.put("num_goals", taclet1.goalTemplates().size());
            map.put("goal_compl", this.measureGoalComplexity((ImmutableList<TacletGoalTemplate>)taclet1.goalTemplates()));
            return map;
        }
    }

    static class FocussedRuleApplicationMenuItem
    extends JMenuItem {
        private static final String APPLY_RULES_AUTOMATICALLY_HERE = "Apply rules automatically here";
        private static final long serialVersionUID = -6486650015103963268L;

        public FocussedRuleApplicationMenuItem() {
            super(APPLY_RULES_AUTOMATICALLY_HERE);
            this.setToolTipText("<html>Initiates and restricts automatic rule applications on the highlighted formula, term or sequent.<br> 'Shift + left mouse click' on the highlighted entity does the same.</html>");
        }
    }

    class MenuControl
    extends SequentViewMenu.MenuControl {
        MenuControl() {
            super(CurrentGoalViewMenu.this);
        }

        private boolean validAbbreviation(String s) {
            if (s == null || s.length() == 0) {
                return false;
            }
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) <= '9' && s.charAt(i) >= '0' || s.charAt(i) <= 'z' && s.charAt(i) >= 'a' || s.charAt(i) <= 'Z' && s.charAt(i) >= 'A' || s.charAt(i) == '_') continue;
                return false;
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof TacletMenuItem) {
                ((CurrentGoalView)CurrentGoalViewMenu.this.getPopupMenu().getInvoker()).selectedTaclet(((TacletMenuItem)e.getSource()).connectedTo(), CurrentGoalViewMenu.this.getPos());
            } else if (e.getSource() instanceof SMTMenuItem) {
                SMTMenuItem item = (SMTMenuItem)e.getSource();
                SolverTypeCollection solverUnion = item.getSolverUnion();
                Goal goal = CurrentGoalViewMenu.this.mediator.getSelectedGoal();
                assert (goal != null);
                Thread thread = new Thread(() -> {
                    DefaultSMTSettings settings = new DefaultSMTSettings(goal.proof().getSettings().getSMTSettings(), ProofIndependentSettings.DEFAULT_INSTANCE.getSMTSettings(), goal.proof().getSettings().getNewSMTSettings(), goal.proof());
                    SolverLauncher launcher = new SolverLauncher((SMTSettings)settings);
                    launcher.addListener((SolverLauncherListener)new SolverListener(settings, goal.proof()));
                    LinkedList<SMTProblem> list = new LinkedList<SMTProblem>();
                    list.add(new SMTProblem(goal));
                    launcher.launch((Collection)solverUnion.getTypes(), list, goal.proof().getServices());
                }, "SMTRunner");
                thread.start();
            } else if (e.getSource() instanceof BuiltInRuleMenuItem) {
                BuiltInRuleMenuItem birmi = (BuiltInRuleMenuItem)e.getSource();
                CurrentGoalViewMenu.this.mediator.getUI().getProofControl().selectedBuiltInRule(CurrentGoalViewMenu.this.mediator.getSelectedGoal(), birmi.connectedTo(), CurrentGoalViewMenu.this.getPos().getPosInOccurrence(), birmi.forcedApplication(), true);
            } else if (e.getSource() instanceof FocussedRuleApplicationMenuItem) {
                CurrentGoalViewMenu.this.mediator.getUI().getProofControl().startFocussedAutoMode(CurrentGoalViewMenu.this.getPos().getPosInOccurrence(), CurrentGoalViewMenu.this.mediator.getSelectedGoal());
            } else {
                PosInOccurrence occ = CurrentGoalViewMenu.this.getPos().getPosInOccurrence();
                switch (((JMenuItem)e.getSource()).getText()) {
                    case "Disable abbreviation": {
                        if (occ == null || occ.posInTerm() == null) break;
                        CurrentGoalViewMenu.this.mediator.getNotationInfo().getAbbrevMap().setEnabled(occ.subTerm(), false);
                        ((CurrentGoalView)CurrentGoalViewMenu.this.getSequentView()).printSequent();
                        break;
                    }
                    case "Enable abbreviation": {
                        if (occ == null || occ.posInTerm() == null) break;
                        CurrentGoalViewMenu.this.mediator.getNotationInfo().getAbbrevMap().setEnabled(occ.subTerm(), true);
                        ((CurrentGoalView)CurrentGoalViewMenu.this.getSequentView()).printSequent();
                        break;
                    }
                    case "Create abbreviation...": {
                        if (occ == null || occ.posInTerm() == null) break;
                        String oldTerm = occ.subTerm().toString();
                        String term = oldTerm.length() > 200 ? oldTerm.substring(0, 200) : oldTerm;
                        String abbreviation = (String)JOptionPane.showInputDialog(new JFrame(), "Enter abbreviation for term: \n" + term, "New Abbreviation", 3, null, null, "");
                        try {
                            if (abbreviation == null) break;
                            if (!this.validAbbreviation(abbreviation)) {
                                JOptionPane.showMessageDialog(new JFrame(), "Only letters, numbers and '_' are allowed for Abbreviations", "Sorry", 1);
                                break;
                            }
                            CurrentGoalViewMenu.this.mediator.getNotationInfo().getAbbrevMap().put(occ.subTerm(), abbreviation, true);
                            ((CurrentGoalView)CurrentGoalViewMenu.this.getSequentView()).printSequent();
                        }
                        catch (AbbrevException sce) {
                            JOptionPane.showMessageDialog(new JFrame(), sce.getMessage(), "Sorry", 1);
                        }
                        break;
                    }
                    case "Change abbreviation...": {
                        if (occ == null || occ.posInTerm() == null) break;
                        String abbreviation = (String)JOptionPane.showInputDialog(new JFrame(), "Enter abbreviation for term: \n" + occ.subTerm().toString(), "Change Abbreviation", 3, null, null, CurrentGoalViewMenu.this.mediator.getNotationInfo().getAbbrevMap().getAbbrev(occ.subTerm()).substring(1));
                        try {
                            if (abbreviation == null) break;
                            if (!this.validAbbreviation(abbreviation)) {
                                JOptionPane.showMessageDialog(new JFrame(), "Only letters, numbers and '_'are allowed for Abbreviations", "Sorry", 1);
                                break;
                            }
                            CurrentGoalViewMenu.this.mediator.getNotationInfo().getAbbrevMap().changeAbbrev(occ.subTerm(), abbreviation);
                            ((CurrentGoalView)CurrentGoalViewMenu.this.getSequentView()).printSequent();
                        }
                        catch (AbbrevException sce) {
                            JOptionPane.showMessageDialog(new JFrame(), sce.getMessage(), "Sorry", 1);
                        }
                        break;
                    }
                    default: {
                        super.actionPerformed(e);
                    }
                }
            }
        }
    }
}

