/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.nodeviews;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.nodeviews.TacletMenuItem;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.pp.LogicPrinter;
import de.uka.ilkd.key.pp.NotationInfo;
import de.uka.ilkd.key.pp.ProgramPrinter;
import de.uka.ilkd.key.pp.SequentViewLogicPrinter;
import de.uka.ilkd.key.pp.VisibleTermLabels;
import de.uka.ilkd.key.rule.TacletApp;
import de.uka.ilkd.key.rule.inst.SVInstantiations;
import de.uka.ilkd.key.rule.tacletbuilder.TacletGoalTemplate;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.util.pp.Backend;
import de.uka.ilkd.key.util.pp.WriterBackend;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.JMenuItem;
import org.key_project.util.collection.ImmutableList;

class DefaultTacletMenuItem
extends JMenuItem
implements TacletMenuItem {
    private static final long serialVersionUID = -5537139155045230424L;
    private TacletApp connectedTo;

    public DefaultTacletMenuItem(JMenuItem menu, TacletApp connectedTo, NotationInfo notationInfo, Services services) {
        super(connectedTo.taclet().displayName());
        ImmutableList templates;
        this.connectedTo = connectedTo;
        StringBuilder taclet_sb = new StringBuilder();
        StringWriter w = new StringWriter();
        WriterBackend backend = new WriterBackend((Writer)w, 68);
        SVInstantiations instantiations = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().getShowUninstantiatedTaclet() ? SVInstantiations.EMPTY_SVINSTANTIATIONS : connectedTo.instantiations();
        SequentViewLogicPrinter tp = new SequentViewLogicPrinter(new ProgramPrinter((Writer)w, instantiations), notationInfo, (Backend)backend, services, true, (VisibleTermLabels)MainWindow.getInstance().getVisibleTermLabels());
        tp.printTaclet(connectedTo.taclet(), instantiations, ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().getShowWholeTaclet(), false);
        int nlcount = 0;
        StringBuffer sb = w.getBuffer();
        int maxTooltipLines = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().getMaxTooltipLines();
        int sbl = sb.length();
        boolean truncated = false;
        for (int i = 0; i < sbl && !truncated; ++i) {
            if (sb.charAt(i) != '\n' || ++nlcount <= maxTooltipLines) continue;
            sb.setLength(i);
            truncated = true;
        }
        taclet_sb.append("<html><pre>");
        taclet_sb.append(this.ascii2html(sb));
        taclet_sb.append("</pre>");
        if (truncated) {
            taclet_sb.append("\n<b>!!</b><i> Message has been truncated. See View &rarr; ToolTip Options.</i>");
        }
        this.setToolTipText(taclet_sb.toString());
        if (this.getText().equals("insert_hidden") && (templates = connectedTo.taclet().goalTemplates()).size() == 1) {
            LogicPrinter printer = new LogicPrinter(new ProgramPrinter(), new NotationInfo(), services, true);
            printer.setInstantiation(connectedTo.instantiations());
            printer.printSequent(((TacletGoalTemplate)templates.head()).sequent());
            Object s = printer.toString();
            if (((String)s).length() > 40) {
                s = ((String)s).substring(0, 37) + "...";
            }
            this.setText((String)s);
        }
    }

    protected final StringBuffer ascii2html(StringBuffer sb) {
        StringBuffer nsb = new StringBuffer();
        StringBuffer asb = DefaultTacletMenuItem.removeEmptyLines(sb);
        int sbl = asb.length();
        block6: for (int i = 0; i < sbl; ++i) {
            switch (asb.charAt(i)) {
                case '<': {
                    nsb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    nsb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    nsb.append("&amp;");
                    continue block6;
                }
                case '\n': {
                    nsb.append("<br>");
                    continue block6;
                }
                default: {
                    nsb.append(asb.charAt(i));
                }
            }
        }
        return nsb;
    }

    private static StringBuffer removeEmptyLines(StringBuffer sb) {
        String string = sb.toString();
        string = string.replaceAll("(?m)^[ \t]*\r?\n|\n$", "");
        sb.setLength(0);
        sb.append(string);
        return sb;
    }

    @Override
    public TacletApp connectedTo() {
        return this.connectedTo;
    }
}

