/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.nodeviews;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.nodeviews.CurrentGoalView;
import de.uka.ilkd.key.gui.nodeviews.DefaultTacletMenuItem;
import de.uka.ilkd.key.gui.nodeviews.PosInSequentTransferable;
import de.uka.ilkd.key.gui.nodeviews.SimpleTacletSelectionMenu;
import de.uka.ilkd.key.gui.nodeviews.TacletMenuItem;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.PosInTerm;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.op.SchemaVariable;
import de.uka.ilkd.key.pp.PosInSequent;
import de.uka.ilkd.key.rule.FindTaclet;
import de.uka.ilkd.key.rule.IfFormulaInstSeq;
import de.uka.ilkd.key.rule.MatchConditions;
import de.uka.ilkd.key.rule.NoPosTacletApp;
import de.uka.ilkd.key.rule.PosTacletApp;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.rule.Taclet;
import de.uka.ilkd.key.rule.TacletApp;
import de.uka.ilkd.key.rule.inst.IllegalInstantiationException;
import de.uka.ilkd.key.rule.tacletbuilder.TacletGoalTemplate;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JPopupMenu;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;

public class DragNDropInstantiator
extends DropTargetAdapter {
    private CurrentGoalView seqView;

    DragNDropInstantiator(CurrentGoalView seqView) {
        this.seqView = seqView;
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        Point dropLocation = event.getLocation();
        try {
            Transferable transferable = event.getTransferable();
            if (transferable.isDataFlavorSupported(PosInSequentTransferable.POS_IN_SEQUENT_TRANSFER)) {
                this.interpreteDragAndDropInstantiation(event, dropLocation, transferable);
            } else if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                try {
                    event.acceptDrop(event.getSourceActions());
                    List files = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    for (File f : files) {
                        MainWindow.getInstance().loadProblem(f);
                    }
                    event.dropComplete(true);
                }
                catch (ClassCastException ex) {
                    event.rejectDrop();
                }
            } else {
                event.rejectDrop();
            }
        }
        catch (IOException exception) {
            event.rejectDrop();
        }
        catch (UnsupportedFlavorException ufException) {
            event.rejectDrop();
        }
        this.seqView.requestFocus();
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.seqView.autoscroll(dtde.getLocation());
        this.seqView.paintHighlights(dtde.getLocation());
    }

    private void interpreteDragAndDropInstantiation(DropTargetDropEvent event, Point dropLocation, Transferable transferable) throws UnsupportedFlavorException, IOException {
        boolean equalTargetPosition;
        PosInSequent sourcePos = (PosInSequent)transferable.getTransferData(PosInSequentTransferable.POS_IN_SEQUENT_TRANSFER);
        PosInSequent targetPos = this.seqView.getPosInSequent(dropLocation);
        if (targetPos == null || sourcePos == null || sourcePos.isSequent()) {
            event.rejectDrop();
            return;
        }
        Services services = this.seqView.getMediator().getServices();
        ImmutableList<PosTacletApp> applicableApps = this.getAllApplicableApps(sourcePos, targetPos, services);
        if (applicableApps.isEmpty() && !targetPos.isSequent() && targetPos.getPosInOccurrence().posInTerm() != PosInTerm.getTopLevel()) {
            applicableApps = this.getAllApplicableApps(sourcePos, PosInSequent.createCfmaPos((PosInOccurrence)targetPos.getPosInOccurrence().up()), services);
        }
        if (!(equalTargetPosition = sourcePos.getPosInOccurrence().equals((Object)targetPos.getPosInOccurrence())) && applicableApps.size() == 1) {
            this.execute((PosTacletApp)applicableApps.head());
        } else if (applicableApps.size() >= 1) {
            SimpleTacletSelectionMenu menu = new SimpleTacletSelectionMenu(applicableApps, this.seqView.getMediator().getNotationInfo(), new PopupListener(), services);
            JPopupMenu pm = menu.getPopupMenu();
            pm.show(this.seqView, (int)dropLocation.getX(), (int)dropLocation.getY());
        } else {
            event.rejectDrop();
            return;
        }
        event.getDropTargetContext().dropComplete(true);
    }

    private ImmutableList<PosTacletApp> getAllApplicableApps(PosInSequent sourcePos, PosInSequent targetPos, Services services) {
        Sequent sequent = this.seqView.getMediator().getSelectedGoal().sequent();
        ImmutableSLList applicableApps = ImmutableSLList.nil();
        applicableApps = targetPos.isSequent() ? applicableApps.prepend(this.completeIfInstantiations(this.getApplicableTaclets(sourcePos, TacletFilter.TACLET_WITH_NO_IF_FIND_AND_ADDRULE, services), sequent, targetPos.getPosInOccurrence(), services)) : (ProofIndependentSettings.DEFAULT_INSTANCE.getGeneralSettings().isDndDirectionSensitive() ? applicableApps.prepend(this.getDirectionDependentApps(sourcePos, targetPos, services, sequent)) : applicableApps.prepend(this.getDirectionIndependentApps(sourcePos, targetPos, services, sequent)));
        return applicableApps;
    }

    private ImmutableList<PosTacletApp> getDirectionDependentApps(PosInSequent sourcePos, PosInSequent targetPos, Services services, Sequent sequent) {
        ImmutableSLList applicableApps = ImmutableSLList.nil();
        applicableApps = applicableApps.prepend(this.completeIfInstantiations(this.getApplicableTaclets(sourcePos, TacletFilter.TACLET_WITH_IF_FIND_AND_NO_REPLACEWITH, services), sequent, targetPos.getPosInOccurrence(), services));
        applicableApps = applicableApps.prepend(this.completeIfInstantiations(this.getApplicableTaclets(targetPos, TacletFilter.TACLET_WITH_IF_FIND_AND_REPLACEWITH, services), sequent, sourcePos.getPosInOccurrence(), services));
        applicableApps = applicableApps.prepend(this.completeInstantiations(this.getApplicableTaclets(sourcePos, TacletFilter.TACLET_WITH_NO_IF, services), targetPos.getPosInOccurrence(), services));
        return applicableApps;
    }

    private ImmutableList<PosTacletApp> getDirectionIndependentApps(PosInSequent sourcePos, PosInSequent targetPos, Services services, Sequent sequent) {
        return this.getDirectionDependentApps(sourcePos, targetPos, services, sequent).prepend(this.getDirectionDependentApps(targetPos, sourcePos, services, sequent));
    }

    private ImmutableList<PosTacletApp> getApplicableTaclets(PosInSequent findPos, TacletFilter filter, Services services) {
        if (findPos == null || findPos.isSequent()) {
            return ImmutableSLList.nil();
        }
        ImmutableSLList allTacletsAtFindPosition = ImmutableSLList.nil();
        KeYMediator r = this.seqView.getMediator();
        for (TacletApp app : r.getUI().getProofControl().getFindTaclet(r.getSelectedGoal(), findPos.getPosInOccurrence())) {
            if (!filter.satisfiesFilterCondition(app.taclet())) continue;
            allTacletsAtFindPosition = allTacletsAtFindPosition.prepend((Object)app);
        }
        return this.addPositionInformation((ImmutableList<TacletApp>)allTacletsAtFindPosition, findPos.getPosInOccurrence(), services);
    }

    private ImmutableList<PosTacletApp> addPositionInformation(ImmutableList<TacletApp> tacletApps, PosInOccurrence findPos, Services services) {
        ImmutableSLList applicableApps = ImmutableSLList.nil();
        for (TacletApp tacletApp : tacletApps) {
            TacletApp app = tacletApp;
            if (app instanceof NoPosTacletApp) {
                app = PosTacletApp.createPosTacletApp((FindTaclet)((FindTaclet)app.taclet()), (MatchConditions)app.matchConditions(), (PosInOccurrence)findPos, (Services)services);
            }
            applicableApps = applicableApps.prepend((Object)((PosTacletApp)app));
        }
        return applicableApps;
    }

    private ImmutableList<PosTacletApp> completeIfInstantiations(ImmutableList<PosTacletApp> apps, Sequent seq, PosInOccurrence ifPIO, Services services) {
        ImmutableList ifFmlInst;
        ImmutableSLList result = ImmutableSLList.nil();
        if (ifPIO == null || !ifPIO.isTopLevel()) {
            ifFmlInst = null;
        } else {
            IfFormulaInstSeq ifInst = new IfFormulaInstSeq(seq, ifPIO.isInAntec(), ifPIO.sequentFormula());
            ifFmlInst = ImmutableSLList.nil().prepend((Object)ifInst);
        }
        for (PosTacletApp app1 : apps) {
            PosTacletApp app = app1;
            Sequent ifSequent = app.taclet().ifSequent();
            if (ifSequent != null && !ifSequent.isEmpty()) {
                if (ifSequent.size() != 1) {
                    app = null;
                } else {
                    if (ifFmlInst == null) {
                        return ImmutableSLList.nil();
                    }
                    if (((IfFormulaInstSeq)ifFmlInst.head()).inAntec() == (ifSequent.succedent().size() == 0)) {
                        app = (PosTacletApp)app.setIfFormulaInstantiations(ifFmlInst, services);
                    }
                }
            }
            if (app == null || !app.complete()) continue;
            result = result.prepend((Object)app);
        }
        return result;
    }

    private ImmutableList<PosTacletApp> completeInstantiations(ImmutableList<PosTacletApp> apps, PosInOccurrence missingSVPIO, Services services) {
        ImmutableSLList result = ImmutableSLList.nil();
        if (missingSVPIO == null) {
            return ImmutableSLList.nil();
        }
        for (PosTacletApp app1 : apps) {
            SchemaVariable missingSV;
            PosTacletApp app = app1;
            Sequent ifSequent = app.taclet().ifSequent();
            if (ifSequent != null && !ifSequent.isEmpty() || app.uninstantiatedVars().size() != 1 || !app.isInstantiationRequired(missingSV = (SchemaVariable)app.uninstantiatedVars().iterator().next())) continue;
            try {
                app = (PosTacletApp)app.addCheckedInstantiation(missingSV, missingSVPIO.subTerm(), services, true);
            }
            catch (IllegalInstantiationException ie) {
                app = null;
            }
            if (app == null || !app.complete()) continue;
            result = result.prepend((Object)app);
        }
        return result;
    }

    private void execute(PosTacletApp app) {
        if (app == null) {
            return;
        }
        KeYMediator mediator = this.seqView.getMediator();
        mediator.getUI().getProofControl().applyInteractive((RuleApp)app, mediator.getSelectedGoal());
    }

    protected static interface TacletFilter {
        public static final TacletFilter TACLET_WITH_IF_FIND_AND_REPLACEWITH = new TacletWithIfFindAndReplacewith();
        public static final TacletFilter TACLET_WITH_IF_FIND_AND_NO_REPLACEWITH = new TacletWithIfFindAndNoReplacewith();
        public static final TacletFilter TACLET_WITH_NO_IF_FIND_AND_ADDRULE = new TacletWithNoIfFindAndAddrule();
        public static final TacletFilter TACLET_WITH_NO_IF = new TacletWithNoIf();

        public boolean satisfiesFilterCondition(Taclet var1);

        public static class TacletWithNoIf
        implements TacletFilter {
            private TacletWithNoIf() {
            }

            @Override
            public boolean satisfiesFilterCondition(Taclet taclet) {
                Sequent ifSequent = taclet.ifSequent();
                return (ifSequent == null || ifSequent.isEmpty()) && taclet instanceof FindTaclet;
            }
        }

        public static class TacletWithNoIfFindAndAddrule
        implements TacletFilter {
            private TacletWithNoIfFindAndAddrule() {
            }

            private boolean goalTemplatesContainAddrules(ImmutableList<TacletGoalTemplate> goalDescriptions) {
                for (TacletGoalTemplate tgt : goalDescriptions) {
                    if (tgt.rules().size() < 1) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean satisfiesFilterCondition(Taclet taclet) {
                return (taclet.ifSequent() == null || taclet.ifSequent().isEmpty()) && taclet instanceof FindTaclet && this.goalTemplatesContainAddrules((ImmutableList<TacletGoalTemplate>)taclet.goalTemplates());
            }
        }

        public static class TacletWithIfFindAndNoReplacewith
        implements TacletFilter {
            private TacletWithIfFindAndNoReplacewith() {
            }

            @Override
            public boolean satisfiesFilterCondition(Taclet taclet) {
                return taclet.ifSequent() != null && !taclet.ifSequent().isEmpty() && taclet instanceof FindTaclet && !taclet.hasReplaceWith();
            }
        }

        public static class TacletWithIfFindAndReplacewith
        implements TacletFilter {
            private TacletWithIfFindAndReplacewith() {
            }

            @Override
            public boolean satisfiesFilterCondition(Taclet taclet) {
                return taclet.ifSequent() != null && !taclet.ifSequent().isEmpty() && taclet instanceof FindTaclet && taclet.hasReplaceWith();
            }
        }
    }

    private class PopupListener
    implements ActionListener {
        private PopupListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof DefaultTacletMenuItem) {
                TacletMenuItem item = (TacletMenuItem)e.getSource();
                DragNDropInstantiator.this.execute((PosTacletApp)item.connectedTo());
            }
        }
    }
}

